#include <dir.h>
#include <dos.h>
#include <string.h>
#include <stddef.h>
#include <malloc.h>
#include <errno.h>

char *_getdcwd( int drive, char *pathbuf, size_t length )
{
    char *buf = pathbuf;

    if( length == 0 ) length = _MAX_DIR + 3;

    if( buf == NULL && ( buf = malloc( length ) ) == NULL ) {
        errno = ENOMEM;
        return( NULL );
    }

    strcpy( buf, "A:\\" );
    *buf += ( drive ) ? drive - 1 : getdisk(); 

    if( getcurdir( drive, &buf[ 3 ] ) == -1 ) {
        errno = ENODEV;
        return( NULL );
    }

    return( buf );
}

