#include <conio.h>
#include "globals.h"

int cputs( const char *str )
{
    const char *s = str;
    char ch = 0;

    if( !__conio_initialized ) __initialize_conio();

    while( *s++ ) {
        ch = *s;
        switch( *s ) {
            case '\0':
                return( *s );
            case '\a':
                __beep();
                break;
            case '\b':
                if( __cury > 0 )
                    __cury--;
                else {
                    __curx--;
                    __cury = __screenwidth;
                }
                break;
            case '\t':
                do  {
                    __gotoxy( __startx + __curx, __starty + __cury );
                    __putch( ' ' );
                    __cury++;
                } while( ( __cury % 8 ) && ( __cury < __screenwidth ) );
                break;
            case '\r':
                __cury = 0;
                break;
            case '\n':
                __curx++;
                __cury = 0;
                break;
            default:
                __gotoxy( __startx + __curx, __starty + __cury );
                __putch( ch );
                __cury++;
        }
        if( __cury > __screenwidth ) {
            __cury = 0;
            __curx++;
        }
        if( __curx > __screenheight ) {
            if( _wscroll ) 
                __scroll( __startx,
                          __starty,
                          __endx,
                          __endy,
                          __cur_attr,
                          0x06,
                          1 );
            __curx--;
        }
        gotoxy( __cury + 1, __curx + 1 );
    }

    return( ch );
}
