/* db.h */

/* include file for a simple key-value db */

/*
  Copyright (C) 1999-2000 Jim Hall <jhall1@isd.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _DB_H
#define _DB_H

/* Symbolic constants */

#define HASHSIZE 101

/* Typedefs and structs */

struct db_list{
  struct db_list *next;
  char *key;
  char *value;
};

typedef struct db_list db_t;


/* Functions */

/* db.c */

int db_init (size_t init_size);
int db_free (void);
db_t *db_insert (char *key, char *value);
int db_compare (db_t *p1, db_t *p2);
db_t *db_fetch (char *key);

#endif /* _DB_H */
