\ Copyright (C) 2008 Stephan Becher
\
\ This file is part of StrongForth.f.
\
\ StrongForth.f is free software; you can redistribute it and/or modify
\ it under the terms of the GNU General Public License as published by
\ the Free Software Foundation; either version 2 of the License, or
\ (at your option) any later version.
\
\ StrongForth.f is distributed in the hope that it will be useful,
\ but WITHOUT ANY WARRANTY; without even the implied warranty of
\ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
\ GNU General Public License for more details.
\
\ You should have received a copy of the GNU General Public License
\ along with StrongForth.f; if not, write to the Free Software
\ Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
\
\ Contact: stephan.becher@vr-web.de

\ If possible, warning "redefined" should be disabled.

\ If the Search-Order word set is available, it is recommended to compile
\ all StrongForth words except for STRONG into a dedicated word set.

\ Set CONSTANT CASE-INSENSITIVE to TRUE if you prefer a case-insensitive 
\ dictionary search. Dictionary headers are always compiled with upper-case 
\ names.

\ Use 'HOST and IMPORT to import words defined in the host system to 
\ StrongForth.f, e. g.
\
\ 'HOST DUMP IMPORT DUMP ( ADDRESS UNSIGNED -- )
\
\ If the word to be imported is a parsing word, 'HOST should be replaced 
\ with 'HOST-PARSING. 'HOST-PARSING creates a wrapper definition that 
\ ensures parsing is done correctly. Here's an example:
\
\ 'HOST-PARSING SEE IMPORT SEE ( -- )

\ Required ANS word sets:
\ CORE
\ DOUBLE
\ EXCEPTION
\ FILE
\ LOCALS
\ STRING
\ TOOLS

\ Implemented word sets:
\ CORE
\ DOUBLE
\ EXCEPTION
\ FILE
\ LOCALS
\ SEARCH
\ STRING

\ Data type hierarchy:
\ SINGLE
\   INTEGER
\     UNSIGNED
\     SIGNED
\     CHARACTER
\   ADDRESS
\     CADDRESS
\   LOGICAL
\     FLAG
\   DEFINITION
\   TOKEN
\     SEARCH-CRITERION
\   FILE
\   FAM
\   WID
\   R-SIZE
\   CONTROL-FLOW
\ DOUBLE
\   INTEGER-DOUBLE
\     UNSIGNED-DOUBLE
\       NUMBER-DOUBLE
\     SIGNED-DOUBLE
\   DATA-TYPE
\     STACK-DIAGRAM
\ TUPLE
\   INPUT-SOURCE
\ SYS
\   ORIG/DEST
\     ORIG
\     DEST
\   COLON-SYS
\     DOES-SYS
\   DO-SYS
\   CASE-SYS
\   OF-SYS

FALSE CONSTANT CASE-INSENSITIVE IMMEDIATE

BL WORD -ROT FIND [IF] DROP [ELSE] : -ROT ROT ROT ; [THEN]
BL WORD NOOP FIND [IF] DROP [ELSE] : NOOP         ; [THEN]

VARIABLE #ORDER
VARIABLE CURRENT
VARIABLE VOC-LINK
VARIABLE DTP-COMP
VARIABLE DTP-EXEC
VARIABLE DP
VARIABLE LP
VARIABLE CFSP

CREATE DT-COMP-BOTTOM 40 CELLS ALLOT
HERE CONSTANT DT-COMP-TOP
CREATE DT-EXEC-BOTTOM 40 CELLS ALLOT
HERE CONSTANT DT-EXEC-TOP
CREATE DICT-BOTTOM 10000 CELLS ALLOT
HERE CONSTANT DICT-TOP

DICT-BOTTOM DP !

CREATE REFERENCES 31 CELLS ALLOT
VARIABLE DATA-BOT
VARIABLE DATA-PTR
VARIABLE DATA-TOP

 9 CONSTANT #VOCS
20 CONSTANT #NESTING

CREATE CONTEXT #VOCS CELLS ALLOT
CREATE CFSTACK #NESTING CELLS ALLOT

  32 CONSTANT NONAME-ATTRIBUTE
 128 CONSTANT IMMEDIATE-ATTRIBUTE
 256 CONSTANT DATA-TYPE-ATTRIBUTE
 512 CONSTANT DEFERRED-ATTRIBUTE
1024 CONSTANT VALUE-ATTRIBUTE
2048 CONSTANT 2VALUE-ATTRIBUTE
4096 CONSTANT VOCABULARY-ATTRIBUTE
8192 CONSTANT VIRTUAL-ATTRIBUTE

0 VALUE LATEST
0 VALUE LATEST-DOES
0 VALUE SOURCE-ID
-1 CONSTANT STRING-ID
2VARIABLE SOURCE-SPEC

CREATE TIB 256 CHARS ALLOT
VARIABLE #TIB
CREATE FIB 1024 CHARS ALLOT
VARIABLE #FIB
CREATE STR 80 CHARS ALLOT
VARIABLE #STR

CREATE ERROR-MESSAGES 300 CELLS ALLOT
ERROR-MESSAGES 300 CELLS ERASE

: MESSAGE,( ( n -- )
  HERE ERROR-MESSAGES ROT CELLS + !
  [CHAR] ) PARSE DUP C, HERE SWAP DUP CHARS ALLOT CMOVE ;

  1 MESSAGE,( ABORT)
  2 MESSAGE,( ABORT")
  3 MESSAGE,( stack overflow)
  4 MESSAGE,( stack underflow)
  5 MESSAGE,( return stack overflow)
  6 MESSAGE,( return stack underflow)
  7 MESSAGE,( do-loops nested too deeply during execution)
  8 MESSAGE,( dictionary overflow)
  9 MESSAGE,( invalid memory address)
 10 MESSAGE,( division by zero)
 11 MESSAGE,( result out of range)
 12 MESSAGE,( argument type mismatch)
 13 MESSAGE,( undefined word)
 14 MESSAGE,( interpreting a compile-only word)
 15 MESSAGE,( invalid FORGET)
 16 MESSAGE,( attempt to use zero-length string as a name)
 17 MESSAGE,( pictured numeric output string overflow)
 18 MESSAGE,( parsed string overflow)
 19 MESSAGE,( definition name too long)
 20 MESSAGE,( write to a read-only location)
 21 MESSAGE,( unsupported operation)
 22 MESSAGE,( control structure mismatch)
 23 MESSAGE,( address alignment exception)
 24 MESSAGE,( invalid numeric argument)
 25 MESSAGE,( return stack imbalance)
 26 MESSAGE,( loop parameters unavailable)
 27 MESSAGE,( invalid recursion)
 28 MESSAGE,( user interrupt)
 29 MESSAGE,( compiler nesting)
 30 MESSAGE,( obsolescent feature)
 31 MESSAGE,( >BODY used on non-CREATEd definition)
 32 MESSAGE,( invalid name argument)
 33 MESSAGE,( block read exception)
 34 MESSAGE,( block write exception)
 35 MESSAGE,( invalid block number)
 36 MESSAGE,( invalid file position)
 37 MESSAGE,( file I/O exception)
 38 MESSAGE,( non-existent file)
 39 MESSAGE,( unexpected end of file)
 40 MESSAGE,( invalid BASE for floating point conversion)
 41 MESSAGE,( loss of precision)
 42 MESSAGE,( floating-point divide by zero)
 43 MESSAGE,( floating-point result out of range)
 44 MESSAGE,( floating-point stack overflow)
 45 MESSAGE,( floating-point stack underflow)
 46 MESSAGE,( floating-point invalid argument)
 47 MESSAGE,( compilation word list deleted)
 48 MESSAGE,( invalid POSTPONE)
 49 MESSAGE,( search-order overflow)
 50 MESSAGE,( search-order underflow)
 51 MESSAGE,( compilation word list changed)
 52 MESSAGE,( control-flow stack overflow)
 53 MESSAGE,( exception stack overflow)
 54 MESSAGE,( floating-point underflow)
 55 MESSAGE,( floating-point unidentified fault)
 56 MESSAGE,( QUIT)
 57 MESSAGE,( exception in sending or receiving a character)
 58 MESSAGE,( [IF], [ELSE], or [THEN] exception)
256 MESSAGE,( data type heap overflow)
257 MESSAGE,( data type heap underflow)
258 MESSAGE,( data types not congruent)
259 MESSAGE,( too many parameters)
260 MESSAGE,( is not a data type)
261 MESSAGE,( invalid reference)
262 MESSAGE,( invalid stack diagram)
263 MESSAGE,( local syntax violation)
264 MESSAGE,( definition not untouched)
265 MESSAGE,( is no subtype of TOKEN)
266 MESSAGE,( test failed)
267 MESSAGE,( definition has no name)
268 MESSAGE,( not enough memory)
269 MESSAGE,( is no deferred definition)
270 MESSAGE,( is not a colon definition)
271 MESSAGE,( invalid item size)
272 MESSAGE,( invalid index)
273 MESSAGE,( is not a letter)
274 MESSAGE,( is not a code definition)
275 MESSAGE,( empty tuple)
276 MESSAGE,( is no data structure)
277 MESSAGE,( invalid line number)
278 MESSAGE,( text not found)
279 MESSAGE,( out of branching range)
280 MESSAGE,( illegal byte/word combination)
281 MESSAGE,( illegal addressing mode)
282 MESSAGE,( illegal floating-point addressing mode)
283 MESSAGE,( illegal port address)
284 MESSAGE,( invalid interrupt number)
285 MESSAGE,( invalid register operand)
286 MESSAGE,( bit field exceeds cell)
287 MESSAGE,( is not an object)
288 MESSAGE,( is not a virtual member function)
289 MESSAGE,( invalid class)
290 MESSAGE,( is no virtual member)
291 MESSAGE,( has already friends)
292 MESSAGE,( is not a friend)
293 MESSAGE,( trying to execute pure virtual function)
294 MESSAGE,( parent class not yet defined)

: OVER-SD ( n d -- n d n )
  2 PICK ;

: OVER-DS ( d n -- d n d )
  2 PICK 2 PICK ;

: NIP-SD ( n d -- d )
  ROT DROP ;

: NIP-DS ( d n -- n )
  NIP NIP ;

: 2NIP ( d1 d2 -- d2 )
  ROT DROP ROT DROP ;

: TUCK-SD ( n d -- d n d )
  ROT OVER-DS ;

: TUCK-DS ( d n -- n d n )
  -ROT OVER-SD ;

: 2TUCK ( d1 d2 -- d2 d1 d2 )
  2SWAP 2OVER ;

: ROT-SSD ( n1 n2 d -- n2 d n1 )
  3 ROLL ;

: ROT-SDD ( n d1 d2 -- d1 d2 n )
  4 ROLL ;

: ROT-DSD ( d1 n d2 -- n d2 d1 )
  4 ROLL 4 ROLL ;

: C@EXT ( ( c-addr -- n )
  C@ DUP 128 AND IF 256 - THEN ;

: 1CELL ( -- u )
  1 CELLS ;

: 2CELLS ( -- u )
  2 CELLS ;

: 1CHAR ( -- u )
  1 CHARS ;

: DCELLS \ -- u )
  CELLS 2* ;

: CELLS+ ( addr1 n -- addr2 )
  CELLS + ;

: DCELLS+ ( addr1 n -- addr2 )
  DCELLS + ;

: CHARS+ ( c-addr1 n -- c-addr2 )
  CHARS + ;

: UM+ ( d1 u -- d2 )
  0 D+ ;

: CELLS- ( addr1 n -- addr2 )
  CELLS - ;

: DCELLS- ( addr1 n -- addr2 )
  DCELLS - ;

: CHARS- ( c-addr1 n -- c-addr2 )
  CHARS - ;

: UM- ( d1 u -- d2 )
  0 D- ;

: M- ( d1 n -- d2 )
  S>D D- ;

: 2CELLS+ ( addr1 -- addr2 )
  CELL+ CELL+ ;

: CELL- ( addr1 -- addr2 )
  1CELL - ;

: 2CELLS- ( addr1 -- addr2 )
  2 CELLS- ;

: CHAR- ( addr1 -- addr2 )
  1 CHARS- ;

: FILL-S ( addr u n -- )
  ROT DUP >R ROT CELLS+ R> ?DO DUP I ! 1CELL +LOOP DROP ;

: FILL-D ( addr u d -- )
  3 ROLL >R ROT R@ SWAP DCELLS+ R> ?DO 2DUP I 2! 2CELLS +LOOP 2DROP ;

: ERASE-S ( addr u -- )
  CELLS ERASE ;

: ERASE-D ( addr u -- )
  2* CELLS ERASE ;

: ERASE-C ( addr u -- )
  CHARS ERASE ;

: MOVE-S ( addr1 addr2 u -- )
  CELLS MOVE ;

: MOVE-D ( addr1 addr2 u -- )
  DCELLS MOVE ;

: MOVE-C ( c-addr1 c-addr2 u -- )
  CHARS MOVE ;

: -S ( addr1 addr2 -- n )
  - 1CELL / ;

: -D ( addr1 addr2 -- n )
  - 2CELLS / ;

: -C ( c-addr1 c-addr2 -- n )
  - 1CHAR / ;

: D1+ ( d1 -- d2 )
  1. D+ ;

: D1- ( d1 -- d2 )
  1. D- ;

: D+! ( d a-addr -- )
  DUP >R 2@ D+ R> 2! ;

: UM+! ( u a-addr -- )
  >R 0 R@ 2@ D+ R> 2! ;

: M+! ( n a-addr -- )
  >R S>D R@ 2@ D+ R> 2! ;

: C+! \ n c-addr -- )
  DUP >R C@ + R> C! ;

: +!-S ( n a-addr -- )
  >R CELLS R@ @ + R> ! ;

: +!-D ( n a-addr -- )
  >R DCELLS R@ @ + R> ! ;

: +!-C ( n a-addr -- )
  >R CHARS R@ @ + R> ! ;

: T* ( ud u -- ut )
  >R SWAP R@ UM* ROT R> UM* ROT UM+ ;

: T/MOD ( ut u1 -- u2 ud )
  DUP >R UM/MOD -ROT R> UM/MOD ROT ;

: TM* ( d1 u -- d2 )
  T* DROP ;

: U/ ( u1 u2 -- u3 )
  0 SWAP UM/MOD NIP ;

: M/ ( ud1 u -- ud2 )
  0 SWAP T/MOD NIP-SD ;

: UMOD ( u1 u2 -- u3 )
  0 SWAP UM/MOD DROP ;

: UMMOD ( ud u1 -- u2 )
  0 SWAP T/MOD 2DROP ;

: U/MOD ( u1 u2 -- u3 u4 )
  0 SWAP UM/MOD ;

: TM/MOD \ ud1 u1 -- u2 ud2 )
  0 SWAP T/MOD ;

: U*/ ( u1 u2 u3 -- u4 )
  >R UM* R> UM/MOD NIP ;

: M*/ ( ud1 u1 u2 -- ud2 )
  >R T* R> T/MOD NIP-SD ;

: U*/MOD ( u1 u2 u3 -- u4 u5 )
  >R UM* R> UM/MOD ;

: TM*/MOD \ ud1 u1 u2 -- u3 ud2 )
  >R T* R> T/MOD ;

: U2/ ( u1 -- u2 )
  1 RSHIFT ;

: DU2/ ( ud1 -- ud2 )
  DUP >R D2/ R> U2/ AND ;

: UMIN ( u1 u2 -- u3 )
  0 SWAP 0 DMIN DROP ;

: DUMIN ( ud1 ud2 -- ud3 )
  2OVER 2OVER DU< INVERT IF 2SWAP THEN 2DROP ;

: UMAX ( u1 u2 -- u3 )
  0 SWAP 0 DMAX DROP ;

: DUMAX ( ud1 ud2 -- ud3 )
  2OVER 2OVER DU< IF 2SWAP THEN 2DROP ;

: DU> ( ud1 ud2 -- flag )
  2SWAP DU< ;

: D> ( d1 d2 -- flag )
  2SWAP D< ;

: D<> ( xd1 xd2 -- flag )
  D= INVERT ;

: D0> ( d -- flag )
  DNEGATE D0< ;

: D0<> ( d -- flag )
  D0= INVERT ;

: 1/STRING ( c-addr1 u1 n -- c-addr2 u2 )
  1 /STRING ;

: 2, ( xd -- )
  , , ;

: DICT-HERE ( -- addr )
  DP @ ;

: DICT, ( x -- )
  DICT-HERE CELL+ DICT-TOP U>
  IF DROP -8 THROW
  ELSE DICT-HERE 1CELL DP +! !
  THEN ;

: 2DICT, ( xd -- )
  DICT-HERE 2CELLS+ DICT-TOP U>
  IF 2DROP -8 THROW
  ELSE DICT-HERE 2CELLS DP +! 2!
  THEN ;

: DICT-ALLOT ( n -- )
  DICT-HERE OVER + DICT-BOTTOM DICT-TOP WITHIN
  IF DP +!
  ELSE DROP -8 THROW
  THEN ;

: DICT-ALIGN ( -- )
  DICT-HERE ALIGNED DP ! ;

: CDICT, ( x -- )
  DICT-HERE CHAR+ DICT-TOP U>
  IF DROP -8 THROW
  ELSE DICT-HERE 1CHAR DP +! C!
  THEN ;

: UPPER ( char1 -- char2 )
  DUP [CHAR] a [ CHAR z 1+ ] LITERAL WITHIN
  IF [ CHAR a CHAR A - ] LITERAL - THEN ;

: UPPER-STRING ( c-addr u -- )
  CHARS OVER + SWAP ?DO I C@ UPPER I C! 1 CHARS +LOOP ;

: DICT-NAME, ( c-addr u -- )
  DUP 31 >
  IF -18 THROW
  ELSE DUP CDICT,
     BEGIN DUP
     WHILE OVER C@ CASE-INSENSITIVE [IF] UPPER [THEN] CDICT, 1/STRING
     REPEAT
  THEN DROP DROP
  DICT-HERE DICT-ALIGN DICT-HERE OVER - BLANK ;

: RDROP ( -- )
  POSTPONE R> POSTPONE DROP ; IMMEDIATE

: DRDROP ( -- )
  POSTPONE 2R> POSTPONE 2DROP ; IMMEDIATE

HEX

0080 CONSTANT PREFIX-ATTRIBUTE

0080. 2CONSTANT DT-PREFIX
0040. 2CONSTANT DT-INPUT
0020. 2CONSTANT DT-OUTPUT
001F. 2CONSTANT DT-OFFSET

DECIMAL

: DT-AND ( dt1 dt2 -- dt3 )
  DROP ROT AND SWAP ;

: DT-OR ( dt1 dt2 -- dt3 )
  DROP ROT OR SWAP ;

: DT-XOR ( dt1 dt2 -- dt3 )
  DROP ROT XOR SWAP ;

: DT-INVERT ( dt1 -- dt2 )
  SWAP INVERT SWAP ;

: DT-ATTRIBUTE? ( dt1 dt2 -- flag )
  DROP NIP AND 0<> ;

: DT-NULL? ( dt1 -- flag )
  NIP 0= ;

: OFFSET ( dt -- u )
  DT-OFFSET DT-AND DROP ;

: OFFSET+ ( dt1 n -- dt2 )
  OVER-DS OFFSET + DUP 0 32 WITHIN
  IF -ROT [ DT-OFFSET DT-INVERT ] 2LITERAL DT-AND ROT 0 DT-OR
  ELSE DROP -259 THROW
  THEN ;

: T> ( tuple1 -- tuple2 x )
  DUP IF 1- SWAP ELSE -275 THROW THEN ;

: 2T> ( tuple1 -- tuple2 xd )
  DUP IF 2 - -ROT ELSE -275 THROW THEN ;

: >T ( tuple1 x -- tuple2 )
  SWAP 1+ ;

: 2>T ( tuple1 xd -- tuple2 )
  ROT 2 + ;

: TDROP ( tuple -- )
  0 ?DO DROP LOOP ;

: DTP ( flag -- a-addr )
  IF DTP-COMP ELSE DTP-EXEC THEN ;

: DT-BOTTOM ( flag -- a-addr )
  IF DT-COMP-BOTTOM ELSE DT-EXEC-BOTTOM THEN ;

: DT-TOP ( flag -- a-addr )
  IF DT-COMP-TOP ELSE DT-EXEC-TOP THEN ;

: DTP@ ( -- a-addr )
  STATE @ DTP @ ;

: DTP! ( -- )
  STATE @ DT-BOTTOM STATE @ DTP ! ;

: DTP| ( -- )
  STATE @ IF 0 DTP-COMP ! THEN ;

: >DT ( dt -- )
  [ DT-INPUT DT-OUTPUT DT-OR DT-INVERT ] 2LITERAL DT-AND
  STATE @ DTP DUP @
  IF STATE @ DT-TOP OVER @ 2CELLS+ U<
     IF DROP 2DROP -256 THROW
     ELSE DUP >R @ 2! 2CELLS R> +!
     THEN
  ELSE DROP 2DROP -256 THROW
  THEN ;

: DT> ( -- dt flag )
  STATE @ DTP DUP @
  IF STATE @ DT-BOTTOM OVER @ 2CELLS- 2DUP SWAP U<
     IF 2DROP DROP -257 THROW 0. FALSE
     ELSE TUCK =
        IF FALSE
        ELSE DUP 2CELLS- 2@ DT-PREFIX DT-ATTRIBUTE?
        THEN >R DUP ROT ! 2@ R>
     THEN
  ELSE DROP -257 THROW 0. FALSE
  THEN ;

: DT-DEPTH ( -- u )
  DTP@ DUP IF STATE @ DT-BOTTOM - THEN 0 2CELLS UM/MOD NIP ;

: PARAM, ( sd1 dt -- sd2 )
  2DICT, 1 OFFSET+ ;

: (PARAM) ( sd1 dt -- sd2 )
  2OVER [ DT-PREFIX DT-INVERT ] 2LITERAL DT-AND
  DT-OR 2SWAP 2DUP DT-NULL?
  IF 2DROP
  ELSE [ DT-PREFIX DT-INPUT DT-OR DT-OUTPUT DT-OR ] 2LITERAL DT-AND PARAM,
  THEN ;

: -- ( sd1 -- sd2 )
  2DUP [ DT-OUTPUT DT-PREFIX DT-OR ] 2LITERAL DT-ATTRIBUTE?
  OVER-DS DT-INPUT DT-ATTRIBUTE? INVERT OR
  IF -262 THROW
  ELSE 0. (PARAM) [ DT-INPUT DT-OUTPUT DT-OR ] 2LITERAL DT-XOR
  THEN ;

: -> ( sd1 -- sd2 )
  2DUP DT-NULL? OVER-DS DT-PREFIX DT-ATTRIBUTE? OR
  IF -262 THROW
  ELSE DT-PREFIX DT-OR
  THEN ;

: TH ( sd1 u -- sd2 )
  -ROT 0. (PARAM) TUCK-SD OFFSET OVER U< OVER 0= OR
  IF DROP -261 THROW
  ELSE OVER-DS OFFSET OVER 1- - DICT-HERE SWAP DCELLS- 2@ 2DUP
     [ DT-OFFSET DT-OUTPUT DT-OR ] 2LITERAL DT-ATTRIBUTE?
     IF 2DROP DROP -261 THROW
     ELSE 0. DT-AND ROT OFFSET+ 2OVER
        [ DT-INPUT DT-OUTPUT DT-OR ] 2LITERAL DT-AND DT-OR PARAM,
     THEN
  THEN ;

: STATE! ( flag -- )
  IF ] ELSE POSTPONE [ THEN ;

: <DIAGRAM ( flag sd1 -- sd2 )
  2DUP [ DT-INPUT DT-PREFIX DT-OR ] 2LITERAL DT-ATTRIBUTE?
  INVERT OVER-DS DT-OUTPUT DT-ATTRIBUTE? AND
  IF 0. (PARAM)
  ELSE -262 THROW
  THEN ROT STATE! ;

: DIAGRAM> ( sd -- )
  OFFSET DCELLS NEGATE DICT-ALLOT ;

: ENCLOSE-DIAGRAM ( sd -- sd a-addr1 a-addr2 )
  2DUP OFFSET >R DICT-HERE DUP R> DCELLS- ;

: PARAM@ ( def u -- dt )
  1+ DCELLS+ 2@ ;

: END-DIAGRAM ( sd -- )
  OFFSET LATEST DUP 2@ ROT-SSD OFFSET+ ROT 2! ;

: PARAMS>DT ( def dt -- )
  2DUP OFFSET
  IF OFFSET 1-
     BEGIN 2DUP OVER SWAP PARAM@ RECURSE
        2DUP PARAM@ DT-PREFIX DT-ATTRIBUTE?
     WHILE 1+
     REPEAT 2DROP
  ELSE >DT DROP
  THEN ;

: ALL-PARAMS>DT ( def u -- def )
  0
  ?DO DUP I PARAM@ 2DUP DT-OUTPUT DT-ATTRIBUTE?
    IF 2DROP LEAVE
    THEN OVER-SD -ROT PARAMS>DT
  LOOP ;

: #PARAMS ( def -- u )
  2@ OFFSET ;

: ) ( flag sd -- )
  <DIAGRAM LATEST #PARAMS IF -264 THROW THEN END-DIAGRAM ;

: GET-CURRENT ( -- wid )
  CURRENT @ ;

: SET-CURRENT ( -- wid )
  CURRENT ! ;

: LATEST! ( -- )
  DICT-HERE TO LATEST ;

: NONAME? ( def -- flag )
  2@ NONAME-ATTRIBUTE 0 DT-ATTRIBUTE? ;

: ?NONAME ( def -- )
  NONAME? IF -267 THROW THEN ;

: NAME ( def -- c-addr u )
  DUP ?NONAME CELL-
  BEGIN CHAR- DUP C@ BL <
  UNTIL COUNT ;

: END-DEF ( -- )
  LATEST NONAME? INVERT
  IF LATEST CELL- >R GET-CURRENT DUP @ R@ @ ROT ! R> !
  THEN ;

: ?COMPILE ( -- )
  STATE @ INVERT IF -14 THROW THEN ;

: ?EXECUTE ( -- )
  STATE @ IF -29 THROW THEN ;

: SOURCE ( -- c-addr u )
  SOURCE-ID STRING-ID =
  IF SOURCE-SPEC 2@
  ELSE SOURCE-ID
     IF FIB #FIB @
     ELSE TIB #TIB @
     THEN
  THEN ;

: CU@+ ( c-addr u1 -- c-addr u2 char )
  2DUP CHARS+ C@ SWAP 1+ SWAP ;

: ENCLOSE ( char c-addr u1 u2 -- c-addr u1 u2 u4 )
  >R TUCK
  BEGIN DUP R@ U<
  WHILE CU@+ 4 PICK =
  UNTIL DUP 1- SWAP RDROP
  ELSE R> SWAP
  THEN 4 ROLL DROP 3 ROLL -ROT ;

: PARSE ( char -- c-addr u )
  SOURCE >IN @ SWAP ENCLOSE >IN ! OVER - -ROT + SWAP ;

: ENCLOSE-WORD ( c-addr u1 u2 -- c-addr u3 u4 u5 )
  >R TUCK
  BEGIN DUP R@ U< INVERT IF ROT DROP R> OVER EXIT THEN CU@+ BL U>
  UNTIL ROT DROP DUP 1- -ROT
  BEGIN DUP R@ U<
  WHILE CU@+ BL > INVERT
  UNTIL DUP 1- SWAP RDROP
  ELSE R> SWAP
  THEN 3 ROLL -ROT ;

: PARSE-WORD ( -- c-addr u )
  SOURCE >IN @ SWAP ENCLOSE-WORD >IN ! OVER - -ROT + SWAP
  DUP 31 > IF -19 THROW THEN ;

: COMMENT ( -- )
  [CHAR] \ PARSE 2DROP ;

: CATENATE ( c-addr1 u1 c-addr2 u2 -- c-addr3 u3 )
  2SWAP >R DICT-HERE R@ CMOVE
  DUP ROT DICT-HERE R@ CHARS+ ROT CMOVE
  DICT-HERE SWAP R> + ;

: 2EVALUATE ( c-addr1 u1 c-addr2 u2 -- )
  CATENATE EVALUATE ;

: PREVIEW-WORD ( -- c-addr u )
  >IN @ PARSE-WORD ROT >IN ! ;

: DEFINE-WORD ( c-addr u -- xt )
  ?EXECUTE PREVIEW-WORD 2EVALUATE S" ' " PREVIEW-WORD 2EVALUATE ;

: ((CREATE)) ( xt c-addr u -- )
  DICT-HERE >R DICT-NAME, ( name field )
  R> DICT, ( link field )
  LATEST! DICT, ( token field )
  IMMEDIATE-ATTRIBUTE DICT, ( attribute field ) ;

: (CREATE) ( xt -- )
  PARSE-WORD ((CREATE)) ;

: (CREATE-NONAME) ( xt -- )
  LATEST! DICT, ( token field )
  [ IMMEDIATE-ATTRIBUTE NONAME-ATTRIBUTE OR ] LITERAL
  DICT, ( attribute field ) ;

: +ATTRIBUTE ( x -- )
  LATEST CELL+ +! ;

: EXPORT ( xt -- )
  BL WORD COUNT ((CREATE)) END-DEF ;

: EXPORT-DT ( xt -- )
  EXPORT DATA-TYPE-ATTRIBUTE +ATTRIBUTE ;

: IMPORT ( xt -- )
  (CREATE) END-DEF ;

: DICT-CREATE ( -- )
  S" CREATE " DEFINE-WORD IMPORT ;

: DICT>BODY ( def -- addr )
  @ >BODY ;

: NAME>LINK ( c-addr -- a-addr )
  COUNT + ALIGNED ;

: NAME>DEFINITION ( c-addr -- def )
  NAME>LINK CELL+ ;

: PREV ( def1 -- def2 )
  DUP ?NONAME CELL- @ DUP IF NAME>DEFINITION THEN ;

: SEARCH-WID ( c-addr u x xt wid -- def n )
  -ROT 2>R @
  CASE-INSENSITIVE [IF] >R >R HERE R@ CMOVE HERE R> 2DUP UPPER-STRING R> [THEN]
  BEGIN DUP
  WHILE DUP NAME>LINK SWAP OVER-SD
     IF 2OVER ROT COUNT COMPARE 0=
     ELSE DROP TRUE
     THEN
     IF CELL+ DUP 2@ IMMEDIATE-ATTRIBUTE 0 DT-ATTRIBUTE?
        2* 1+ OVER 2R@ EXECUTE DUP
        IF 2SWAP 2DROP 2R> 2DROP EXIT
        ELSE DROP CELL-
        THEN
     THEN @
  REPEAT -ROT 2DROP 2R> 2DROP 0 ;

: SEARCH-ALL ( c-addr u x xt -- def n )
  #ORDER @ 0
  ?DO 2OVER 2OVER CONTEXT I CELLS + @ SEARCH-WID DUP
     IF 2>R 2DROP 2DROP 2R> UNLOOP EXIT
     THEN 2DROP
  LOOP 2DROP 2DROP 0 0 ;

: ?DATA-TYPE ( def -- dt )
  DUP 2@ DATA-TYPE-ATTRIBUTE 0 DT-ATTRIBUTE?
  IF DICT>BODY 0 SWAP
  ELSE DROP 0.
  THEN ;

: TOKEN-FIELD ( flag1 def x -- flag2 )
  SWAP @ = AND ;

: ATTRIBUTE-FIELD ( flag1 def x -- flag2 )
  SWAP CELL+ @ AND 0<> AND ;

: DICT' ( -- def )
  PARSE-WORD 0 ['] 2DROP SEARCH-ALL 0= IF -13 THROW THEN ;

: WORDLIST ( -- WID )
  HERE 0 , ;

: (VOCABULARY) ( -- )
  CREATE WORDLIST 0 ,
  DOES> #ORDER @ 0= IF -50 THROW THEN CONTEXT ! ;

(VOCABULARY) FORTH       ' FORTH       >BODY CONSTANT FORTH-WID
(VOCABULARY) LOCAL       ' LOCAL       >BODY CONSTANT LOCAL-WID
(VOCABULARY) ENVIRONMENT ' ENVIRONMENT >BODY CONSTANT ENVIRONMENT-WID

1 #ORDER !
FORTH-WID CURRENT !
FORTH-WID CONTEXT !  

: <LOCALS ( -- )
  0 LOCAL-WID ! DICT-HERE LP ! ;

: LOCALS> ( -- )
  0 LOCAL-WID ! LP @ DP ! ;

: CFSP! ( -- )
  CFSTACK #NESTING CELLS + CFSP ! ;

: >CF ( cf -- )
  ?COMPILE CFSP @ CFSTACK >
  IF -1 CELLS CFSP +! CFSP @ !
  ELSE DROP -52 THROW
  THEN ;

: CF> ( -- cf )
  ?COMPILE CFSP @ [ CFSTACK #NESTING CELLS + ] LITERAL <
  IF CFSP @ @ 1CELL CFSP +!
  ELSE DROP -52 THROW
  THEN ;

: DICT: ( -- colon-sys )
  S" : " PREVIEW-WORD 2EVALUATE 0 (CREATE) ] DTP! CFSP! <LOCALS ;

: DICT:NONAME ( -- def colon-sys )
  DICT-HERE :NONAME 0 (CREATE-NONAME) ] DTP! CFSP! <LOCALS ;

: DT ( -- dt )
  PARSE-WORD DATA-TYPE-ATTRIBUTE ['] ATTRIBUTE-FIELD SEARCH-ALL
  IF ?DATA-TYPE
  ELSE -260 THROW DROP 0.
  THEN ;

: DT-> ( -- )
  DT> DROP DT-PREFIX DT-OR >DT DT >DT ;

: SEARCH-TOKEN ( xt -- def n )
  0. ROT ['] TOKEN-FIELD SEARCH-ALL ;

: ?DEFINITION ( dt -- def )
  NIP CELL+ @ SEARCH-TOKEN DROP ;

: .DT ( dt -- )
  ?DEFINITION 2DUP D0=
  IF 2DROP ." ??? " ELSE NAME TYPE SPACE THEN ;

: .S ( -- )
  DTP@ DUP DT-DEPTH DCELLS-
  ?DO I 2@ 2DUP .DT DT-PREFIX DT-ATTRIBUTE? IF ." -> " THEN
  2CELLS +LOOP ;

: PARENT ( dt1 -- dt2 )
  DUP IF @ THEN ;

: ANCESTOR ( dt1 -- dt2 )
  DUP IF BEGIN DUP @ WHILE @ REPEAT THEN 0. DT-AND ;

: DT-SIZE ( dt -- u )
  ANCESTOR 2DUP D0<> IF 2CELLS+ @ THEN NIP ;

: ?DT-SIZE ( dt -- u )
  DT-SIZE DUP 0= IF -271 THROW THEN ;

: DEPTH-SP ( -- u )
  0 TRUE DTP@ DUP DT-DEPTH DCELLS-
  ?DO IF I 2@ ?DT-SIZE + THEN I 2@ DT-PREFIX DT-ATTRIBUTE? INVERT
  2CELLS +LOOP DROP ;

: DTDROP ( -- dt )
  BEGIN DT> WHILE 2DROP REPEAT ;

: )COLON ( flag sd -- )
  ) LATEST DUP #PARAMS ALL-PARAMS>DT DROP <LOCALS ;

: @>DT ( addr -- )
  BEGIN DUP 2@ 2DUP DT-PREFIX DT-AND >DT DT-PREFIX DT-ATTRIBUTE?
  WHILE 2CELLS+
  REPEAT DROP ;

: NEXT-WORD-PARAM ( addr1 u1 -- addr2 u2 )
  BEGIN 1- OVER 2CELLS+ ROT 2@ DT-PREFIX DT-ATTRIBUTE?
  WHILE SWAP
  REPEAT SWAP ;

: PREV-DATA-PARAM ( addr1 -- addr2 )
  BEGIN 2CELLS- DUP DATA-BOT @ U>
     IF DUP 2CELLS- 2@ DT-PREFIX DT-ATTRIBUTE? INVERT
     ELSE TRUE
     THEN
  UNTIL ;

: SKIP-PARAMETERS ( addr1 addr2 u -- addr3 flag )
  BEGIN DUP
  WHILE OVER 2@ DT-INPUT DT-ATTRIBUTE?
  WHILE OVER-SD DATA-BOT @ U>
     IF ROT PREV-DATA-PARAM -ROT NEXT-WORD-PARAM
     ELSE 2DROP FALSE EXIT
     THEN
  REPEAT
  THEN 2DROP TRUE ;

: DIRECT-MATCH ( addr1 dt -- addr2 flag )
  >R OVER @
  BEGIN DUP R@ <>
  WHILE @ DUP 0=
  UNTIL NIP
  ELSE DROP PREFIX-ATTRIBUTE AND
     IF DUP CELL+ @ PREFIX-ATTRIBUTE AND
        IF 2CELLS+ TRUE
        ELSE FALSE
        THEN
     ELSE
        BEGIN DUP 2CELLS+ SWAP CELL+ @ PREFIX-ATTRIBUTE AND 0=
        UNTIL TRUE
     THEN
  THEN RDROP ;

: REFERENCE-MATCH ( addr1 dt -- addr2 flag )
  OFFSET 1- REFERENCES SWAP CELLS+ @
  BEGIN OVER 2@ DT-PREFIX DT-AND
     OVER-SD 2@ DT-PREFIX DT-AND D=
  WHILE SWAP 2CELLS+ SWAP DUP CELL+ @ PREFIX-ATTRIBUTE AND
  WHILE 2CELLS+
  REPEAT DROP TRUE
  ELSE DROP FALSE
  THEN ;

: MATCH-ALL ( addr1 u addr2 -- flag )
  REFERENCES 2>R
  BEGIN DUP
  WHILE OVER 2@ DT-INPUT DT-ATTRIBUTE?
  WHILE 2R> DUP DATA-BOT U< IF 2DUP ! CELL+ THEN 2>R
     1- OVER 2CELLS+ -ROT 2R> >R ROT 2@ 2DUP OFFSET
     IF REFERENCE-MATCH
     ELSE DIRECT-MATCH
     THEN SWAP R> 2>R INVERT
  UNTIL 2DROP DRDROP FALSE EXIT
  THEN
  THEN 2DROP DRDROP TRUE ;

: INIT-COMPILER-WORKSPACE-EXEC ( -- )
  DT-EXEC-BOTTOM DATA-BOT !
  DTP-EXEC @     DATA-PTR !
  DT-EXEC-TOP    DATA-TOP ! ;

: INIT-COMPILER-WORKSPACE-COMP ( -- )
  DT-COMP-BOTTOM DATA-BOT !
  DTP-COMP @     DATA-PTR !
  DT-COMP-TOP    DATA-TOP ! ;

: INIT-COMPILER-WORKSPACE ( flag -- )
  IF INIT-COMPILER-WORKSPACE-COMP
  ELSE INIT-COMPILER-WORKSPACE-EXEC
  THEN ;

: INPUT-PARAMETER-MATCH ( addr1 u -- addr2 flag )
  DATA-PTR @ OVER-DS SKIP-PARAMETERS
  IF DUP >R MATCH-ALL R> SWAP
  ELSE 2DROP FALSE
  THEN ;

: MOVE-OUTPUT-PARAMETERS ( addr1 addr2 -- addr3 )
  >R DATA-PTR @ R@ ROT DATA-PTR @ - R> OVER + >R MOVE R> ;

: STORE-OUTPUT-PARAMETER ( addr1 dt -- addr2 flag )
  ROT DUP DATA-TOP @ U<
  IF >R DT-PREFIX DT-AND R@ 2! R> 2CELLS+ TRUE
  ELSE NIP-DS FALSE
  THEN ;

: NEXT-DATA-TYPE ( addr1 u1 -- addr2 u2 )
  1- SWAP 2CELLS+ SWAP ;

: SCAN-OUTPUT-PARAMETERS ( addr1 u addr2 -- addr3 flag )
  -ROT
  BEGIN DUP
  WHILE OVER 2@ DT-OUTPUT DT-ATTRIBUTE?
     IF OVER 2@ OFFSET
        IF >R >R REFERENCES R@ 2@ OFFSET 1- CELLS+ @
           BEGIN TUCK 2@ STORE-OUTPUT-PARAMETER INVERT
              IF NIP DRDROP FALSE EXIT THEN
              OVER 2CELLS+ ROT 2@ DT-PREFIX DT-ATTRIBUTE? INVERT
           UNTIL DROP R> R>
        ELSE >R DUP >R 2@ STORE-OUTPUT-PARAMETER R> R> ROT INVERT
           IF 2DROP FALSE EXIT THEN
        THEN
     THEN NEXT-DATA-TYPE
  REPEAT 2DROP TRUE ;

: (CAST) ( addr u flag -- )
  DUP >R INIT-COMPILER-WORKSPACE 2DUP INPUT-PARAMETER-MATCH
  IF >R DATA-PTR @ SCAN-OUTPUT-PARAMETERS
     IF R> MOVE-OUTPUT-PARAMETERS R> DTP !
     ELSE DRDROP -256 THROW
     THEN
  ELSE DROP DROP RDROP -13 THROW
  THEN ;

: DT>DT ( def flag -- xt )
  DUP DTP @ 0= IF -257 THROW THEN
  OVER DUP 2CELLS+ SWAP #PARAMS
  ROT (CAST) @ ;

: DICT-COMPILE, ( def -- )
  TRUE DT>DT COMPILE, ;

: COMPARE-DATA-TYPES ( addr1 addr2 u1 -- addr3 addr4 u2 flag )
  OVER-SD DATA-PTR @ U<
  IF OVER-SD 2@ DT-PREFIX DT-AND 2>R OVER 2@ DT-PREFIX DT-AND 2R> D=
     IF ROT 2CELLS+ -ROT NEXT-DATA-TYPE TRUE
     ELSE FALSE
     THEN
  ELSE FALSE
  THEN ;

: (?CONGRUENT) ( def addr -- addr flag )
  STATE @ INIT-COMPILER-WORKSPACE TUCK OVER 2CELLS+ DUP >R ROT #PARAMS
  BEGIN DUP
  WHILE OVER 2@ DT-OUTPUT DT-ATTRIBUTE?
     IF OVER 2@ OFFSET
        IF ROT R@ 3 PICK 2@ OFFSET 1- DCELLS+ -1
           BEGIN COMPARE-DATA-TYPES INVERT
              IF 2DROP RDROP NIP-DS FALSE EXIT
              THEN OVER 2CELLS- 2@ DT-PREFIX DT-ATTRIBUTE? INVERT
           UNTIL 2DROP -ROT NEXT-DATA-TYPE
        ELSE COMPARE-DATA-TYPES INVERT
           IF 2DROP RDROP FALSE EXIT
           THEN
        THEN
     ELSE NEXT-DATA-TYPE
     THEN
  REPEAT 2DROP RDROP DATA-PTR @ = ;

: (THAW) ( addr1 addr2 -- flag )
  >R INIT-COMPILER-WORKSPACE-COMP DATA-BOT @ SWAP
  BEGIN R@ OVER U>
  WHILE -1 COMPARE-DATA-TYPES NIP 0=
     IF RDROP 2DROP FALSE EXIT
     THEN
  REPEAT RDROP DROP DATA-PTR @ = ;

: ?CONGRUENT ( def addr -- )
  (?CONGRUENT)
  IF STATE @ DTP !
  ELSE DROP -258 THROW
  THEN ;

: ?PARAMS ( -- )
  DTP@ IF LATEST DTP@ DT-DEPTH DCELLS- ?CONGRUENT THEN ;

: DICT-EXIT ( -- )
  ?COMPILE ?PARAMS POSTPONE EXIT DTP| ;

: IDENTITY ( flag1 def x -- flag2 )
  OVER #PARAMS OVER =
  IF SWAP 2CELLS+ SWAP DICT-HERE DUP ROT DCELLS-
     ?DO DUP 2@ I 2@ D<> IF UNLOOP 2DROP FALSE EXIT THEN 2CELLS+
     2CELLS +LOOP DROP
  ELSE 2DROP DROP FALSE
  THEN ;

: DEFERRED ( flag1 def1 def2 -- flag2 )
  >R DUP >R DEFERRED-ATTRIBUTE ATTRIBUTE-FIELD DUP
  IF R> R> OVER #PARAMS OVER #PARAMS =
     IF DUP #PARAMS 0
        ?DO 2DUP I PARAM@ ROT I PARAM@ D= INVERT
           IF UNLOOP 2DROP DROP FALSE EXIT THEN
        2CELLS +LOOP 2DROP
     ELSE 2DROP DROP FALSE
     THEN
  ELSE DRDROP
  THEN ;

: EXECUTE-CONGRUENCE ( def x addr -- flag )
  >R OVER 2CELLS+ ROT #PARAMS DATA-PTR @ SCAN-OUTPUT-PARAMETERS
  IF >R DUP 2CELLS+ SWAP #PARAMS 2DUP DATA-BOT @ MATCH-ALL DROP
     R@ SCAN-OUTPUT-PARAMETERS
     IF R> R@ OVER >R MOVE-OUTPUT-PARAMETERS DATA-BOT @ - R@ + OVER =
        IF R> DATA-BOT @ ROT >R
           BEGIN OVER R@ U<
           WHILE 2DUP 2@ DT-PREFIX DT-AND
              ROT 2@ DT-PREFIX DT-AND D=
           WHILE 2CELLS+ SWAP 2CELLS+ SWAP
           REPEAT 2DROP FALSE
           ELSE 2DROP TRUE
           THEN RDROP
        ELSE DROP RDROP FALSE
        THEN
     ELSE DROP RDROP FALSE
     THEN
  ELSE 2DROP FALSE
  THEN RDROP ;

: MATCH ( flag1 def x -- flag2 )
  ROT DUP >R 2/ OVER IF DROP TRUE THEN STATE @ AND INIT-COMPILER-WORKSPACE
  OVER DUP 2CELLS+ SWAP #PARAMS INPUT-PARAMETER-MATCH
  OVER-SD 1 -1 WITHIN OVER AND
  IF DROP EXECUTE-CONGRUENCE
  ELSE NIP NIP-DS
  THEN R> AND ;

: ?DT>DT ( c-addr u -- xt )
  ?COMPILE TRUE ['] MATCH SEARCH-ALL
  IF TRUE DT>DT ELSE -13 THROW THEN ;

: (DT) ( -- dt )
  0 ' >BODY ;

: (PROCREATES) ( dt -- )
  CREATE , DROP DOES> ( sd addr -- sd ) 0 SWAP (PARAM) ;

0.                     (PROCREATES) SINGLE ' SINGLE , 1 , \ size
(DT) SINGLE            (PROCREATES) INTEGER ' INTEGER ,
(DT) INTEGER           (PROCREATES) UNSIGNED ' UNSIGNED ,
(DT) INTEGER           (PROCREATES) SIGNED ' SIGNED ,
(DT) INTEGER           (PROCREATES) CHARACTER ' CHARACTER ,
(DT) SINGLE            (PROCREATES) ADDRESS ' ADDRESS ,
(DT) ADDRESS           (PROCREATES) CADDRESS ' CADDRESS ,
(DT) SINGLE            (PROCREATES) LOGICAL ' LOGICAL ,
(DT) LOGICAL           (PROCREATES) FLAG ' FLAG ,
(DT) SINGLE            (PROCREATES) DEFINITION ' DEFINITION ,
(DT) SINGLE            (PROCREATES) TOKEN ' TOKEN ,
(DT) TOKEN             (PROCREATES) SEARCH-CRITERION ' SEARCH-CRITERION ,
(DT) SINGLE            (PROCREATES) FILE ' FILE ,
(DT) SINGLE            (PROCREATES) FAM ' FAM ,
(DT) SINGLE            (PROCREATES) WID ' WID ,
(DT) SINGLE            (PROCREATES) R-SIZE ' R-SIZE ,
(DT) SINGLE            (PROCREATES) CONTROL-FLOW ' CONTROL-FLOW ,
0.                     (PROCREATES) DOUBLE ' DOUBLE , 2 , \ size
(DT) DOUBLE            (PROCREATES) INTEGER-DOUBLE ' INTEGER-DOUBLE ,
(DT) INTEGER-DOUBLE    (PROCREATES) UNSIGNED-DOUBLE ' UNSIGNED-DOUBLE ,
(DT) UNSIGNED-DOUBLE   (PROCREATES) NUMBER-DOUBLE ' NUMBER-DOUBLE ,
(DT) INTEGER-DOUBLE    (PROCREATES) SIGNED-DOUBLE ' SIGNED-DOUBLE ,
(DT) DOUBLE            (PROCREATES) DATA-TYPE ' DATA-TYPE ,
(DT) DATA-TYPE         (PROCREATES) STACK-DIAGRAM ' STACK-DIAGRAM ,
0.                     (PROCREATES) TUPLE ' TUPLE , 0 , \ invalid size
(DT) TUPLE             (PROCREATES) INPUT-SOURCE ' INPUT-SOURCE ,
0.                     (PROCREATES) SYS ' SYS , 0 , \ invalid size
(DT) SYS               (PROCREATES) ORIG/DEST ' ORIG/DEST ,
(DT) ORIG/DEST         (PROCREATES) ORIG ' ORIG ,
(DT) ORIG/DEST         (PROCREATES) DEST ' DEST ,
(DT) SYS               (PROCREATES) COLON-SYS ' COLON-SYS ,
(DT) COLON-SYS         (PROCREATES) DOES-SYS ' DOES-SYS ,
(DT) SYS               (PROCREATES) DO-SYS ' DO-SYS ,
(DT) SYS               (PROCREATES) CASE-SYS ' CASE-SYS ,
(DT) SYS               (PROCREATES) OF-SYS ' OF-SYS ,

: >SIGN ( char -- n )
  CASE [CHAR] + OF  1 ENDOF
       [CHAR] - OF -1 ENDOF
       0 SWAP
  ENDCASE ;

: NUMBER ( c-addr u -- d dt )
  0. 2SWAP DUP
  IF OVER C@ >SIGN
  ELSE 0
  THEN DUP >R
     IF 1/STRING
     THEN DUP
  IF DUP >R >NUMBER DUP R> =
  ELSE TRUE
  THEN
  IF 2DROP RDROP 0. EXIT
  THEN DUP
  IF S" ." COMPARE
     IF RDROP 0. EXIT
     THEN R@
     IF [ (DT) SIGNED-DOUBLE ] 2LITERAL
     ELSE [ (DT) UNSIGNED-DOUBLE ] 2LITERAL
     THEN
  ELSE 2DROP R@
     IF [ (DT) SIGNED ] 2LITERAL
     ELSE [ (DT) UNSIGNED ] 2LITERAL
     THEN
  THEN R> 0<
  IF 2SWAP DNEGATE 2SWAP
  THEN ;

: SEARCH-LOCAL ( c-addr u -- addr n )
  0 ['] 2DROP LOCAL-WID SEARCH-WID
  IF 2CELLS+ 1 ELSE 0 THEN ;

: LOCAL, ( c-addr u addr -- )
  ?COMPILE DUP 2@ DT-SIZE
  CASE 1 OF @>DT EVALUATE ENDOF
       2 OF @>DT 2DUP S" R@" COMPARE
            IF 2DUP EVALUATE S" 2~" 2SWAP 2EVALUATE 
            ELSE 2DROP S" 2R@" EVALUATE
            THEN ENDOF
       >R DROP 2DROP R> -271 THROW
  ENDCASE ;

: INTERPRET ( -- )
  BEGIN PARSE-WORD DUP
  WHILE 2DUP SEARCH-LOCAL
     IF LOCAL,
     ELSE DROP 2DUP FALSE ['] MATCH SEARCH-ALL DUP
        IF 2SWAP 2DROP 0< STATE @ AND
           IF DICT-COMPILE,
           ELSE FALSE DT>DT EXECUTE
           THEN
        ELSE 2DROP NUMBER 2DUP D0=
           IF 2DROP DROP -13 THROW
           ELSE 2DUP >DT DT-SIZE 1- STATE @
              IF IF POSTPONE 2LITERAL
                 ELSE D>S POSTPONE LITERAL
                 THEN
              ELSE 0=
                 IF D>S
                 THEN
              THEN
           THEN
        THEN
     THEN
  REPEAT 2DROP ;

: REFILL ( -- flag )
  SOURCE-ID STRING-ID <> DUP
  IF DROP SOURCE-ID
     IF SOURCE-ID DUP FILE-POSITION THROW SOURCE-SPEC 2!
        FIB 1022 ROT READ-LINE THROW SWAP #FIB !
     ELSE TIB 80 ACCEPT #TIB ! SPACE TRUE
     THEN DUP IF 0 >IN ! THEN
  THEN ;

: ?REFILL ( -- )
  SOURCE-ID 0<> SOURCE-ID STRING-ID <> AND
  IF SOURCE-SPEC 2@ SOURCE-ID REPOSITION-FILE THROW
     >IN @ REFILL INVERT IF -37 THROW THEN >IN !
  THEN ;

: STRONG-EVALUATE ( c-addr u -- )
  SOURCE-SPEC 2@ 2>R SOURCE-ID >R >IN @ >R
  0 >IN ! STRING-ID TO SOURCE-ID SOURCE-SPEC 2!
  INTERPRET
  R> >IN ! R> TO SOURCE-ID 2R> SOURCE-SPEC 2! ?REFILL ;

: STRONG-INCLUDE-FILE ( fileid -- )
  SOURCE-SPEC 2@ 2>R SOURCE-ID >R >IN @ >R
  TO SOURCE-ID 0 >IN !
  BEGIN REFILL
  WHILE INTERPRET
  REPEAT SOURCE-ID CLOSE-FILE THROW
  R> >IN ! R> TO SOURCE-ID 2R> SOURCE-SPEC 2! ?REFILL ;

: STRONG-INCLUDED ( c-addr u -- )
  R/O OPEN-FILE THROW STRONG-INCLUDE-FILE ;

: CAST ( -- )
  DTDROP DT 2DUP >DT 2SWAP 2DUP >DT
  DT-SIZE 10 * -ROT DT-SIZE +
  CASE  0 OF                         ENDOF
       11 OF                         ENDOF
       12 OF S" S>D" STRONG-EVALUATE ENDOF
       21 OF S" D>S" STRONG-EVALUATE ENDOF
       22 OF                         ENDOF
       -271 THROW
  ENDCASE DT> DROP 2DROP ;

: [LITERAL] ( -- )
  ?COMPILE S" LITERAL," STRONG-EVALUATE DTP@
  BEGIN DUP 2@ 2DUP
     POSTPONE 2LITERAL POSTPONE >DT DT-PREFIX DT-ATTRIBUTE?
  WHILE 2CELLS+
  REPEAT DROP ;

: FREEZE ( -- cf )
  ?COMPILE DTP@
  IF DICT-HERE DT-DEPTH DCELLS DICT,
     DTP@ DT-DEPTH DCELLS- DICT-HERE DT-DEPTH DCELLS DUP DICT-ALLOT MOVE
  ELSE 0
  THEN ;

: THAW ( cf -- )
  ?COMPILE DUP
  IF DUP @ >R CELL+ DTP@
     IF DUP R> + (THAW) 0= IF -258 THROW THEN
     ELSE DT-COMP-BOTTOM R@ + DTP-COMP ! DT-COMP-BOTTOM R> MOVE
     THEN
  ELSE DTP-COMP !
  THEN ;

: NESTING ( addr n -- )
  SWAP [ 3 CELLS 2 CHARS ALIGNED + ] LITERAL -
  COUNT 1 = IF +! ELSE 2DROP THEN ;

: PARAM@, ( def sd1 u1 u2 -- def sd2 )
  ?DO OVER-SD I PARAM@ PARAM, LOOP ;

: +PARAM ( def u1 -- def u2 )
  BEGIN 2DUP PARAM@ DT-PREFIX DT-ATTRIBUTE?
  WHILE 1+
  REPEAT 1+ ;

: ENCLOSE-PARAMS ( def u1 -- def u2 u3 )
  BEGIN 2DUP +PARAM OVER #PARAMS OVER >
  WHILE 2DUP PARAM@ DT-INPUT DT-ATTRIBUTE?
  WHILE NIP-DS
  REPEAT
  THEN NIP ;

: ?HAS-INPUT-PARAMS ( def -- )
  DUP #PARAMS
  IF 0 PARAM@ DT-OUTPUT DT-ATTRIBUTE?
  ELSE DROP TRUE
  THEN
  IF -262 THROW
  THEN ;

: ?CHECK-REFERENCES ( def u1 u2 -- def u1 u2 )
  OVER-SD #PARAMS OVER
  ?DO OVER-SD I PARAM@ OFFSET OVER-SD > IF -261 THROW THEN
  LOOP ;

: (DOES) ( def -- )
  LATEST #PARAMS 0=
  IF DUP ?HAS-INPUT-PARAMS 0 ENCLOSE-PARAMS ?CHECK-REFERENCES
     >R 0. ROT 0 PARAM@, OVER-SD #PARAMS R> PARAM@,
     END-DIAGRAM
  THEN DROP ;

: STRONG-NO-PARAMS-DOES> ( colon-sys -- does-sys )
  ?COMPILE
  LATEST ?NONAME ?PARAMS POSTPONE DOES> LOCALS> DTP! CFSP! END-DEF
  LATEST TO LATEST-DOES 0 (CREATE-NONAME) ;

: STRONG-DOES> ( colon-sys -- does-sys )
  LP @ POSTPONE LITERAL POSTPONE (DOES)
  STRONG-NO-PARAMS-DOES> ;

: 'LATEST ( -- xt )
  S" ' " LATEST NAME 2EVALUATE ;

: DICT; ( colon-sys -- )
  ?COMPILE ?PARAMS POSTPONE ;
  LATEST NONAME? INVERT IF 'LATEST THEN LATEST !
  LOCALS> DTP| END-DEF ;

: DOES; ( does-sys -- )
  ?COMPILE ?PARAMS LOCALS> DTP| END-DEF
  LATEST-DOES TO LATEST POSTPONE ; 'LATEST LATEST ! ;

: PROMPT ( -- )
  STATE @ INVERT IF ."  OK" THEN ;

: STRONG-QUIT ( -- )
  CR QUIT ;

: 1ST ( STACK-DIAGRAM -- 1ST )
  1 TH ;

: 2ND ( STACK-DIAGRAM -- 1ST )
  2 TH ;

: 3RD ( STACK-DIAGRAM -- 1ST )
  3 TH ;

: IMMEDIATE ( -- )
  LATEST DUP 2@ DT-PREFIX DT-INVERT DT-AND ROT 2! ;

: DU. ( ud -- )
  <# #S #> TYPE SPACE ;

: DU.R ( ud n -- )
  -ROT <# #S #> ROT OVER - SPACES TYPE ;

: IMMEDIATE? ( def -- flag )
  CELL+ @ IMMEDIATE-ATTRIBUTE AND 0= ;

: .DIAGRAM ( def -- )
  TRUE SWAP ." ( " DUP #PARAMS 0
  ?DO 2DUP I PARAM@ DT-OUTPUT DT-ATTRIBUTE? AND
     IF ." -- " SWAP INVERT SWAP THEN DUP I PARAM@ 2DUP OFFSET
     CASE 0 OF 2DUP .DT ENDOF
          1 OF ." 1ST " ENDOF
          2 OF ." 2ND " ENDOF
          3 OF ." 3RD " ENDOF
          DUP . ." TH "
     ENDCASE DT-PREFIX DT-ATTRIBUTE? IF ." -> " THEN
  LOOP DROP IF ." -- " THEN ." ) " ;

: .DEFINITION ( def -- )
  DUP NAME TYPE SPACE .DIAGRAM ;

: 'HOST ( -- xt )
  S" ' " PARSE-WORD 2EVALUATE ;

: 'HOST-PARSING ( -- xt )
  :NONAME PARSE-WORD S"  " CATENATE POSTPONE SLITERAL
  POSTPONE PARSE-WORD POSTPONE 2EVALUATE POSTPONE ; ;

: SLITERAL \ c-addr u -- )
  ?COMPILE POSTPONE SLITERAL
  [ (DT) CADDRESS DT-PREFIX DT-OR ] 2LITERAL >DT
  [ (DT) CHARACTER ] 2LITERAL >DT
  [ (DT) UNSIGNED ] 2LITERAL >DT ;

: " ( -- )
  [CHAR] " PARSE STATE @
  IF SLITERAL
  ELSE #STR ! STR #STR @ MOVE S" STR #STR @" STRONG-EVALUATE
  THEN ;

: STRONG-POSTPONE ( -- )
  ?COMPILE PARSE-WORD 2DUP TRUE ['] MATCH SEARCH-ALL 1 =
  IF DICT-COMPILE, 2DROP
  ELSE DROP SLITERAL S" EVALUATE" STRONG-EVALUATE
  THEN ;

: (CONSTANT) ( sd1 -- sd2 )
  DTP@
  BEGIN TUCK-DS 2@ DT-OUTPUT DT-OR PARAM,
     ROT DUP 2@ DT-PREFIX DT-ATTRIBUTE?
  WHILE 2CELLS+
  REPEAT DROP ;

: (VARIABLE) ( sd1 -- sd2 )
  [ (DT) ADDRESS DT-OUTPUT DT-PREFIX DT-OR DT-OR ] 2LITERAL
  PARAM, (CONSTANT) ;

: DICT-CONSTANT ( x -- )
  ?EXECUTE S" CONSTANT " DEFINE-WORD (CREATE)
  0. (CONSTANT) END-DIAGRAM END-DEF ;

: DICT-VARIABLE ( x -- )
  ?EXECUTE S" VARIABLE " DEFINE-WORD SWAP
  PREVIEW-WORD EVALUATE ! (CREATE)
  0. (VARIABLE) END-DIAGRAM END-DEF ;

: DICT-VALUE ( x -- )
  ?EXECUTE S" VALUE " DEFINE-WORD (CREATE)
  0. (CONSTANT) END-DIAGRAM END-DEF
  VALUE-ATTRIBUTE +ATTRIBUTE ;

: 2VALUE ( xd -- )
  CREATE 2, DOES> 2@ ;

: DICT-2CONSTANT ( xd -- )
  ?EXECUTE S" 2CONSTANT " DEFINE-WORD (CREATE)
  0. (CONSTANT) END-DIAGRAM END-DEF ;

: DICT-2VARIABLE ( xd -- )
  ?EXECUTE S" 2VARIABLE " DEFINE-WORD -ROT
  PREVIEW-WORD EVALUATE 2! (CREATE)
  0. (VARIABLE) END-DIAGRAM END-DEF  ;

: DICT-2VALUE ( xd -- )
  ?EXECUTE S" 2VALUE " DEFINE-WORD (CREATE)
  0. (CONSTANT) END-DIAGRAM END-DEF
  2VALUE-ATTRIBUTE +ATTRIBUTE ;

: ?VALUE ( c-addr u -- def )
  [ VALUE-ATTRIBUTE 2VALUE-ATTRIBUTE OR ] LITERAL
  ['] ATTRIBUTE-FIELD SEARCH-ALL INVERT
  IF -32 THROW THEN ;

: (STRONG-TO) ( -- )
  S" TO " PARSE-WORD 2EVALUATE
  S" !" FALSE ['] MATCH SEARCH-ALL 0=
  IF DROP -13 THROW
  ELSE STATE @ DT>DT DROP
  THEN ;

: STRONG-TO ( -- )
  PREVIEW-WORD SEARCH-LOCAL
  IF ?COMPILE
     [ (DT) ADDRESS DT-PREFIX DT-OR ] 2LITERAL >DT
     DUP @>DT 2@ DT-SIZE 2 =
     IF S" TO 2~" PREVIEW-WORD 2EVALUATE
     THEN (STRONG-TO)
  ELSE DROP PREVIEW-WORD ?VALUE
     [ (DT) ADDRESS DT-PREFIX DT-OR ] 2LITERAL >DT
     DUP 1. PARAMS>DT
     DUP 2@ 2VALUE-ATTRIBUTE 0 DT-ATTRIBUTE?
     IF PARSE-WORD 2DROP DICT>BODY STATE @
        IF POSTPONE LITERAL THEN S" !" STRONG-EVALUATE
     ELSE DROP (STRONG-TO)
     THEN
  THEN ;

: RECURSE ( -- )
  ?COMPILE LATEST STATE @ DT>DT DROP POSTPONE RECURSE ;

: DT+ ( addr1 -- addr2 )
  BEGIN DUP 2CELLS+ SWAP 2@ DT-PREFIX DT-ATTRIBUTE? INVERT
  UNTIL ;

: CREATE-LOCAL ( c-addr u -- )
  ?COMPILE DICT-HERE -ROT DICT-NAME,
  LOCAL-WID DUP @ DICT, !
  1 DICT, DTP@ DUP DT+ SWAP 2DUP -D DICT,
  DO I 2@ DT-OUTPUT DT-OR 2DICT,
  2CELLS +LOOP ;

: FORGET-LOCAL ( -- )
  ?COMPILE LOCAL-WID @ DP !
  DICT-HERE NAME>LINK @ LOCAL-WID ! ;

: (LOCAL) ( c-addr u -- )
  ?COMPILE DUP
  IF DTDROP DT-SIZE 2 =
     IF S" 2~" 2OVER CATENATE (LOCAL)
     THEN 2DUP (LOCAL) CREATE-LOCAL
  ELSE (LOCAL)
  THEN ;

: STRONG->R ( -- n )
  ?COMPILE S" (>R)" STRONG-EVALUATE
  DTP@ 2@ DT-SIZE S" R@" CREATE-LOCAL ;

: STRONG-R> ( n -- )
  ?COMPILE S" R@" SEARCH-LOCAL
  IF @>DT FORGET-LOCAL
     CASE 1 OF POSTPONE  R> ENDOF
          2 OF POSTPONE 2R> ENDOF
          -271 THROW
     ENDCASE
  ELSE DROP -271 THROW
  THEN ;

: LOOP, ( do-sys xt -- )
  CASE
     ['] NOOP   OF POSTPONE LOOP ENDOF
     ['] 1CELL  OF POSTPONE 1CELL  POSTPONE +LOOP ENDOF
     ['] 2CELLS OF POSTPONE 2CELLS POSTPONE +LOOP ENDOF
     ['] 1CHAR  OF POSTPONE 1CHAR  POSTPONE +LOOP ENDOF
  ENDCASE ;

: +LOOP, ( do-sys xt -- )
  CASE
     ['] NOOP   OF POSTPONE +LOOP ENDOF
     ['] CELLS  OF POSTPONE CELLS  POSTPONE +LOOP ENDOF
     ['] DCELLS OF POSTPONE DCELLS POSTPONE +LOOP ENDOF
     ['] CHARS  OF POSTPONE CHARS  POSTPONE +LOOP ENDOF
  ENDCASE ;

: DICT-MARKER ( -- )
  DICT-HERE
  FORTH-WID @ DICT,
  LOCAL-WID @ DICT,
  ENVIRONMENT-WID @ DICT,
  #ORDER @ DICT,
  CONTEXT #ORDER @ CELLS+ CONTEXT
  ?DO I @ DICT, 1CELL +LOOP
  GET-CURRENT DICT,
  VOC-LINK @ DUP DICT,
  BEGIN DICT>BODY DUP @ DICT, CELL+ @ DUP 0=
  UNTIL DROP
  LATEST DICT,
  LATEST-DOES DICT,
  S" MARKER " DEFINE-WORD
  DICT-CREATE 2, DOES> DUP CELL+ @ DUP
        DUP @ FORTH-WID !
  CELL+ DUP @ LOCAL-WID !
  CELL+ DUP @ ENVIRONMENT-WID !
  CELL+ DUP @ #ORDER !
  CONTEXT #ORDER @ CELLS+ CONTEXT
  ?DO CELL+ DUP @ I ! 1CELL +LOOP
  CELL+ DUP @ SET-CURRENT
  CELL+ DUP @ DUP VOC-LINK !
  BEGIN DICT>BODY DUP ROT CELL+ DUP @ ROT ! SWAP CELL+ @ DUP 0=
  UNTIL DROP
  CELL+ DUP @ TO LATEST
  CELL+     @ TO LATEST-DOES
  DP ! @ EXECUTE ;

: STRONG-ENVIRONMENT? ( c-addr u -- addr flag )
  0 ['] 2DROP ENVIRONMENT-WID SEARCH-WID
  0<> DUP IF SWAP DICT>BODY SWAP THEN ;

2VARIABLE ERROR-STR

: (ABORT") ( SINGLE CCONST -> CHARACTER UNSIGNED -- )
  ROT IF ERROR-STR 2! -2 THROW ELSE 2DROP THEN ;

: .ERROR ( SIGNED -- )
  DECIMAL ?DUP
  IF CR SOURCE DROP >IN @ -TRAILING TYPE ."  ? "
     DUP -299 -0 WITHIN
     IF ERROR-MESSAGES SWAP CELLS- @ ?DUP IF COUNT TYPE THEN
     ELSE ." ERROR " .
     THEN CR .S
  THEN ;

: DEPTH! ( u -- )
  >R
  BEGIN DEPTH R@ > WHILE DROP REPEAT
  BEGIN DEPTH R@ < WHILE 0    REPEAT
  RDROP ;

: DEFER ( -- )
  ?EXECUTE DICT-CREATE ['] NOOP ,
  DEFERRED-ATTRIBUTE +ATTRIBUTE
  DOES> @ EXECUTE ;

: IS ( def -- )
  DUP PARSE-WORD ROT ['] DEFERRED SEARCH-ALL 0=
  IF 2DROP -269 THROW
  ELSE SWAP @ SWAP DICT>BODY !
  THEN ;

: (CATCH) ( xt n1 -- n2 )
  SOURCE-ID >R >IN @ >R SOURCE-SPEC 2@ 2>R DEPTH + >R CATCH DUP
  IF R> SWAP >R DEPTH! R> 2R> SOURCE-SPEC 2! R> >IN ! R> TO SOURCE-ID ?REFILL
  ELSE RDROP DRDROP DRDROP
  THEN ;

: STRONG-CATCH ( -- )
  S" EXECUTE" FALSE ['] MATCH SEARCH-ALL
  IF DEPTH-SP SWAP STATE @ DT>DT DROP DEPTH-SP - 1+ NEGATE STATE @
     IF POSTPONE LITERAL POSTPONE (CATCH)
     ELSE (CATCH)
     THEN [ (DT) SIGNED ] 2LITERAL >DT
  ELSE DROP -13 THROW
  THEN ;

: COLD ( -- )
  POSTPONE [ <LOCALS 0 TO SOURCE-ID DTP! 0 DEPTH! ;

: STRONG ( -- )
  ?EXECUTE COLD PROMPT CR
  BEGIN REFILL
  WHILE ['] INTERPRET CATCH
     CASE  0 OF PROMPT ENDOF
          -1 OF COLD ENDOF
          -2 OF COLD ERROR-STR 2@ TYPE ENDOF
        .ERROR COLD 0
     ENDCASE CR
  REPEAT ;

: ( ( -- flag sd )
  STATE @ POSTPONE [ DT-INPUT ;

' DUP EXPORT DUP ( SINGLE -- 1ST 1ST )
' 2DUP EXPORT DUP ( DOUBLE -- 1ST 1ST )
' DROP EXPORT DROP ( SINGLE -- )
' 2DROP EXPORT DROP ( DOUBLE -- )
' SWAP EXPORT SWAP ( SINGLE SINGLE -- 2ND 1ST )
' ROT EXPORT SWAP ( SINGLE DOUBLE -- 2ND 1ST )
' -ROT EXPORT SWAP ( DOUBLE SINGLE -- 2ND 1ST )
' 2SWAP EXPORT SWAP ( DOUBLE DOUBLE -- 2ND 1ST )
' OVER EXPORT OVER ( SINGLE SINGLE -- 1ST 2ND 1ST )
' OVER-SD EXPORT OVER ( SINGLE DOUBLE -- 1ST 2ND 1ST )
' OVER-DS EXPORT OVER ( DOUBLE SINGLE -- 1ST 2ND 1ST )
' 2OVER EXPORT OVER ( DOUBLE DOUBLE -- 1ST 2ND 1ST )
' NIP EXPORT NIP ( SINGLE SINGLE -- 2ND )
' NIP-SD EXPORT NIP ( SINGLE DOUBLE -- 2ND )
' NIP-DS EXPORT NIP ( DOUBLE SINGLE -- 2ND )
' 2NIP EXPORT NIP ( DOUBLE DOUBLE -- 2ND )
' TUCK EXPORT TUCK ( SINGLE SINGLE -- 2ND 1ST 2ND )
' TUCK-SD EXPORT TUCK ( SINGLE DOUBLE -- 2ND 1ST 2ND )
' TUCK-DS EXPORT TUCK ( DOUBLE SINGLE -- 2ND 1ST 2ND )
' 2TUCK EXPORT TUCK ( DOUBLE DOUBLE -- 2ND 1ST 2ND )
' ROT EXPORT ROT ( SINGLE SINGLE SINGLE -- 2ND 3RD 1ST )
' ROT-SSD EXPORT ROT ( SINGLE SINGLE DOUBLE -- 2ND 3RD 1ST )
' ROT-SSD EXPORT ROT ( SINGLE DOUBLE SINGLE -- 2ND 3RD 1ST )
' ROT-SDD EXPORT ROT ( SINGLE DOUBLE DOUBLE -- 2ND 3RD 1ST )
' 2SWAP EXPORT ROT ( DOUBLE SINGLE SINGLE -- 2ND 3RD 1ST )
' ROT-DSD EXPORT ROT ( DOUBLE SINGLE DOUBLE -- 2ND 3RD 1ST )
' ROT-DSD EXPORT ROT ( DOUBLE DOUBLE SINGLE -- 2ND 3RD 1ST )
' 2ROT EXPORT ROT ( DOUBLE DOUBLE DOUBLE -- 2ND 3RD 1ST )
' FALSE EXPORT S>D ( SINGLE -- DOUBLE )
' S>D EXPORT S>D ( SIGNED -- SIGNED-DOUBLE )
' D>S EXPORT D>S ( DOUBLE -- SINGLE )
' NOOP EXPORT SPLIT ( DOUBLE -- SINGLE SINGLE )
' NOOP EXPORT MERGE ( SINGLE SINGLE -- DOUBLE )
' ! EXPORT ! ( SINGLE ADDRESS -> 1ST -- )
' 2! EXPORT ! ( DOUBLE ADDRESS -> 1ST -- )
' C! EXPORT ! ( SINGLE CADDRESS -> 1ST -- )
' @ EXPORT @ ( ADDRESS -> SINGLE -- 2ND )
' 2@ EXPORT @ ( ADDRESS -> DOUBLE -- 2ND )
' C@ EXPORT @ ( CADDRESS -> SINGLE -- 2ND )
' C@EXT EXPORT @ ( CADDRESS -> SIGNED -- 2ND )
' C@EXT EXPORT @ ( CADDRESS -> FLAG -- 2ND )
' FILL-S EXPORT FILL ( ADDRESS -> SINGLE UNSIGNED 2ND -- )
' FILL-D EXPORT FILL ( ADDRESS -> DOUBLE UNSIGNED 2ND -- )
' FILL EXPORT FILL ( CADDRESS -> SINGLE UNSIGNED 2ND -- )
' ERASE-S EXPORT ERASE ( ADDRESS -> SINGLE UNSIGNED -- )
' ERASE-D EXPORT ERASE ( ADDRESS -> DOUBLE UNSIGNED -- )
' ERASE-C EXPORT ERASE ( CADDRESS -> SINGLE UNSIGNED -- )
' BLANK EXPORT BLANK ( CADDRESS -> CHARACTER UNSIGNED -- )
' MOVE-S EXPORT MOVE ( ADDRESS -> SINGLE ADDRESS -> 2ND UNSIGNED -- )
' MOVE-D EXPORT MOVE ( ADDRESS -> DOUBLE ADDRESS -> 2ND UNSIGNED -- )
' MOVE-C EXPORT MOVE ( CADDRESS -> SINGLE CADDRESS -> 2ND UNSIGNED -- )
' SEARCH EXPORT SEARCH ( CADDRESS -> CHARACTER UNSIGNED 1ST 3RD -- 1ST 3RD FLAG )
' PAD EXPORT PAD ( -- CADDRESS -> CHARACTER )
' + EXPORT + ( INTEGER INTEGER -- 1ST )
' + EXPORT + ( ADDRESS INTEGER -- 1ST )
' CELLS+ EXPORT + ( ADDRESS -> SINGLE INTEGER -- 1ST )
' DCELLS+ EXPORT + ( ADDRESS -> DOUBLE INTEGER -- 1ST )
' CHARS+ EXPORT + ( CADDRESS INTEGER -- 1ST )
' D+  EXPORT + ( INTEGER-DOUBLE INTEGER-DOUBLE -- 1ST )
' UM+ EXPORT + ( INTEGER-DOUBLE INTEGER -- 1ST )
' M+ EXPORT + ( INTEGER-DOUBLE SIGNED -- 1ST )
' - EXPORT - ( INTEGER INTEGER -- 1ST )
' - EXPORT - ( ADDRESS INTEGER -- 1ST )
' CELLS- EXPORT - ( ADDRESS -> SINGLE INTEGER -- 1ST )
' DCELLS- EXPORT - ( ADDRESS -> DOUBLE INTEGER -- 1ST )
' CHARS- EXPORT - ( CADDRESS INTEGER -- 1ST )
' D- EXPORT - ( INTEGER-DOUBLE INTEGER-DOUBLE -- 1ST )
' UM- EXPORT - ( INTEGER-DOUBLE INTEGER -- 1ST )
' M- EXPORT - ( INTEGER-DOUBLE SIGNED -- 1ST )
' - EXPORT - ( ADDRESS 1ST -- SIGNED )
' -S EXPORT - ( ADDRESS -> SINGLE 1ST -- SIGNED )
' -D EXPORT - ( ADDRESS -> DOUBLE 1ST -- SIGNED )
' -C EXPORT - ( CADDRESS 1ST -- SIGNED )
' 1+ EXPORT 1+ ( INTEGER -- 1ST )
' 1+ EXPORT 1+ ( ADDRESS -- 1ST )
' CELL+ EXPORT 1+ ( ADDRESS -> SINGLE -- 1ST )
' 2CELLS+ EXPORT 1+ ( ADDRESS -> DOUBLE -- 1ST )
' CHAR+ EXPORT 1+ ( CADDRESS -- 1ST )
' D1+ EXPORT 1+ ( INTEGER-DOUBLE -- 1ST )
' 1- EXPORT 1- ( INTEGER -- 1ST )
' 1- EXPORT 1- ( ADDRESS -- 1ST )
' CELL- EXPORT 1- ( ADDRESS -> SINGLE -- 1ST )
' 2CELLS- EXPORT 1- ( ADDRESS -> DOUBLE -- 1ST )
' CHAR- EXPORT 1- ( CADDRESS -- 1ST )
' D1- EXPORT 1- ( INTEGER-DOUBLE -- 1ST )
' +! EXPORT +! ( INTEGER ADDRESS -> INTEGER -- )
' D+! EXPORT +! ( INTEGER-DOUBLE ADDRESS -> INTEGER-DOUBLE -- )
' UM+! EXPORT +! ( INTEGER ADDRESS -> INTEGER-DOUBLE -- )
' M+! EXPORT +! ( SIGNED ADDRESS -> INTEGER-DOUBLE -- )
' C+! EXPORT +! ( INTEGER CADDRESS -> INTEGER -- )
' +! EXPORT +! ( INTEGER ADDRESS -> ADDRESS -- )
' +!-S EXPORT +! ( INTEGER ADDRESS -> ADDRESS -> SINGLE -- )
' +!-D EXPORT +! ( INTEGER ADDRESS -> ADDRESS -> DOUBLE -- )
' +!-C EXPORT +! ( INTEGER ADDRESS -> CADDRESS -- )
' * EXPORT * ( INTEGER UNSIGNED -- 1ST )
' * EXPORT * ( SIGNED SIGNED -- 1ST )
' TM* EXPORT * ( INTEGER-DOUBLE UNSIGNED -- 1ST )
' UM* EXPORT M* ( UNSIGNED UNSIGNED -- UNSIGNED-DOUBLE )
' M* EXPORT M* ( SIGNED SIGNED -- SIGNED-DOUBLE )
' U/ EXPORT / ( UNSIGNED UNSIGNED -- 1ST )
' / EXPORT / ( SIGNED SIGNED -- 1ST )
' M/ EXPORT / ( UNSIGNED-DOUBLE UNSIGNED -- 1ST )
' UMOD EXPORT MOD ( UNSIGNED UNSIGNED -- 2ND )
' MOD EXPORT MOD ( SIGNED SIGNED -- 2ND )
' UMMOD EXPORT MOD ( UNSIGNED-DOUBLE UNSIGNED -- 2ND )
' U/MOD EXPORT /MOD ( UNSIGNED UNSIGNED -- 2ND 1ST )
' /MOD EXPORT /MOD ( SIGNED SIGNED -- 2ND 1ST )
' TM/MOD EXPORT /MOD ( UNSIGNED-DOUBLE UNSIGNED -- 2ND 1ST )
' U*/ EXPORT */ ( UNSIGNED UNSIGNED UNSIGNED -- 1ST )
' */ EXPORT */ ( SIGNED SIGNED SIGNED -- 1ST )
' M*/ EXPORT */ ( UNSIGNED-DOUBLE UNSIGNED UNSIGNED -- 1ST )
' U*/MOD EXPORT */MOD ( UNSIGNED UNSIGNED UNSIGNED -- 3RD 1ST )
' */MOD EXPORT */MOD ( SIGNED SIGNED SIGNED -- 3RD 1ST )
' TM*/MOD EXPORT */MOD ( UNSIGNED-DOUBLE UNSIGNED UNSIGNED -- 3RD 1ST )
' FM/MOD EXPORT FM/MOD ( SIGNED-DOUBLE SIGNED -- 2ND SIGNED )
' SM/REM EXPORT SM/REM ( SIGNED-DOUBLE SIGNED -- 2ND SIGNED )
' UM/MOD EXPORT UM/MOD ( UNSIGNED-DOUBLE UNSIGNED -- 2ND UNSIGNED )
' 2* EXPORT 2* ( INTEGER -- 1ST )
' D2* EXPORT 2* ( INTEGER-DOUBLE -- 1ST )
' U2/ EXPORT 2/ ( UNSIGNED -- 1ST )
' 2/ EXPORT 2/ ( SIGNED -- 1ST )
' DU2/ EXPORT 2/ ( UNSIGNED-DOUBLE -- 1ST )
' D2/ EXPORT 2/ ( SIGNED-DOUBLE -- 1ST )
' ABS EXPORT ABS ( SIGNED -- 1ST )
' DABS EXPORT ABS ( SIGNED-DOUBLE -- 1ST )
' NEGATE EXPORT NEGATE ( INTEGER -- 1ST )
' DNEGATE EXPORT NEGATE ( INTEGER-DOUBLE -- 1ST )
' UMIN EXPORT MIN ( INTEGER 1ST -- 1ST )
' MIN EXPORT MIN ( SIGNED 1ST -- 1ST )
' UMIN EXPORT MIN ( ADDRESS 1ST -- 1ST )
' DUMIN EXPORT MIN ( INTEGER-DOUBLE 1ST -- 1ST )
' DMIN EXPORT MIN ( SIGNED-DOUBLE 1ST -- 1ST )
' UMAX EXPORT MAX ( INTEGER 1ST -- 1ST )
' MAX EXPORT MAX ( SIGNED 1ST -- 1ST )
' UMAX EXPORT MAX ( ADDRESS 1ST -- 1ST )
' DUMAX EXPORT MAX ( INTEGER-DOUBLE 1ST -- 1ST )
' DMAX EXPORT MAX ( SIGNED-DOUBLE 1ST -- 1ST )
' U< EXPORT < ( INTEGER 1ST -- FLAG )
' < EXPORT < ( SIGNED 1ST -- FLAG )
' U< EXPORT < ( ADDRESS 1ST -- FLAG )
' DU< EXPORT < ( INTEGER-DOUBLE 1ST -- FLAG )
' D< EXPORT < ( SIGNED-DOUBLE 1ST -- FLAG )
' U> EXPORT > ( INTEGER 1ST -- FLAG )
' > EXPORT > ( SIGNED 1ST -- FLAG )
' U> EXPORT > ( ADDRESS 1ST -- FLAG )
' DU> EXPORT > ( INTEGER-DOUBLE 1ST -- FLAG )
' D> EXPORT > ( SIGNED-DOUBLE 1ST -- FLAG )
' = EXPORT = ( SINGLE 1ST -- FLAG )
' D= EXPORT = ( DOUBLE 1ST -- FLAG )
' <> EXPORT <> ( SINGLE 1ST -- FLAG )
' D<> EXPORT <> ( DOUBLE 1ST -- FLAG )
' 0< EXPORT 0< ( SIGNED -- FLAG )
' D0< EXPORT 0< ( SIGNED-DOUBLE -- FLAG )
' 0> EXPORT 0> ( SIGNED -- FLAG )
' D0> EXPORT 0> ( SIGNED-DOUBLE -- FLAG )
' 0= EXPORT 0= ( SINGLE -- FLAG )
' D0= EXPORT 0= ( DOUBLE -- FLAG )
' 0<> EXPORT 0<> ( SINGLE -- FLAG )
' D0<> EXPORT 0<> ( DOUBLE -- FLAG )
' WITHIN EXPORT WITHIN ( INTEGER 1ST 1ST -- FLAG )
' WITHIN EXPORT WITHIN ( ADDRESS 1ST 1ST -- FLAG )
' AND EXPORT AND ( SINGLE LOGICAL -- 1ST )
' OR EXPORT OR ( SINGLE LOGICAL -- 1ST )
' XOR EXPORT XOR ( SINGLE LOGICAL -- 1ST )
' INVERT EXPORT INVERT ( LOGICAL -- 1ST )
' 2* EXPORT LSHIFT ( LOGICAL -- 1ST )
' LSHIFT EXPORT LSHIFT ( LOGICAL UNSIGNED -- 1ST )
' U2/ EXPORT RSHIFT ( LOGICAL -- 1ST )
' RSHIFT EXPORT RSHIFT ( LOGICAL UNSIGNED -- 1ST )
' /STRING EXPORT /STRING ( CADDRESS -> CHARACTER UNSIGNED INTEGER -- 1ST 3RD )
' 1/STRING EXPORT /STRING ( CADDRESS -> CHARACTER UNSIGNED -- 1ST 3RD )
' HERE EXPORT HERE ( -- ADDRESS )
' ALIGN EXPORT ALIGN ( -- )
' ALIGNED EXPORT ALIGNED ( ADDRESS -- 1ST )
' , EXPORT , ( SINGLE -- )
' 2, EXPORT , ( DOUBLE -- )
' C, EXPORT C, ( SINGLE -- )
' ALLOT EXPORT ALLOT ( INTEGER -- )
' UNUSED EXPORT UNUSED ( -- UNSIGNED )
' DICT-HERE EXPORT DICT-HERE ( -- ADDRESS )
' DICT, EXPORT DICT, ( SINGLE -- )
' 2DICT, EXPORT DICT, ( DOUBLE -- )
' DICT-ALLOT EXPORT DICT-ALLOT ( INTEGER -- )
' DICT-ALIGN EXPORT DICT-ALIGN ( -- )
' DICT-NAME, EXPORT DICT-NAME, ( CADDRESS -> CHARACTER UNSIGNED -- )
' CHARS EXPORT CHARS ( INTEGER -- 1ST )
' CELLS EXPORT CELLS ( INTEGER -- 1ST )
' KEY EXPORT KEY ( -- CHARACTER )
' ACCEPT EXPORT ACCEPT ( CADDRESS -> CHARACTER INTEGER -- 3RD )
' EMIT EXPORT EMIT ( INTEGER -- )
' TYPE EXPORT TYPE ( CADDRESS -> CHARACTER UNSIGNED -- )
' COMPARE EXPORT COMPARE ( CADDRESS -> CHARACTER UNSIGNED 1ST 3RD -- SIGNED )
' NOOP EXPORT NOOP ( -- )
' TRUE EXPORT TRUE ( -- FLAG )
' FALSE EXPORT FALSE ( -- FLAG )
' CR EXPORT CR ( -- )
' BL EXPORT BL ( -- CHARACTER )
' BASE EXPORT BASE ( -- ADDRESS -> UNSIGNED )
' >R EXPORT (>R) ( SINGLE -- )
' 2>R EXPORT (>R) ( DOUBLE -- )
' RDROP EXPORT (RDROP) ( -- ) IMMEDIATE
' DRDROP EXPORT (DRDROP) ( -- ) IMMEDIATE
' DT-PREFIX EXPORT DT-PREFIX ( -- DATA-TYPE )
' DT-INPUT EXPORT DT-INPUT ( -- DATA-TYPE )
' DT-OUTPUT EXPORT DT-OUTPUT ( -- DATA-TYPE )
' DT-OFFSET EXPORT DT-OFFSET ( -- DATA-TYPE )
' DT-AND EXPORT AND ( DATA-TYPE DATA-TYPE -- 1ST )
' DT-OR EXPORT OR ( DATA-TYPE DATA-TYPE -- 1ST )
' DT-XOR EXPORT XOR ( DATA-TYPE DATA-TYPE -- 1ST )
' DT-INVERT EXPORT INVERT ( DATA-TYPE -- 1ST )
' DT-ATTRIBUTE? EXPORT ATTRIBUTE? ( DATA-TYPE DATA-TYPE -- FLAG )
' DT-NULL? EXPORT NULL? ( DATA-TYPE -- FLAG )
' OFFSET EXPORT OFFSET ( DATA-TYPE -- UNSIGNED )
' OFFSET+ EXPORT OFFSET+ ( DATA-TYPE INTEGER -- 1ST )
' FALSE EXPORT NEW-TUPLE ( -- TUPLE )
' T> EXPORT T> ( TUPLE -> SINGLE -- 1ST 2ND )
' 2T> EXPORT T> ( TUPLE -> DOUBLE -- 1ST 2ND )
' >T EXPORT >T ( TUPLE -> SINGLE 2ND -- 1ST )
' 2>T EXPORT >T ( TUPLE -> DOUBLE 2ND -- 1ST )
' TDROP EXPORT DROP ( TUPLE -- )
' DUP EXPORT SIZE ( TUPLE -- 1ST UNSIGNED )
' DTP@ EXPORT DTP@ ( -- ADDRESS -> DATA-TYPE )
' DTP! EXPORT DTP! ( -- )
' DTP| EXPORT DTP| ( -- )
' >DT EXPORT >DT ( DATA-TYPE -- )
' DT> EXPORT DT> ( -- DATA-TYPE FLAG )
' DT-DEPTH EXPORT DEPTH ( -- UNSIGNED )
' PARAM, EXPORT PARAM, ( STACK-DIAGRAM DATA-TYPE -- 1ST )
' (PARAM) EXPORT (PARAM) ( STACK-DIAGRAM DATA-TYPE -- 1ST )
' -- EXPORT -- ( STACK-DIAGRAM -- 1ST )
' DT-> EXPORT -> ( -- ) IMMEDIATE
' -> EXPORT -> ( STACK-DIAGRAM -- 1ST )
' TH EXPORT TH ( STACK-DIAGRAM UNSIGNED -- 1ST )
' ( EXPORT ( ( -- FLAG STACK-DIAGRAM ) IMMEDIATE
' STATE! EXPORT STATE! ( SINGLE -- )
' <DIAGRAM EXPORT <DIAGRAM ( FLAG STACK-DIAGRAM -- 2ND )
' DIAGRAM> EXPORT DIAGRAM> ( STACK-DIAGRAM -- )
' ENCLOSE-DIAGRAM EXPORT ENCLOSE-DIAGRAM ( STACK-DIAGRAM -- 1ST ADDRESS -> DATA-TYPE ADDRESS -> DATA-TYPE )
' 2CELLS+ EXPORT PARAMS ( DEFINITION -- ADDRESS -> DATA-TYPE )
' PARAM@ EXPORT PARAM@ ( DEFINITION UNSIGNED -- DATA-TYPE )
' END-DIAGRAM EXPORT END-DIAGRAM ( STACK-DIAGRAM -- )
' PARAMS>DT EXPORT PARAMS>DT ( DEFINITION DATA-TYPE -- )
' ALL-PARAMS>DT EXPORT ALL-PARAMS>DT ( DEFINITION UNSIGNED -- 1ST )
' ) EXPORT ) ( FLAG STACK-DIAGRAM -- )
' )COLON EXPORT ) ( COLON-SYS FLAG STACK-DIAGRAM -- 1ST )
' FORTH-WID EXPORT FORTH-WORDLIST ( -- WID )
' LOCAL-WID EXPORT LOCAL-WORDLIST ( -- WID )
' ENVIRONMENT-WID EXPORT ENVIRONMENT-WORDLIST ( -- WID )
' #VOCS EXPORT #VOCS ( -- UNSIGNED )
' #ORDER EXPORT #ORDER ( -- ADDRESS -> UNSIGNED )
' VOC-LINK EXPORT VOC-LINK ( -- ADDRESS -> DEFINITION )
' CONTEXT EXPORT CONTEXT ( -- ADDRESS -> WID )
' GET-CURRENT EXPORT GET-CURRENT ( -- WID )
' SET-CURRENT EXPORT SET-CURRENT ( WID -- )
' LATEST EXPORT LATEST ( -- DEFINITION ) VALUE-ATTRIBUTE +ATTRIBUTE
' LATEST! EXPORT LATEST! ( -- )
' NONAME? EXPORT NONAME? ( DEFINITION -- FLAG )
' ?NONAME EXPORT ?NONAME ( DEFINITION -- )
' NAME EXPORT NAME ( DEFINITION -- CADDRESS -> CHARACTER UNSIGNED )
' END-DEF EXPORT END-DEF ( -- )
' (CREATE) EXPORT (CREATE) ( TOKEN -- )
' (CREATE-NONAME) EXPORT (CREATE-NONAME) ( TOKEN -- )
' DICT-CREATE EXPORT CREATE ( -- )
' #PARAMS EXPORT #PARAMS ( DEFINITION -- UNSIGNED )
' @ EXPORT >TOKEN ( DEFINITION -- TOKEN )
' DICT>BODY EXPORT >BODY ( DEFINITION -- ADDRESS )
' SEARCH-WID EXPORT SEARCH ( CADDRESS -> CHARACTER UNSIGNED SINGLE SEARCH-CRITERION  WID -- DEFINITION SIGNED )
' SEARCH-ALL EXPORT SEARCH-ALL ( CADDRESS -> CHARACTER UNSIGNED SINGLE SEARCH-CRITERION -- DEFINITION SIGNED )
' ?DATA-TYPE EXPORT ?DATA-TYPE ( DEFINITION -- DATA-TYPE )
' DT EXPORT DT ( -- DATA-TYPE )
' PARENT EXPORT PARENT ( DATA-TYPE -- 1ST )
' ANCESTOR EXPORT ANCESTOR ( DATA-TYPE -- 1ST )
' DT-SIZE EXPORT SIZE ( DATA-TYPE -- UNSIGNED )
' ?DT-SIZE EXPORT ?SIZE ( DATA-TYPE -- UNSIGNED )
' DEPTH-SP EXPORT DEPTH-SP ( -- UNSIGNED )
' DTDROP EXPORT DTDROP ( -- DATA-TYPE )
' STATE EXPORT STATE ( -- ADDRESS -> FLAG )
' [ EXPORT [ ( -- ) IMMEDIATE
' ] EXPORT ] ( -- )
' CAST EXPORT CAST ( -- ) IMMEDIATE
' ?COMPILE EXPORT ?COMPILE ( -- )
' ?EXECUTE EXPORT ?EXECUTE ( -- )
' TOKEN-FIELD EXPORT TOKEN-FIELD ( SIGNED DEFINITION SINGLE -- 1ST )
' ATTRIBUTE-FIELD EXPORT ATTRIBUTE-FIELD ( SIGNED DEFINITION SINGLE -- 1ST )
' 2DROP EXPORT ONLY-NAME ( SIGNED DEFINITION SINGLE -- 1ST )
' >CF EXPORT >CF ( CONTROL-FLOW -- )
' CF> EXPORT CF> ( -- CONTROL-FLOW )
' DICT: EXPORT : ( -- COLON-SYS )
' DICT:NONAME EXPORT :NONAME ( -- DEFINITION COLON-SYS )
' ?PARAMS EXPORT ?PARAMS ( -- )
' DICT-EXIT EXPORT EXIT ( -- ) IMMEDIATE
' DICT; EXPORT ; ( COLON-SYS -- ) IMMEDIATE
' DOES;  EXPORT ; ( DOES-SYS -- ) IMMEDIATE
:NONAME POSTPONE LITERAL ; EXPORT LITERAL, ( SINGLE -- )
:NONAME POSTPONE 2LITERAL ; EXPORT LITERAL, ( DOUBLE -- )
' @>DT EXPORT @>DT ( ADDRESS -> DATA-TYPE -- )
' <LOCALS EXPORT <LOCALS ( -- )
' LOCALS> EXPORT LOCALS> ( -- )
' COMPILE, EXPORT (COMPILE,) ( TOKEN -- )
' DICT-COMPILE, EXPORT COMPILE, ( DEFINITION -- )
' (CAST) EXPORT (CAST) ( ADDRESS -> DATA-TYPE UNSIGNED FLAG -- )
' DT>DT EXPORT DT>DT ( DEFINITION FLAG -- TOKEN )
' ?CONGRUENT EXPORT ?CONGRUENT ( DEFINITION ADDRESS -> DATA-TYPE -- )
' IDENTITY EXPORT IDENTITY ( SIGNED DEFINITION SINGLE -- 1ST )
' DEFERRED EXPORT DEFERRED ( SIGNED DEFINITION SINGLE -- 1ST )
' MATCH EXPORT MATCH ( SIGNED DEFINITION SINGLE -- 1ST )
' ?DT>DT EXPORT ?DT>DT ( CADDRESS -> CHARACTER UNSIGNED -- TOKEN )
' SINGLE EXPORT-DT SINGLE ( STACK-DIAGRAM -- 1ST )
' INTEGER EXPORT-DT INTEGER ( STACK-DIAGRAM -- 1ST )
' UNSIGNED EXPORT-DT UNSIGNED ( STACK-DIAGRAM -- 1ST )
' SIGNED EXPORT-DT SIGNED ( STACK-DIAGRAM -- 1ST )
' CHARACTER EXPORT-DT CHARACTER ( STACK-DIAGRAM -- 1ST )
' ADDRESS EXPORT-DT ADDRESS ( STACK-DIAGRAM -- 1ST )
' CADDRESS EXPORT-DT CADDRESS ( STACK-DIAGRAM -- 1ST )
' LOGICAL EXPORT-DT LOGICAL ( STACK-DIAGRAM -- 1ST )
' FLAG EXPORT-DT FLAG ( STACK-DIAGRAM -- 1ST )
' DEFINITION EXPORT-DT DEFINITION ( STACK-DIAGRAM -- 1ST )
' TOKEN EXPORT-DT TOKEN ( STACK-DIAGRAM -- 1ST )
' SEARCH-CRITERION EXPORT-DT SEARCH-CRITERION ( STACK-DIAGRAM -- 1ST )
' EXECUTE EXPORT EXECUTE ( SIGNED DEFINITION SINGLE SEARCH-CRITERION -- 1ST )
' FILE EXPORT-DT FILE ( STACK-DIAGRAM -- 1ST )
' FAM EXPORT-DT FAM ( STACK-DIAGRAM -- 1ST )
' WID EXPORT-DT WID ( STACK-DIAGRAM -- 1ST )
' R-SIZE EXPORT-DT R-SIZE ( STACK-DIAGRAM -- 1ST )
' CONTROL-FLOW EXPORT-DT CONTROL-FLOW ( STACK-DIAGRAM -- 1ST )
' DOUBLE EXPORT-DT DOUBLE ( STACK-DIAGRAM -- 1ST )
' INTEGER-DOUBLE EXPORT-DT INTEGER-DOUBLE ( STACK-DIAGRAM -- 1ST )
' UNSIGNED-DOUBLE EXPORT-DT UNSIGNED-DOUBLE ( STACK-DIAGRAM -- 1ST )
' NUMBER-DOUBLE EXPORT-DT NUMBER-DOUBLE ( STACK-DIAGRAM -- 1ST )
' SIGNED-DOUBLE EXPORT-DT SIGNED-DOUBLE ( STACK-DIAGRAM -- 1ST )
' DATA-TYPE EXPORT-DT DATA-TYPE ( STACK-DIAGRAM -- 1ST )
' STACK-DIAGRAM EXPORT-DT STACK-DIAGRAM ( STACK-DIAGRAM -- 1ST )
' TUPLE EXPORT-DT TUPLE ( STACK-DIAGRAM -- 1ST )
' INPUT-SOURCE EXPORT-DT INPUT-SOURCE ( STACK-DIAGRAM -- 1ST )
' SYS EXPORT-DT SYS ( STACK-DIAGRAM -- 1ST )
' ORIG/DEST EXPORT-DT ORIG/DEST ( STACK-DIAGRAM -- 1ST )
' ORIG EXPORT-DT ORIG ( STACK-DIAGRAM -- 1ST )
' DEST EXPORT-DT DEST ( STACK-DIAGRAM -- 1ST )
' COLON-SYS EXPORT-DT COLON-SYS ( STACK-DIAGRAM -- 1ST )
' DOES-SYS EXPORT-DT DOES-SYS ( STACK-DIAGRAM -- 1ST )
' DO-SYS EXPORT-DT DO-SYS ( STACK-DIAGRAM -- 1ST )
' CASE-SYS EXPORT-DT CASE-SYS ( STACK-DIAGRAM -- 1ST )
' OF-SYS EXPORT-DT OF-SYS ( STACK-DIAGRAM -- 1ST )
' #TIB EXPORT #TIB ( -- ADDRESS -> UNSIGNED )
' TIB EXPORT TIB ( -- CADDRESS -> CHARACTER )
' SOURCE-ID EXPORT SOURCE-ID ( -- FILE ) VALUE-ATTRIBUTE +ATTRIBUTE
' >IN EXPORT >IN ( -- ADDRESS -> UNSIGNED )
' ENCLOSE EXPORT ENCLOSE ( CHARACTER CADDRESS -> 1ST UNSIGNED 4 TH -- 2ND 4 TH 4 TH 4 TH )
' PARSE EXPORT PARSE ( CHARACTER -- CADDRESS -> CHARACTER UNSIGNED )
' ENCLOSE-WORD EXPORT ENCLOSE-WORD ( CADDRESS -> CHARACTER UNSIGNED 3RD -- 1ST 3RD 3RD 3RD )
' PARSE-WORD EXPORT PARSE-WORD ( -- CADDRESS -> CHARACTER UNSIGNED )
' PREVIEW-WORD EXPORT PREVIEW-WORD ( -- CADDRESS -> CHARACTER UNSIGNED )
' COMMENT EXPORT \ ( -- ) IMMEDIATE
' >NUMBER EXPORT >NUMBER ( INTEGER-DOUBLE CADDRESS -> CHARACTER UNSIGNED -- 1ST 2ND 4 TH )
' >SIGN EXPORT >SIGN ( CHARACTER -- SIGNED )
' NUMBER EXPORT NUMBER ( CADDRESS -> CHARACTER UNSIGNED -- INTEGER-DOUBLE DATA-TYPE )
' EXECUTE EXPORT (EXECUTE) ( TOKEN -- )
' INTERPRET EXPORT INTERPRET ( -- )
' ?REFILL EXPORT ?REFILL ( -- )
' STRING-ID EXPORT STRING-ID ( -- FILE )
' STRONG-INCLUDE-FILE EXPORT INCLUDE ( FILE -- )
' STRONG-INCLUDED EXPORT INCLUDE ( CADDRESS -> CHARACTER UNSIGNED -- )
' STRONG-EVALUATE EXPORT EVALUATE ( CADDRESS -> CHARACTER UNSIGNED -- )
' SEARCH-LOCAL EXPORT SEARCH-LOCAL ( CADDRESS -> CHARACTER UNSIGNED -- ADDRESS -> DATA-TYPE SIGNED )
' LOCAL, EXPORT LOCAL, ( CADDRESS -> CHARACTER UNSIGNED ADDRESS -> DATA-TYPE -- )
' [LITERAL] EXPORT [LITERAL] ( -- ) IMMEDIATE
' FREEZE EXPORT FREEZE ( -- CONTROL-FLOW )
' THAW EXPORT THAW ( CONTROL-FLOW -- )
' NESTING EXPORT NESTING ( ADDRESS -> DATA-TYPE INTEGER -- )
' PARAM@, EXPORT PARAM@, ( DEFINITION STACK-DIAGRAM UNSIGNED 3RD -- 1ST 2ND )
' +PARAM EXPORT +PARAM ( DEFINITION UNSIGNED -- 1ST 2ND )
' ENCLOSE-PARAMS EXPORT ENCLOSE-PARAMS ( DEFINITION UNSIGNED -- 1ST 2ND 2ND )
' ?HAS-INPUT-PARAMS EXPORT ?HAS-INPUT-PARAMS ( DEFINITION -- )
' ?CHECK-REFERENCES EXPORT ?CHECK-REFERENCES ( DEFINITION UNSIGNED 2ND -- 1ST 2ND 2ND )
' (DOES) EXPORT (DOES) ( DEFINITION -- )
' STRONG-NO-PARAMS-DOES> EXPORT NO-PARAMS-DOES> ( COLON-SYS -- DOES-SYS ) IMMEDIATE
' STRONG-DOES> EXPORT DOES> ( COLON-SYS -- DOES-SYS ) IMMEDIATE
' PROMPT EXPORT PROMPT ( -- )
' ABORT EXPORT ABORT ( -- )
' STRONG-QUIT EXPORT QUIT ( -- )
' BYE EXPORT BYE ( -- )
' SOURCE-SPEC EXPORT SOURCE-SPEC ( -- ADDRESS -> DOUBLE )
' FIB EXPORT FIB ( -- CADDRESS -> CHARACTER )
' #FIB EXPORT #FIB ( -- ADDRESS -> UNSIGNED )
' STR EXPORT STR ( -- CADDRESS -> CHARACTER )
' #STR EXPORT #STR ( -- ADDRESS -> UNSIGNED )
' SOURCE EXPORT SOURCE ( -- CADDRESS -> CHARACTER UNSIGNED )
' REFILL EXPORT REFILL ( -- FLAG )
' SPACE EXPORT SPACE ( -- )
' SPACES EXPORT SPACES ( INTEGER -- )
' 1ST EXPORT 1ST ( STACK-DIAGRAM -- 1ST )
' 2ND EXPORT 2ND ( STACK-DIAGRAM -- 1ST )
' 3RD EXPORT 3RD ( STACK-DIAGRAM -- 1ST )
' IMMEDIATE EXPORT IMMEDIATE ( -- )
' HOLD EXPORT HOLD ( CHARACTER -- )
' <# EXPORT <# ( DOUBLE -- NUMBER-DOUBLE )
' #> EXPORT #> ( NUMBER-DOUBLE -- CADDRESS -> CHARACTER UNSIGNED )
' # EXPORT # ( NUMBER-DOUBLE -- 1ST )
' #S EXPORT #S ( NUMBER-DOUBLE -- 1ST )
' DU. EXPORT . ( DOUBLE -- )
' D. EXPORT . ( SIGNED-DOUBLE -- )
' U. EXPORT . ( SINGLE -- )
' . EXPORT . ( SIGNED -- )
' EMIT EXPORT . ( CHARACTER -- )
' DECIMAL EXPORT DECIMAL ( -- )
' HEX EXPORT HEX ( -- )
' DU.R EXPORT .R ( DOUBLE INTEGER -- )
' D.R EXPORT .R ( SIGNED-DOUBLE INTEGER -- )
' U.R EXPORT .R ( SINGLE INTEGER -- )
' .R EXPORT .R ( SIGNED INTEGER -- )
' +ATTRIBUTE EXPORT +ATTRIBUTE ( LOGICAL -- )
' IMMEDIATE? EXPORT IMMEDIATE? ( DEFINITION -- FLAG )
' -TRAILING EXPORT -TRAILING ( CADDRESS -> CHARACTER UNSIGNED -- 1ST 3RD )
' .DIAGRAM EXPORT .DIAGRAM ( DEFINITION -- )
' .DEFINITION EXPORT . ( DEFINITION -- )
' DICT' EXPORT ' ( -- DEFINITION )
' WORDLIST EXPORT WORDLIST ( -- WID )
' FORTH EXPORT FORTH ( -- )  VALUE-ATTRIBUTE +ATTRIBUTE
' LOCAL EXPORT LOCAL ( -- )  VALUE-ATTRIBUTE +ATTRIBUTE
' ENVIRONMENT EXPORT ENVIRONMENT ( -- )  VALUE-ATTRIBUTE +ATTRIBUTE
' SEARCH-TOKEN EXPORT SEARCH-TOKEN ( TOKEN -- DEFINITION SIGNED )
' ?DEFINITION EXPORT ?DEFINITION ( DATA-TYPE -- DEFINITION )
' .DT EXPORT . ( DATA-TYPE -- )
' .S EXPORT .S ( -- ) IMMEDIATE
' NAME>DEFINITION EXPORT NAME>DEFINITION ( CADDRESS -> UNSIGNED -- DEFINITION )
' PREV EXPORT PREV ( DEFINITION -- 1ST )
' 'HOST EXPORT 'HOST ( -- TOKEN )
' 'HOST-PARSING EXPORT 'HOST-PARSING ( -- TOKEN )
' SLITERAL EXPORT SLITERAL ( CADDRESS -> CHARACTER UNSIGNED -- ) IMMEDIATE
' " EXPORT " ( -- ) IMMEDIATE
' STRONG-POSTPONE EXPORT POSTPONE ( -- ) IMMEDIATE
' (CONSTANT) EXPORT (CONSTANT) ( STACK-DIAGRAM -- 1ST )
' (VARIABLE) EXPORT (VARIABLE) ( STACK-DIAGRAM -- 1ST )
' DICT-CONSTANT EXPORT CONSTANT ( SINGLE -- )
' DICT-VARIABLE EXPORT VARIABLE ( SINGLE -- )
' DICT-VALUE EXPORT VALUE ( SINGLE -- )
' DICT-2CONSTANT EXPORT CONSTANT ( DOUBLE -- )
' DICT-2VARIABLE EXPORT VARIABLE ( DOUBLE -- )
' DICT-2VALUE EXPORT VALUE ( DOUBLE -- )
' ?VALUE EXPORT ?VALUE ( CADDRESS -> CHARACTER UNSIGNED -- DEFINITION )
' STRONG-TO EXPORT TO ( -- ) IMMEDIATE
' DT+ EXPORT DT+ ( ADDRESS -> DATA-TYPE -- 1ST )
' CREATE-LOCAL EXPORT CREATE-LOCAL ( CADDRESS -> CHARACTER UNSIGNED -- )
' FORGET-LOCAL EXPORT FORGET-LOCAL ( -- )
' (LOCAL) EXPORT (LOCAL) ( CADDRESS -> CHARACTER UNSIGNED -- )
' STRONG->R EXPORT >R ( -- R-SIZE ) IMMEDIATE
' STRONG-R> EXPORT R> ( R-SIZE -- ) IMMEDIATE
' DICT-MARKER EXPORT MARKER ( -- )
' STRONG-ENVIRONMENT? EXPORT ENVIRONMENT? ( CADDRESS -> CHARACTER UNSIGNED -- ADDRESS FLAG )
' (ABORT") EXPORT (ABORT") ( SINGLE CADDRESS -> CHARACTER UNSIGNED -- )
' .ERROR EXPORT .ERROR ( SIGNED -- )
' DEFER EXPORT DEFER ( -- )
' IS EXPORT IS ( DEFINITION -- )
' (CATCH) EXPORT (CATCH) ( TOKEN INTEGER -- SIGNED )
' STRONG-CATCH EXPORT CATCH ( -- ) IMMEDIATE
' THROW EXPORT THROW ( SIGNED -- )
' RECURSE EXPORT RECURSE ( -- ) IMMEDIATE
' DROP EXPORT (DROP-S) ( SINGLE -- )
' DROP EXPORT (DROP-S') ( SINGLE 1ST -- 1ST )
' 2DROP EXPORT (2DROP-S) ( INTEGER 1ST -- )
' 2DROP EXPORT (2DROP-S) ( ADDRESS 1ST -- )
' NOOP EXPORT (STEP-S) ( INTEGER -- )
' NOOP EXPORT (STEP-S) ( ADDRESS -- )
' 1CELL EXPORT (STEP-S) ( ADDRESS -> SINGLE -- )
' 2CELLS EXPORT (STEP-S) ( ADDRESS -> DOUBLE -- )
' 1CHAR EXPORT (STEP-S) ( CADDRESS -- )
' NOOP EXPORT (+STEP-S) ( INTEGER INTEGER -- )
' NOOP EXPORT (+STEP-S) ( INTEGER ADDRESS -- )
' CELLS EXPORT (+STEP-S) ( INTEGER ADDRESS -> SINGLE -- )
' DCELLS EXPORT (+STEP-S) ( INTEGER ADDRESS -> DOUBLE -- )
' CHARS EXPORT (+STEP-S) ( INTEGER CADDRESS -- )
:NONAME POSTPONE AHEAD ; EXPORT (AHEAD) ( -- ORIG )
:NONAME POSTPONE IF ; EXPORT (IF) ( -- ORIG )
:NONAME POSTPONE ELSE ; EXPORT (ELSE) ( ORIG -- 1ST )
:NONAME POSTPONE THEN ; EXPORT (THEN) ( ORIG -- )
:NONAME POSTPONE BEGIN ; EXPORT (BEGIN) ( -- DEST )
:NONAME POSTPONE UNTIL ; EXPORT (UNTIL) ( DEST -- )
:NONAME POSTPONE AGAIN ; EXPORT (AGAIN) ( DEST -- )
:NONAME POSTPONE WHILE ; EXPORT (WHILE) ( DEST -- ORIG 1ST )
:NONAME POSTPONE REPEAT ; EXPORT (REPEAT) ( ORIG DEST -- )
:NONAME POSTPONE CASE ; EXPORT (CASE) ( -- CASE-SYS )
:NONAME POSTPONE ENDCASE ; EXPORT (ENDCASE) ( CASE-SYS -- )
:NONAME POSTPONE OF ; EXPORT (OF) ( -- OF-SYS )
:NONAME POSTPONE ENDOF ; EXPORT (ENDOF) ( CASE-SYS OF-SYS -- 1ST )
:NONAME POSTPONE DO ; EXPORT (DO) ( -- DO-SYS )
:NONAME POSTPONE ?DO ; EXPORT (?DO) ( -- DO-SYS )
:NONAME POSTPONE LOOP ; EXPORT (LOOP) ( DO-SYS -- )
:NONAME POSTPONE +LOOP ; EXPORT (+LOOP) ( DO-SYS -- )
:NONAME POSTPONE LEAVE ; EXPORT (LEAVE) ( -- )
' UNLOOP EXPORT (UNLOOP) ( -- )
' LOOP, EXPORT LOOP, ( DO-SYS TOKEN -- )
' +LOOP, EXPORT +LOOP, ( DO-SYS TOKEN -- )
' IMPORT EXPORT IMPORT ( TOKEN -- )
' R/O EXPORT R/O ( -- FAM )
' W/O EXPORT W/O ( -- FAM )
' R/W EXPORT R/W ( -- FAM )
' BIN EXPORT BIN ( FAM -- 1ST )
' CREATE-FILE EXPORT CREATE ( CADDRESS -> CHARACTER UNSIGNED FAM -- FILE SIGNED )
' OPEN-FILE EXPORT OPEN ( CADDRESS -> CHARACTER UNSIGNED FAM -- FILE SIGNED )
' CLOSE-FILE EXPORT CLOSE ( FILE -- SIGNED )
' DELETE-FILE EXPORT DELETE ( CADDRESS -> CHARACTER UNSIGNED -- SIGNED )
' READ-FILE EXPORT READ ( CADDRESS -> CHARACTER UNSIGNED FILE -- 3RD SIGNED )
' WRITE-FILE EXPORT WRITE ( CADDRESS -> CHARACTER UNSIGNED FILE -- SIGNED )
' FILE-STATUS EXPORT STATUS ( CADDRESS -> CHARACTER UNSIGNED -- LOGICAL SIGNED )
' FILE-POSITION EXPORT POSITION ( FILE -- UNSIGNED-DOUBLE SIGNED )
' FILE-SIZE EXPORT SIZE ( FILE -- UNSIGNED-DOUBLE SIGNED )
' REPOSITION-FILE EXPORT REPOSITION ( UNSIGNED-DOUBLE FILE -- SIGNED )
' RESIZE-FILE EXPORT RESIZE ( UNSIGNED-DOUBLE FILE -- SIGNED )
' FLUSH-FILE EXPORT FLUSH ( FILE -- SIGNED )
' RENAME-FILE EXPORT RENAME ( CADDRESS -> CHARACTER UNSIGNED CADDRESS -> CHARACTER UNSIGNED -- SIGNED )
' READ-LINE EXPORT READ-LINE ( CADDRESS -> CHARACTER UNSIGNED FILE -- 3RD FLAG SIGNED )
' WRITE-LINE EXPORT WRITE-LINE ( CADDRESS -> CHARACTER UNSIGNED FILE -- SIGNED )

ENVIRONMENT-WID SET-CURRENT

S" /COUNTED-STRING" ENVIRONMENT?
   [IF] CREATE /COUNTED-STRING , ' /COUNTED-STRING EXPORT /COUNTED-STRING
   [THEN]
S" /HOLD" ENVIRONMENT?
   [IF] CREATE /HOLD , ' /HOLD EXPORT /HOLD
   [THEN]
S" /PAD" ENVIRONMENT?
   [IF] CREATE /PAD , ' /PAD EXPORT /PAD
   [THEN]
S" ADDRESS-UNIT-BITS" ENVIRONMENT?
   [IF] CREATE ADDRESS-UNIT-BITS , ' ADDRESS-UNIT-BITS EXPORT ADDRESS-UNIT-BITS
   [THEN]
S" #LOCALS" ENVIRONMENT?
   [IF] CREATE #LOCALS , ' #LOCALS EXPORT #LOCALS
   [THEN]
S" STACK-CELLS" ENVIRONMENT?
   [IF] CREATE STACK-CELLS , ' STACK-CELLS EXPORT STACK-CELLS
   [THEN]
S" RETURN-STACK-CELLS" ENVIRONMENT?
   [IF] CREATE RETURN-STACK-CELLS , ' RETURN-STACK-CELLS EXPORT RETURN-STACK-CELLS
   [THEN]
S" MAX-CHAR" ENVIRONMENT?
   [IF] CREATE MAX-CHAR , ' MAX-CHAR EXPORT MAX-CHAR
   [THEN]
S" MAX-D" ENVIRONMENT?
   [IF] CREATE MAX-D 2, ' MAX-D EXPORT MAX-D
   [THEN]
S" MAX-N" ENVIRONMENT?
   [IF] CREATE MAX-N , ' MAX-N EXPORT MAX-N
   [THEN]
S" MAX-U" ENVIRONMENT?
   [IF] CREATE MAX-U , ' MAX-U EXPORT MAX-U
   [THEN]
S" MAX-UD" ENVIRONMENT?
   [IF] CREATE MAX-UD 2, ' MAX-UD EXPORT MAX-UD
   [THEN]
S" FLOORED" ENVIRONMENT?
   [IF] CREATE FLOORED , ' FLOORED EXPORT FLOORED
   [THEN]

CREATE CORE          TRUE , ' CORE          EXPORT CORE
CREATE CORE-EXT      TRUE , ' CORE-EXT      EXPORT CORE-EXT
CREATE DOUBLE        TRUE , ' DOUBLE        EXPORT DOUBLE
CREATE DOUBLE-EXT    TRUE , ' DOUBLE-EXT    EXPORT DOUBLE-EXT
CREATE EXCEPTION     TRUE , ' EXCEPTION     EXPORT EXCEPTION
CREATE EXCEPTION-EXT TRUE , ' EXCEPTION-EXT EXPORT EXCEPTION-EXT
CREATE FILE          TRUE , ' FILE          EXPORT FILE
CREATE FILE-EXT      TRUE , ' FILE-EXT      EXPORT FILE-EXT
CREATE LOCALS        TRUE , ' LOCALS        EXPORT LOCALS
CREATE LOCALS-EXT    TRUE , ' LOCALS-EXT    EXPORT LOCALS-EXT
CREATE SEARCH        TRUE , ' SEARCH        EXPORT SEARCH
CREATE SEARCH-EXT    TRUE , ' SEARCH-EXT    EXPORT SEARCH-EXT
CREATE STRING        TRUE , ' STRING        EXPORT STRING
CREATE STRING-EXT    TRUE , ' STRING-EXT    EXPORT STRING-EXT
CREATE WORDLISTS     9    , ' WORDLISTS     EXPORT WORDLISTS

FORTH-WID SET-CURRENT

\ EOF