\ Table Copyright MP7 1995
\ Copyright 1997,2008 HanSoft & Partners
\ Replaces IBM codes with HTML codes

[needs lib/row.4th]

table ASCII>HTML
    \ traitements signes reserves HTML
    060 , ," &lt;"                     \ Signe inferieur a
    062 , ," &gt;"                     \ Signe supreieur a
    038 , ," &amp;"                    \ Ampersand
    034 , ," &quot;"                   \ Signe double appostrophe
    \ traitement caracteres minuscules
    160 , ," &aacute;"                 \ a minuscule, accent aigu
    133 , ," &agrave;"                 \ a minuscule, accent grave
    131 , ," &acirc;"                  \ a minuscule, accent circonflexe
    134 , ," &aring;"                  \ a minuscule, ring
    132 , ," &auml;"                   \ a minuscule, dieresis or umlaut mark
    145 , ," &aelig;"                  \ a minusculee dipthong (ligature)
    135 , ," &ccedil;"                 \ c minuscule, cedille
    130 , ," &eacute;"                 \ e minuscule, accent aigu
    138 , ," &egrave;"                 \ e minuscule, accent grave
    136 , ," &ecirc;"                  \ e minuscule, accent circonflexe
    137 , ," &euml;"                   \ e minuscule, trema
    161 , ," &iacute;"                 \ i minuscule, accent aigu
    141 , ," &igrave;"                 \ i minuscule, accent grave
    140 , ," &icirc;"                  \ i minuscule, accent circonflexe
    139 , ," &iuml;"                   \ i minuscule, trema
    164 , ," &ntilde;"                 \ n minuscule, tilde
    162 , ," &oacute;"                 \ o minuscule, accent aigu
    149 , ," &ograve;"                 \ o minuscule, accent grave
    147 , ," &ocirc;"                  \ o minuscule, accent circonflexe
    148 , ," &ouml;"                   \ o minuscule, trema
    237 , ," &oslash;"                 \ o minuscule, slash
    163 , ," &uacute;"                 \ u minuscule, accent aigu
    151 , ," &ugrave;"                 \ u minuscule, accent grave
    150 , ," &ucirc;"                  \ u minuscule, accent circonflexe
    129 , ," &uuml;"                   \ u minuscule, dieresis or umlaut mark
    152 , ," &yuml;"                   \ y minuscule, dieresis or umlaut mark
    \ traitement des caracteres majuscules
    143 , ," &Aring;"                  \ A majuscule, ring
    142 , ," &Auml;"                   \ A majuscule, trema
    146 , ," &AElig;"                  \ AE majuscules lies
    128 , ," &Ccedil;"                 \ C majuscule, cedille
    144 , ," &Eacute;"                 \ E majuscule, accent aigu
    165 , ," &Ntilde;"                 \ N majuscule, tilde
    153 , ," &Ouml;"                   \ O majuscule, trema
    154 , ," &Uuml;"                   \ U majuscule, trema
    \ caracteres speciaux
    225 , ," &szlig;"                  \ S-Zet allemand
    \ Symboles divers
    173 , ," &#161;"                   \ exclamation inverse
    155 , ," &#162;"                   \ signe cents americains
    156 , ," &#163;"                   \ Livre Streling
    157 , ," &#165;"                   \ Signe Yen
    124 , ," &#166;"                   \ Broken vertical bar
    174 , ," &#171;"                   \ Left angle quote, guillemotleft
    170 , ," &#172;"                   \ Not sign
    248 , ," &#176;"                   \ Degree sign
    241 , ," &#177;"                   \ Plus or minus
    253 , ," &#178;"                   \ 2 exposant
    230 , ," &#181;"                   \ signe Micro sign
    250 , ," &#183;"                   \ Middle dot
    175 , ," &#187;"                   \ Right angle quote, guillemotright
    171 , ," &#189;"                   \ Fraction one-half
    168 , ," &#191;"                   \ Inverted question mark
    NULL ,

: Substitute          ( n --)          \ convert codes
  dup                                  \ save original
  ASCII>HTML 2 num-key row             \ search table
  if                                   \ if HTML code drop original
    nip nip cell+ @c count type        \ output HTML code
  else                                 \ else drop dummy code
    drop drop emit                     \ emit original
  then
;

: Usage abort" Usage: ASC2HTML [ascii file] [HTML file]" ;

: PreProcess
  ." <HTML>" cr                        \ write heading
  ." <BODY>" cr
  ." <PRE>" cr
;

: Read-file pad 1 accept 0<> ;         \ get character, check EOF
: Process pad c@ Substitute ;          \ convert code

: PostProcess 
  ." </PRE>" cr
  ." </BODY>" cr
  ." </HTML>" cr                       \ write footer
;

[needs lib/convert.4th]
