;****************************************************************
; A 'GNU DJGPP GO32' like linear video buffer for CauseWay.
; J.P. 1995

.386

DGROUP  group   _DATA
_DATA   segment 'DATA'

ALIGN   4

OldHandlerOFF        dd  0  ; Old 0E handler
OldHandlerSEL        dd  0  ; Old 0E handler

_CR2AddrOFF          dd  0  ; Address of CR2 image
_CR2AddrSEL          dd  0  ; Address of CR2 image

FAULT_ADDR           dd  ?  ; CR2

_LinearVideoAddr     dd  0  ; Linear video address (start)
_LinearVideoEnd      dd  0  ; Linear video address (end)

CurrentPage          dd  0  ;This a page descriptor addr
CurrentBank          dd  0  ;This is current active bank (64 k or 16 pages)  (0..n)


Message              db  'Ŀ',13d,10d
                     db  ' Interrupt 0E occurs out of linear video frame. ',13d,10d
                     db  ' Pass control to default exception handler...   ',13d,10d
                     db  '',13d,10d,'$'

_DATA   ends

_TEXT SEGMENT BYTE PUBLIC USE32 'CODE'
  ASSUME  CS:_TEXT
  ASSUME  DS:DGROUP

PUBLIC  EnableLinearVideo_
PUBLIC  CloseLinearVideo_

PUBLIC  _LinearVideoAddr
PUBLIC  _LinearVideoEnd
PUBLIC  _CR2AddrOFF
PUBLIC  _CR2AddrSEL


;*************************************************************
;    Here are three functions for user.
;    VideoPrologue   : init video card.Called once at start
;    VideoEpilogue   : reset video card. Called once at end
;    VideoBankSwitch : select bank in eax or at [CurrentBank]
;
;    Here is a sample for VESA, 64 kB granularity banks.
;    For instance,if granularity is 4Kb, multiply bank number by 16
;
;*************************************************************

VideoPrologue PROC
  ret
VideoPrologue ENDP


VideoEpilogue PROC
  ret
VideoEpilogue ENDP


VideoBankSwitch PROC
  mov edx,eax
  mov eax,4f05h
  xor ebx,ebx
  int 10h
  ret
VideoBankSwitch ENDP


;**************************************************
;  Here is the trap 0E handler
;**************************************************

Trap0EHandler  PROC FAR
  pushad

; Get fault address

  push  es
  mov   eax,[_CR2AddrSEL]
  mov   es,ax
  mov   ebx,[_CR2AddrOFF]
  mov   eax,es:[ebx]
  pop   es

  mov   [FAULT_ADDR],eax

; Call the paging function with eax=the 4k page to set (starts as 0).
; verify if eax is into the video window

  cmp   eax,dword ptr _LinearVideoAddr
  jb    RealFault
  dec   ecx                            ; dummy instruction for jump
  cmp   eax,dword ptr _LinearVideoEnd
  ja    RealFault
  dec   ecx                            ; dummy instruction for jump

; set prev pages disable and new pages OK.
; Get fault address in eax and convert to page address at 64kB boundary

  shr   eax,12
  shl   eax,2
  add   eax,0FFC00000h
  and   eax,0FFFFFFC0h

; Set the 16 pages as valid and the previous as disabled

  or    dword ptr [eax][00h],0000000001h        ; enable actual 64k bank (16 pages)
  or    dword ptr [eax][04h],0000000001h
  or    dword ptr [eax][08h],0000000001h
  or    dword ptr [eax][0Ch],0000000001h
  or    dword ptr [eax][10h],0000000001h
  or    dword ptr [eax][14h],0000000001h
  or    dword ptr [eax][18h],0000000001h
  or    dword ptr [eax][1Ch],0000000001h
  or    dword ptr [eax][20h],0000000001h
  or    dword ptr [eax][24h],0000000001h
  or    dword ptr [eax][28h],0000000001h
  or    dword ptr [eax][2Ch],0000000001h
  or    dword ptr [eax][30h],0000000001h
  or    dword ptr [eax][34h],0000000001h
  or    dword ptr [eax][38h],0000000001h
  or    dword ptr [eax][3Ch],0000000001h

  mov   ebx,[CurrentPage]
  and   ebx,0ffffffffh
  jz    SkipOnce

  and   dword ptr [ebx][00h],0fffffffeh        ; disable old 64k bank (16 pages)
  and   dword ptr [ebx][04h],0fffffffeh
  and   dword ptr [ebx][08h],0fffffffeh
  and   dword ptr [ebx][0Ch],0fffffffeh
  and   dword ptr [ebx][10h],0fffffffeh
  and   dword ptr [ebx][14h],0fffffffeh
  and   dword ptr [ebx][18h],0fffffffeh
  and   dword ptr [ebx][1Ch],0fffffffeh
  and   dword ptr [ebx][20h],0fffffffeh
  and   dword ptr [ebx][24h],0fffffffeh
  and   dword ptr [ebx][28h],0fffffffeh
  and   dword ptr [ebx][2Ch],0fffffffeh
  and   dword ptr [ebx][30h],0fffffffeh
  and   dword ptr [ebx][34h],0fffffffeh
  and   dword ptr [ebx][38h],0fffffffeh
  and   dword ptr [ebx][3Ch],0fffffffeh

; compute the page descriptor addr according eax -> ebx

SkipOnce :
  mov   [CurrentPage],eax

; Compute bank

  mov   eax,[FAULT_ADDR]
  sub   eax,[_LinearVideoAddr]
  shr   eax,16

  mov   [CurrentBank],eax
  Call  VideoBankSwitch

  popad
  retf

; Go here in case of unexpected exception 0E
; Jump to default handler

RealFault:

; output message and quit

  mov   ax,3
  int   10h
  mov   edx,offset Message
  mov   ax,_DATA
  mov   es,ax
  mov   ah,9
  int   21h

  popad

  push  dword [OldHandlerSEL]  ; simulate a far jump to old handler...
  push  dword [OldHandlerOFF]
  retf

Trap0EHandler  ENDP



;*****************************************************
; Function for initialisation

EnableLinearVideo_  PROC
  push  ebx
  push  ecx
  push  edx

  mov   eax,202h       ; get old 0E handler address
  mov   bl,0eh
  int   31h

  or    eax,1
  jc    EnableExceptErr
  mov   [OldHandlerOFF],edx
  and   ecx,0ffffh
  mov   [OldHandlerSEL],ecx

  mov   eax,203h       ; set new 0E handler address
  mov   bl,0eh
  mov   cx,_TEXT                   ; seg
  mov   edx,offset Trap0EHandler   ; offs
  int   31h
  or    eax,1
  jc    EnableExceptErr

  call  VideoPrologue

  xor   eax,eax

EnableExceptErr :

  pop   edx
  pop   ecx
  pop   ebx
  ret
EnableLinearVideo_  ENDP

;*****************************************************
; Function for restore

CloseLinearVideo_  PROC
  push  ebx
  push  ecx
  push  edx

  xor   eax,eax
  or    eax,[OldHandlerOFF]
  or    eax,[OldHandlerSEL]
  jz    Quit

  call  VideoEpilogue

  mov   edx,[OldHandlerOFF]
  mov   ecx,[OldHandlerSEL]
  mov   eax,203h             ; restore handler address
  mov   bl,0eh
  int   31h

  xor   eax,eax
  mov   [OldHandlerOFF],eax
  mov   [OldHandlerSEL],eax

  mov   eax,801h             ; free physical zone allocated by int31/ax=800h
  mov   ebx,[_LinearVideoAddr]
  or    ebx,ebx
  jz    Quit
  mov   ecx,ebx
  shr   ebx,16
  and   ecx,0ffffh
  int   31h
  xor   eax,eax

Quit:
  pop  edx
  pop  ecx
  pop  ebx
  ret
CloseLinearVideo_  ENDP


_TEXT           ENDS
END
