.\" Converted with mdoc2man 0.2
.\" from NiH: zip_delete.mdoc,v 1.11 2005/06/09 21:14:54 wiz Exp 
.\" $NiH: zip_delete.man,v 1.10 2005/06/17 12:59:05 wiz Exp $
.\"
.\" zip_delete.mdoc \-- delete files from zip archive
.\" Copyright (C) 2003, 2005 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <nih@giga.or.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_DELETE 3 "October 3, 2003" NiH
.SH "NAME"
zip_delete \- delete file from zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
.In zip.h
.Ft int
.Fn zip_delete "struct zip *archive" "int index"
.SH "DESCRIPTION"
The file at position
\fBindex\fR
in the zip archive
\fBarchive\fR
is marked as deleted.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
.Fn zip_delete
fails if:
.RS
.TP 4
Bq Er ZIP_ER_INVAL
\fBindex\fR
is not a valid file index in
\fBarchive.\fR
.RE
.SH "SEE ALSO"
libzip(3),
zip_unchange(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
