/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Module level structures and function prototypes.
*
****************************************************************************/


enum {
    MODS_PER_BLK = 256,
};

typedef struct mod_blk{
    struct mod_blk     *next;
    mod_info           *info; /*variable*/
}mod_blk;

typedef enum {
    VER_NONE,
    VER_V1,     /* Watcom 10.x */
    VER_V2,     /* Watcom 11.0 and early Open Watcom */
    VER_V3,     /* Open Watcom 1.4 and newer */
    VER_ERROR,
}df_ver;

typedef struct {
    mod_blk  *head;
    mod_blk  *curr;
    mod_blk  **lnk;
    int      count;
    df_ver   version;
}mod_list;
extern void  InitModList( mod_list *list );
extern  mod_info *NextModInfo( mod_list *list );
extern mod_info  *FiniModInfo( mod_list *list );
