/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


/*

  Brmtypes.h    - type declarations for the Optima++ .BRI format

*/

#ifndef BRMTYPES_H
#define BRMTYPES_H

#include <watcom.h>

#define BRI_MAGIC       0x0d4d5242      // "BRM\n"
#define BRI_MAJOR_VER   1
#define BRI_MINOR_VER   100

typedef uint_32                 BRI_SymbolID;
typedef uint_32                 BRI_StringID;
typedef uint_32                 BRI_TypeID;
typedef uint_32                 BRI_ScopeID;

#define BRI_NULL_ID             ((uint_32) 0x0)

/*********************************************************************

NOTE:  To save space, browse information is stored unaligned, i.e.
with 0-byte structure packing.  Since the compiler default is 4-byte
packing (and may change to 8-byte packing for all I know) the structure
definitions below do not correspond byte-for-byte with the data that
appears in a browse file.  Use care when loading from or saving to disk.
I have tried to include the unaligned sizes of all important data
structures as #define-d constants.

*********************************************************************/


typedef enum BRI_SymbolAttributes {         // ATTRIBUTES OF A SYMBOL
    BRI_SA_None             = 0x0000,
    BRI_SA_Label            = 0x0001,       // - goto label
    BRI_SA_Variable         = 0x0002,       // - variable, member, or parm
    BRI_SA_Parameter        = 0x0003,       // - formal parameter
    BRI_SA_Typedef          = 0x0004,       // - typedef
    BRI_SA_Class            = 0x0005,       // - class
    BRI_SA_Struct           = 0x0006,       // - struct
    BRI_SA_Union            = 0x0007,       // - union
    BRI_SA_Enum             = 0x0008,       // - enumeration type
    BRI_SA_Function         = 0x0009,       // - function
    BRI_SA_Macro            = 0x000a,       // - macro
    BRI_SA_TypeMask         = 0x000f,       // - mask of symbol type bits

    BRI_SA_Temporary        = 0x0010,       // - symbol generated by merger
    BRI_SA_TempInst         = 0x0020,       // - instance of a template
    BRI_SA_FlagMask         = 0x00f0,       // - mask of flag bits

    BRI_SA_AccessNone       = 0x0000,       // - no access specified
    BRI_SA_AccessPrivate    = 0x0400,       // - private access
    BRI_SA_AccessProtected  = 0x0800,       // - protected access
    BRI_SA_AccessPublic     = 0x0200,       // - public access
    BRI_SA_AccessMask       = 0x0f00,       // - mask of access bits
} BRI_SymbolAttributes;

#define BRI_SIZE_SYMBOLATTRIBUTES       2

typedef enum BRI_ScopeType {            // TYPES OF SCOPES
    BRI_ST_File         = 0x00,
    BRI_ST_Class        = 0x01,
    BRI_ST_Function     = 0x02,
    BRI_ST_Block        = 0x03,
    BRI_ST_TemplateDecl = 0x04,
    BRI_ST_TemplateInst = 0x05,
    BRI_ST_TemplateParm = 0x06,
} BRI_ScopeType;

#define BRI_SIZE_SCOPETYPE              1

typedef enum BRI_ReferenceType {        // TYPE OF REFERENCE TO "X"
    BRI_RT_None         = 0x00,
    BRI_RT_Function     = 0x03,         // - "X" is a function symbol
    BRI_RT_ClsMember    = 0x04,         // - "X" is a class member
    BRI_RT_Var          = 0x05,         // - "X" is a variable
    BRI_RT_TypeOf       = 0x06,         // - "X" is a type
    BRI_RT_Enum         = 0x07,         // - "X" is an enum
    BRI_RT_InheritFrom  = 0x08,         // - inherit from base class "X"
    BRI_RT_Friend       = 0x09,         // - declare "X" a friend
    BRI_RT_Macro        = 0x0a,         // - "X" is a macro
    BRI_RT_Unknown      = 0x0b,         // - unknown reference type
} BRI_ReferenceType;

#define BRI_SIZE_REFERENCETYPE  1

typedef enum BRI_TypeCode {     // KINDS OF TYPES
                                //  num_ops     Interpretation
    BRI_TC_None         = 0x00, //  -------     --------------
    BRI_TC_BaseType     = 0x81, //    1         code identifying the type
    BRI_TC_Modifier     = 0x1a, //    2         modifier flags and parent type
    BRI_TC_Pointer      = 0x12, //    1         parent type
    BRI_TC_PtrToMember  = 0x1b, //    2         class and member type
    BRI_TC_Reference    = 0x85, //    1         parent type
    BRI_TC_Array        = 0x17, //    2         size and element type
    BRI_TC_Function     = 0x16, //  variable    return type and args
    BRI_TC_Class        = 0x14, //    2         name_id and symbol_id
    BRI_TC_Struct       = 0x89, //    "                  "
    BRI_TC_Union        = 0x8a, //    "                  "
    BRI_TC_Enum         = 0x11, //    "                  "
    BRI_TC_TypeDef      = 0x13, //    1         parent type
    BRI_TC_BitField     = 0x15, //    1         field width
} BRI_TypeCode;

#define BRI_TCM_CONST   0x1     // "const" modifier flag
#define BRI_SIZE_TYPECODE       1       // type-codes occupy 1 byte

typedef enum BRI_BaseTypes {
    BRI_TYP_BOOL        = 0x01,
    BRI_TYP_CHAR        = 0x02,
    BRI_TYP_SCHAR       = 0x03,
    BRI_TYP_UCHAR       = 0x04,
    BRI_TYP_WCHAR       = 0x05,
    BRI_TYP_SSHORT      = 0x06,
    BRI_TYP_USHORT      = 0x07,
    BRI_TYP_SINT        = 0x08,
    BRI_TYP_UINT        = 0x09,
    BRI_TYP_SLONG       = 0x0a,
    BRI_TYP_ULONG       = 0x0b,
    BRI_TYP_SLONG64     = 0x0c,
    BRI_TYP_ULONG64     = 0x0d,
    BRI_TYP_FLOAT       = 0x0e,
    BRI_TYP_DOUBLE      = 0x0f,
    BRI_TYP_LONG_DOUBLE = 0x10,
    BRI_TYP_VOID        = 0x19,
    BRI_TYP_DOT_DOT_DOT = 0x18,
    BRI_TYP_GENERIC     = 0x1c,
} BRI_BaseTypes;

#define BRI_SIZE_BASETYPES      1


typedef enum BRI_GuardTypes {   // TYPES OF GUARD INFORMATION
    BRI_GT_Value        = 0x00,
    BRI_GT_RefValue     = 0x01,
    BRI_GT_RefUndef     = 0x02,
    BRI_GT_Defined      = 0x03,
    BRI_GT_NotDefined   = 0x04,
    BRI_GT_Declaration  = 0x09, // tags declaration of a macro
} BRI_GuardTypes;

#define BRI_SIZE_GUARDTYPES     1

typedef enum BRI_RecordType {   // TYPES OF .BRI RECORDS
    BRI_Rec_Declaration         = 0x00,
    BRI_Rec_File                = 0x01,
    BRI_Rec_FileEnd             = 0x02,
    BRI_Rec_Scope               = 0x03,
    BRI_Rec_ScopeEnd            = 0x04,
    BRI_Rec_Delta               = 0x05,
    BRI_Rec_Usage               = 0x06,
    BRI_Rec_String              = 0x07,
    BRI_Rec_Type                = 0x08,
    BRI_Rec_Guard               = 0x09,
    BRI_Rec_Definition          = 0x0a,
    BRI_Rec_Template            = 0x0c,
    BRI_Rec_TemplateEnd         = 0x0d,
    BRI_Rec_PCHInclude          = 0x0e,
} BRI_RecordType;

#define BRI_SIZE_RECORDTYPE     1

typedef struct BRI_File {
    BRI_StringID        filename_id;    // index of a string record
} BRI_File;

#define BRI_SIZE_FILE   (sizeof(BRI_StringID))


typedef struct BRI_Template {
    BRI_StringID        filename_id;    // index of a string record
} BRI_Template;

#define BRI_SIZE_TEMPLATE       (sizeof(BRI_StringID))

typedef struct BRI_String {
    BRI_StringID        index;          // index of this string
    uint_32             string_length;  // including '\0'
//  followed by a variable-length '\0'-terminated string
} BRI_String;

#define BRI_MIN_SIZE_STRING     (sizeof(BRI_StringID)   \
                                +sizeof(uint_32))


/*********************************************************************
  Warning:  in a browse file, scope records are either BRI_MIN_SIZE_SCOPE
            bytes long or BRI_MIN_SIZE_SCOPE+4 bytes long.  Only function
            scopes require the larger size.  When reading a BRI_Scope
            record from disk, use the "flags" field to decide whether to
            read the extra 4 bytes.
*********************************************************************/

typedef struct BRI_Scope {
    BRI_ScopeID         index;          // index of this scope
    BRI_ScopeType       flags;
    union {
        struct {
            BRI_StringID        fn_name_index;  // Name and type of function,
            BRI_TypeID          fn_type_index;  //    if function scope
        } fn;
        BRI_TypeID      type_index;     // type, if class scope
    };
} BRI_Scope;

#define BRI_MIN_SIZE_SCOPE      (sizeof(BRI_ScopeID)    \
                                +BRI_SIZE_SCOPETYPE     \
                                +sizeof(BRI_TypeID))


typedef struct BRI_Delta {
    int_8               delta_col;
    int_16              delta_line;
} BRI_Delta;

#define BRI_SIZE_DELTA  (sizeof(int_8)                  \
                        +sizeof(int_16))


typedef struct BRI_Definition {
    uint_32             column;
    uint_32             line;
    BRI_StringID        filename;
    BRI_SymbolID        symbol_index;   // index of a declaration record
} BRI_Definition;

#define BRI_SIZE_DEFINITION     (sizeof(uint_32)        \
                                +sizeof(uint_32)        \
                                +sizeof(BRI_StringID)   \
                                +sizeof(BRI_SymbolID))


typedef struct BRI_Usage {
    BRI_ReferenceType   type;
    int_8               delta_col;
    int_16              delta_line;
    union {
        BRI_SymbolID    target_index;   // index of a Declaration record.
        BRI_TypeID      type_index;     // Used only when type==BRI_RT_TypeOf
    };
} BRI_Usage;

#define BRI_SIZE_USAGE  (BRI_SIZE_REFERENCETYPE         \
                        +sizeof(int_8)                  \
                        +sizeof(int_16)                 \
                        +sizeof(BRI_SymbolID))


typedef struct BRI_Declaration {
    BRI_SymbolID                index;          // Index of this Symbol
    BRI_SymbolAttributes        attributes;
    BRI_StringID                name_id;        // index of a string record
    BRI_TypeID                  type_id;        // index of a type record
} BRI_Declaration;

#define BRI_SIZE_DECLARATION    (sizeof(BRI_SymbolID)           \
                                +BRI_SIZE_SYMBOLATTRIBUTES      \
                                +sizeof(BRI_StringID)           \
                                +sizeof(BRI_TypeID))


typedef struct BRI_Type {
    BRI_TypeID          index;          // Index of this type
    BRI_TypeCode        typecode;
    uint_32             num_ops;        // number of dwords to follow
//  followed by a variable number of data dwords.
} BRI_Type;

#define BRI_MIN_SIZE_TYPE       (sizeof(BRI_TypeID)     \
                                +BRI_SIZE_TYPECODE      \
                                +sizeof(uint_32))


typedef struct BRI_Guard {
    BRI_GuardTypes      type;
    uint_32             string_id;

    /* Only meaningful if type==BRI_GT_Value */
    uint_32             num_params;
    uint_32             defn_len;
//  followed by a variable-length vector of uint_8's for the definition
} BRI_Guard;

#define BRI_MIN_SIZE_GUARD      (BRI_SIZE_GUARDTYPES    \
                                +sizeof(uint_32)        \
                                +sizeof(uint_32)        \
                                +sizeof(uint_32))


typedef struct BRI_PCHInclude {
    BRI_StringID        filename_id;    // index of a string record
} BRI_PCHInclude;

#define BRI_SIZE_PCHINCLUDE     (sizeof(BRI_StringID))


typedef struct BRI_Header {
    uint_32             magic;
    uint_32             major_ver;
    uint_32             minor_ver;
    uint_32             num_declaration;
    uint_32             num_file;
    uint_32             num_scope;
    uint_32             num_delta;
    uint_32             num_definition;
    uint_32             num_usage;
    uint_32             num_string;
    uint_32             num_type;
    uint_32             num_guard;
    uint_32             num_template;
    uint_32             num_pch;
    uint_32             file_len;
} BRI_Header;


#endif  // BRMTYPES_H
