/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Implementation of chktty() - check if stream is teletype.
*
****************************************************************************/


#include "variety.h"
#include <stdio.h>
#include <malloc.h>
#include <unistd.h>
#include "rtdata.h"
#include "fileacc.h"
#include "streamio.h"


void __chktty( FILE  *fp )
{
    /* if we have not determined that we've got a tty then check for one */
    if( !(fp->_flag & _ISTTY) ) {
        if( isatty( fileno( fp ) ) ) {
            fp->_flag |= _ISTTY;
            if( ( fp->_flag & (_IONBF | _IOLBF | _IOFBF) ) == 0 ) {
                fp->_flag |= _IOLBF;
            }
        }
    }
}
