''
''
'' dislin -- Scientific data plotting library
''			 (header translated with help of SWIG FB wrapper)
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __dislin_bi__
#define __dislin_bi__

#inclib "dismgc"

#ifdef DISLIN_DBL
# define DISLIN_TYPE double
#else
# define DISLIN_TYPE single
#endif

extern "c"
declare sub circle_ alias "circle" (byval nx as integer, byval ny as integer, byval nr as integer)
declare sub color_ alias "color" (byval col as zstring ptr)
declare sub erase_ alias "erase" ()
declare sub field_ alias "field" (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval uray as DISLIN_TYPE ptr, byval vray as DISLIN_TYPE ptr, byval n as integer, byval ivec as integer)
declare sub line_ alias "line" (byval nx as integer, byval ny as integer, byval nu as integer, byval nv as integer)
declare sub name_ alias "name" (byval cstr as zstring ptr, byval cax as zstring ptr)
declare sub point_ alias "point" (byval nx as integer, byval ny as integer, byval nb as integer, byval nh as integer, byval ncol as integer)
declare sub reset_ alias "reset" (byval cname as zstring ptr)
declare sub window_ alias "window" (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer)
declare sub abs3pt (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE, byval xp as DISLIN_TYPE ptr, byval yp as DISLIN_TYPE ptr)
declare sub addlab (byval cstr as zstring ptr, byval v as DISLIN_TYPE, byval itic as integer, byval cax as zstring ptr)
declare sub angle (byval ngrad as integer)
declare sub arcell (byval nx as integer, byval ny as integer, byval na as integer, byval nb as integer, byval a as DISLIN_TYPE, byval b as DISLIN_TYPE, byval t as DISLIN_TYPE)
declare sub areaf (byval nxray as integer ptr, byval nyray as integer ptr, byval n as integer)
declare sub autres (byval ixdim as integer, byval iydim as integer)
declare sub ax2grf ()
declare sub ax3len (byval nxl as integer, byval nyl as integer, byval nzl as integer)
declare sub axclrs (byval nclr as integer, byval copt as zstring ptr, byval cax as zstring ptr)
declare sub axends (byval cstr as zstring ptr, byval cax as zstring ptr)
declare sub axgit ()
declare sub axis3d (byval x3 as DISLIN_TYPE, byval y3 as DISLIN_TYPE, byval z3 as DISLIN_TYPE)
declare sub axsbgd (byval nclr as integer)
declare sub axslen (byval nxl as integer, byval nyl as integer)
declare sub axsorg (byval nxa as integer, byval nya as integer)
declare sub axspos (byval nxa as integer, byval nya as integer)
declare sub axsscl (byval cscl as zstring ptr, byval cax as zstring ptr)
declare sub axstyp (byval copt as zstring ptr)
declare sub barbor (byval iclr as integer)
declare sub barclr (byval ic1 as integer, byval ic2 as integer, byval ic3 as integer)
declare sub bargrp (byval ngrp as integer, byval gap as DISLIN_TYPE)
declare sub barmod (byval cmod as zstring ptr, byval copt as zstring ptr)
declare sub baropt (byval xf as DISLIN_TYPE, byval a as DISLIN_TYPE)
declare sub barpos (byval copt as zstring ptr)
declare sub bars (byval xray as DISLIN_TYPE ptr, byval y1ray as DISLIN_TYPE ptr, byval y2ray as DISLIN_TYPE ptr, byval n as integer)
declare sub bars3d (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval z1ray as DISLIN_TYPE ptr, byval z2ray as DISLIN_TYPE ptr, byval xwray as DISLIN_TYPE ptr, byval ywray as DISLIN_TYPE ptr, byval icray as integer ptr, byval n as integer)
declare sub bartyp (byval ctyp as zstring ptr)
declare sub barwth (byval factor as DISLIN_TYPE)
declare sub basalf (byval calph as zstring ptr)
declare sub basdat (byval id as integer, byval im as integer, byval iy as integer)
declare sub bezier (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval nray as integer, byval x as DISLIN_TYPE ptr, byval y as DISLIN_TYPE ptr, byval n as integer)
declare function bitsi2 (byval nbits as integer, byval mher as short, byval iher as integer, byval mhin as short, byval ihin as integer) as short
declare function bitsi4 (byval nbits as integer, byval mher as integer, byval iher as integer, byval mhin as integer, byval ihin as integer) as integer
declare sub bmpfnt (byval copt as zstring ptr)
declare sub box2d ()
declare sub box3d ()
declare sub center ()
declare sub cgmbgd (byval xr as DISLIN_TYPE, byval xg as DISLIN_TYPE, byval xb as DISLIN_TYPE)
declare sub cgmpic (byval cstr as zstring ptr)
declare sub cgmver (byval nclr as integer)
declare sub chaang (byval angle as DISLIN_TYPE)
declare sub chacod (byval copt as zstring ptr)
declare sub chaspc (byval xspc as DISLIN_TYPE)
declare sub chawth (byval xwth as DISLIN_TYPE)
declare sub chnatt ()
declare sub chncrv (byval copt as zstring ptr)
declare sub chndot ()
declare sub chndsh ()
declare sub chnbar (byval copt as zstring ptr)
declare sub chnpie (byval copt as zstring ptr)
declare sub circ3p (byval x1 as DISLIN_TYPE, byval y1 as DISLIN_TYPE, byval x2 as DISLIN_TYPE, byval y2 as DISLIN_TYPE, byval x3 as DISLIN_TYPE, byval y3 as DISLIN_TYPE, byval xm as DISLIN_TYPE ptr, byval ym as DISLIN_TYPE ptr, byval r as DISLIN_TYPE ptr)
declare sub circsp (byval nspc as integer)
declare sub clip3d (byval ctyp as zstring ptr)
declare function closfl (byval nu as integer) as integer
declare sub clpbor (byval copt as zstring ptr)
declare sub clpmod (byval copt as zstring ptr)
declare sub clpwin (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer)
declare sub clrcyc (byval index as integer, byval iclr as integer)
declare sub clrmod (byval cmode as zstring ptr)
declare sub clswin (byval id as integer)
declare sub colran (byval nca as integer, byval nce as integer)
declare sub colray (byval zray as DISLIN_TYPE ptr, byval nray as integer ptr, byval n as integer)
declare sub complx ()
declare sub conclr (byval nray as integer ptr, byval n as integer)
declare sub concrv (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer, byval zlev as DISLIN_TYPE)
declare sub confll (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval zray as DISLIN_TYPE ptr, byval n as integer, byval i1ray as integer ptr, byval i2ray as integer ptr, byval i3ray as integer ptr, byval ntri as integer, byval zlev as DISLIN_TYPE ptr, byval nlev as integer)
declare sub congap (byval xfac as DISLIN_TYPE)
declare sub conlab (byval clab as zstring ptr)
declare sub conmat (byval zmat as DISLIN_TYPE ptr, byval n as integer, byval m as integer, byval zlev as DISLIN_TYPE)
declare sub conmod (byval xfac as DISLIN_TYPE, byval xquot as DISLIN_TYPE)
declare sub conn3d (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE)
declare sub connpt (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE)
declare sub conpts (byval xray as DISLIN_TYPE ptr, byval n as integer, byval yray as DISLIN_TYPE ptr, byval m as integer, byval zmat as DISLIN_TYPE ptr, byval zlev as DISLIN_TYPE, byval xpts as DISLIN_TYPE ptr, byval ypts as DISLIN_TYPE ptr, byval maxpts as integer, byval nray as integer ptr, byval maxray as integer, byval nlins as integer ptr)
declare sub conshd (byval xray as DISLIN_TYPE ptr, byval n as integer, byval yray as DISLIN_TYPE ptr, byval m as integer, byval zmat as DISLIN_TYPE ptr, byval zlev as DISLIN_TYPE ptr, byval nlev as integer)
declare sub contri (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval zray as DISLIN_TYPE ptr, byval n as integer, byval i1ray as integer ptr, byval i2ray as integer ptr, byval i3ray as integer ptr, byval ntri as integer, byval zlev as DISLIN_TYPE)
declare sub contur (byval xray as DISLIN_TYPE ptr, byval n as integer, byval yray as DISLIN_TYPE ptr, byval m as integer, byval zmat as DISLIN_TYPE ptr, byval zlev as DISLIN_TYPE)
declare sub cross ()
declare sub crvmat (byval zmat as DISLIN_TYPE ptr, byval n as integer, byval m as integer, byval ixpts as integer, byval iypts as integer)
declare sub crvtri (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval zray as DISLIN_TYPE ptr, byval n as integer, byval i1ray as integer ptr, byval i2ray as integer ptr, byval i3ray as integer ptr, byval ntri as integer)
declare sub csrmod (byval cmod as zstring ptr, byval ckey as zstring ptr)
declare function csrpos (byval ix as integer ptr, byval iy as integer ptr) as integer
declare sub csrpt1 (byval ix as integer ptr, byval iy as integer ptr)
declare sub csrpts (byval ix as integer ptr, byval iy as integer ptr, byval nmax as integer, byval n as integer ptr, byval iret as integer ptr)
declare sub csrmov (byval ix as integer ptr, byval iy as integer ptr, byval nmax as integer, byval n as integer ptr, byval iret as integer ptr)
declare sub csrtyp (byval copt as zstring ptr)
declare sub csruni (byval copt as zstring ptr)
declare sub curv3d (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval zray as DISLIN_TYPE ptr, byval n as integer)
declare sub curve (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer)
declare sub curve3 (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval zray as DISLIN_TYPE ptr, byval n as integer)
declare sub curvmp (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer)
declare sub curvx3 (byval xray as DISLIN_TYPE ptr, byval y as DISLIN_TYPE, byval zray as DISLIN_TYPE ptr, byval n as integer)
declare sub curvy3 (byval x as DISLIN_TYPE, byval yray as DISLIN_TYPE ptr, byval zray as DISLIN_TYPE ptr, byval n as integer)
declare sub dash ()
declare sub dashl ()
declare sub dashm ()
declare sub dattim (byval cdate as zstring ptr, byval ctime as zstring ptr)
declare sub digits (byval ndig as integer, byval cax as zstring ptr)
declare sub disalf ()
declare sub disfin ()
declare sub disini ()
declare sub dot ()
declare sub dotl ()
declare sub duplx ()
declare function dwgbut (byval cstr as zstring ptr, byval ival as integer) as integer
declare function dwgfil (byval clab as zstring ptr, byval cstr as zstring ptr, byval cmask as zstring ptr) as zstring ptr
declare function dwglis (byval clab as zstring ptr, byval clis as zstring ptr, byval ilis as integer) as integer
declare sub dwgmsg (byval cstr as zstring ptr)
declare function dwgtxt (byval clab as zstring ptr, byval cstr as zstring ptr) as zstring ptr
declare sub ellips (byval nx as integer, byval ny as integer, byval na as integer, byval nb as integer)
declare sub endgrf ()
declare sub errbar (byval x as DISLIN_TYPE ptr, byval y as DISLIN_TYPE ptr, byval err1 as DISLIN_TYPE ptr, byval err2 as DISLIN_TYPE ptr, byval n as integer)
declare sub errdev (byval cdev as zstring ptr)
declare sub errfil (byval cfil as zstring ptr)
declare sub errmod (byval cstr as zstring ptr, byval copt as zstring ptr)
declare sub eushft (byval cnat as zstring ptr, byval cshf as zstring ptr)
declare sub expzlb (byval cstr as zstring ptr)
declare function fcha (byval x as DISLIN_TYPE, byval ndig as integer, byval cstr as zstring ptr) as integer
declare sub filbox (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer)
declare sub filclr (byval copt as zstring ptr)
declare sub filmod (byval cmod as zstring ptr)
declare sub fixspc (byval xfac as DISLIN_TYPE)
declare sub flab3d ()
declare function flen (byval x as DISLIN_TYPE, byval ndig as integer) as integer
declare sub frame (byval nfrm as integer)
declare sub frmclr (byval nclr as integer)
declare sub frmess (byval nfrm as integer)
declare sub gapcrv (byval xgap as DISLIN_TYPE)
declare function getalf () as zstring ptr
declare function getang () as integer
declare function getbpp () as integer
declare sub getclp (byval nx as integer ptr, byval ny as integer ptr, byval nw as integer ptr, byval nh as integer ptr)
declare function getclr () as integer
declare sub getdig (byval nxdig as integer ptr, byval nydig as integer ptr, byval nzdig as integer ptr)
declare function getdsp () as zstring ptr
declare function getfil () as zstring ptr
declare sub getgrf (byval a as DISLIN_TYPE ptr, byval e as DISLIN_TYPE ptr, byval org as DISLIN_TYPE ptr, byval step as DISLIN_TYPE ptr, byval cax as zstring ptr)
declare function gethgt () as integer
declare function gethnm () as integer
declare sub getind (byval index as integer, byval xr as DISLIN_TYPE ptr, byval xg as DISLIN_TYPE ptr, byval xb as DISLIN_TYPE ptr)
declare sub getlab (byval cx as zstring ptr, byval cy as zstring ptr, byval cz as zstring ptr)
declare sub getlen (byval nxl as integer ptr, byval nyl as integer ptr, byval nzl as integer ptr)
declare function getlev () as integer
declare function getlin () as integer
declare function getlit (byval xp as DISLIN_TYPE, byval yp as DISLIN_TYPE, byval zp as DISLIN_TYPE, byval xn as DISLIN_TYPE, byval yn as DISLIN_TYPE, byval zn as DISLIN_TYPE) as integer
declare sub getmat (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval zray as DISLIN_TYPE ptr, byval n as integer, byval zmat as DISLIN_TYPE ptr, byval nx as integer, byval ny as integer, byval zval as DISLIN_TYPE, byval imat as integer ptr, byval wmat as DISLIN_TYPE ptr)
declare function getmfl () as zstring ptr
declare function getmix (byval copt as zstring ptr) as zstring ptr
declare sub getor (byval nx0 as integer ptr, byval ny0 as integer ptr)
declare sub getpag (byval nxpag as integer ptr, byval nypag as integer ptr)
declare function getpat () as integer
declare function getplv () as integer
declare sub getpos (byval nxa as integer ptr, byval nya as integer ptr)
declare sub getran (byval nca as integer ptr, byval nce as integer ptr)
declare sub getres (byval npb as integer ptr, byval nph as integer ptr)
declare sub getrgb (byval xr as DISLIN_TYPE ptr, byval xg as DISLIN_TYPE ptr, byval xb as DISLIN_TYPE ptr)
declare sub getscl (byval nxscl as integer ptr, byval nyscl as integer ptr, byval nzscl as integer ptr)
declare sub getscr (byval nwidth as integer ptr, byval nheight as integer ptr)
declare function getshf (byval copt as zstring ptr) as zstring ptr
declare sub getsp1 (byval nxdis as integer ptr, byval nydis as integer ptr, byval nzdis as integer ptr)
declare sub getsp2 (byval nxdis as integer ptr, byval nydis as integer ptr, byval nzdis as integer ptr)
declare sub getsym (byval nxsym as integer ptr, byval nysym as integer ptr)
declare sub gettcl (byval nmaj as integer ptr, byval nmin as integer ptr)
declare sub gettic (byval nxtic as integer ptr, byval nytic as integer ptr, byval nztic as integer ptr)
declare function gettyp () as integer
declare function getuni () as any ptr
declare function getver () as DISLIN_TYPE
declare sub getvk (byval nv as integer ptr, byval nvfx as integer ptr, byval nvfy as integer ptr)
declare function getvlt () as zstring ptr
declare function getwid () as integer
declare sub getwin (byval ix as integer ptr, byval iy as integer ptr, byval nwidth as integer ptr, byval nheight as integer ptr)
declare function getxid (byval copt as zstring ptr) as integer
declare sub gifmod (byval cmod as zstring ptr, byval ckey as zstring ptr)
declare function gmxalf (byval copt as zstring ptr, byval ca as zstring ptr, byval cb as zstring ptr) as integer
declare sub gothic ()
declare sub grace (byval ngrace as integer)
declare sub graf (byval xa as DISLIN_TYPE, byval xe as DISLIN_TYPE, byval xorg as DISLIN_TYPE, byval xstp as DISLIN_TYPE, byval ya as DISLIN_TYPE, byval ye as DISLIN_TYPE, byval yorg as DISLIN_TYPE, byval ystp as DISLIN_TYPE)
declare sub graf3 (byval xa as DISLIN_TYPE, byval xe as DISLIN_TYPE, byval xorg as DISLIN_TYPE, byval xstp as DISLIN_TYPE, byval ya as DISLIN_TYPE, byval ye as DISLIN_TYPE, byval yorg as DISLIN_TYPE, byval ystp as DISLIN_TYPE, byval za as DISLIN_TYPE, byval ze as DISLIN_TYPE, byval zorg as DISLIN_TYPE, byval zstp as DISLIN_TYPE)
declare sub graf3d (byval xa as DISLIN_TYPE, byval xe as DISLIN_TYPE, byval xorg as DISLIN_TYPE, byval xstp as DISLIN_TYPE, byval ya as DISLIN_TYPE, byval ye as DISLIN_TYPE, byval yorg as DISLIN_TYPE, byval ystp as DISLIN_TYPE, byval za as DISLIN_TYPE, byval ze as DISLIN_TYPE, byval zorg as DISLIN_TYPE, byval zstp as DISLIN_TYPE)
declare sub grafmp (byval xa as DISLIN_TYPE, byval xe as DISLIN_TYPE, byval xorg as DISLIN_TYPE, byval xstp as DISLIN_TYPE, byval ya as DISLIN_TYPE, byval ye as DISLIN_TYPE, byval yorg as DISLIN_TYPE, byval ystp as DISLIN_TYPE)
declare sub grdpol (byval ixgrid as integer, byval iygrid as integer)
declare sub grffin ()
declare sub grfini (byval x1 as DISLIN_TYPE, byval y1 as DISLIN_TYPE, byval z1 as DISLIN_TYPE, byval x2 as DISLIN_TYPE, byval y2 as DISLIN_TYPE, byval z2 as DISLIN_TYPE, byval x3 as DISLIN_TYPE, byval y3 as DISLIN_TYPE, byval z3 as DISLIN_TYPE)
declare sub grid (byval ixgrid as integer, byval iygrid as integer)
declare sub grid3d (byval ixgrid as integer, byval iygrid as integer, byval copt as zstring ptr)
declare sub gridmp (byval ixgrid as integer, byval iygrid as integer)
declare function gwgatt (byval id as integer, byval copt as zstring ptr) as integer
declare function gwgbox (byval id as integer) as integer
declare function gwgbut (byval id as integer) as integer
declare sub gwgfil (byval id as integer, byval cfile as zstring ptr)
declare function gwglis (byval id as integer) as integer
declare function gwgscl (byval id as integer) as DISLIN_TYPE
declare sub gwgtxt (byval id as integer, byval ctext as zstring ptr)
declare function gwgxid (byval id as integer) as integer
declare sub height (byval nhchar as integer)
declare sub helve ()
declare sub helves ()
declare sub histog (byval xray as DISLIN_TYPE ptr, byval n as integer, byval x as DISLIN_TYPE ptr, byval y as DISLIN_TYPE ptr, byval m as integer ptr)
declare sub hname (byval nhchar as integer)
declare sub hsvrgb (byval xh as DISLIN_TYPE, byval xs as DISLIN_TYPE, byval xv as DISLIN_TYPE, byval xr as DISLIN_TYPE ptr, byval xg as DISLIN_TYPE ptr, byval xb as DISLIN_TYPE ptr)
declare sub hsymbl (byval nhsym as integer)
declare sub htitle (byval nhtit as integer)
declare sub hwfont ()
declare sub hworig (byval nx as integer, byval ny as integer)
declare sub hwpage (byval nw as integer, byval nh as integer)
declare sub imgbox (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer)
declare sub imgclp (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer)
declare sub imgfin ()
declare sub imgfmt (byval copt as zstring ptr)
declare sub imgini ()
declare sub imgmod (byval copt as zstring ptr)
declare sub imgsiz (byval nw as integer, byval nh as integer)
declare sub inccrv (byval ncrv as integer)
declare function incdat (byval id as integer, byval im as integer, byval iy as integer) as integer
declare sub incfil (byval cfil as zstring ptr)
declare sub incmrk (byval nmrk as integer)
declare function indrgb (byval xr as DISLIN_TYPE, byval xg as DISLIN_TYPE, byval xb as DISLIN_TYPE) as integer
declare sub intax ()
declare function intcha (byval nx as integer, byval cstr as zstring ptr) as integer
declare function intlen (byval nx as integer) as integer
declare function intrgb (byval xr as DISLIN_TYPE, byval xg as DISLIN_TYPE, byval xb as DISLIN_TYPE) as integer
declare sub itmcat (byval clis as zstring ptr, byval cstr as zstring ptr)
declare function itmcnt (byval clis as zstring ptr) as integer
declare function itmstr (byval clis as zstring ptr, byval nlis as integer) as zstring ptr
declare sub labclr (byval iclr as integer, byval copt as zstring ptr)
declare sub labdig (byval ndig as integer, byval cax as zstring ptr)
declare sub labdis (byval ndis as integer, byval cax as zstring ptr)
declare sub labels (byval clab as zstring ptr, byval cax as zstring ptr)
declare sub labjus (byval copt as zstring ptr, byval cax as zstring ptr)
declare sub labl3d (byval copt as zstring ptr)
declare sub labmod (byval ckey as zstring ptr, byval cval as zstring ptr, byval cax as zstring ptr)
declare sub labpos (byval cpos as zstring ptr, byval cax as zstring ptr)
declare sub labtyp (byval ctyp as zstring ptr, byval cax as zstring ptr)
declare sub legclr ()
declare sub legend (byval cbuf as zstring ptr, byval ncor as integer)
declare sub legini (byval cbuf as zstring ptr, byval nlin as integer, byval nmaxln as integer)
declare sub leglin (byval cbuf as zstring ptr, byval cstr as zstring ptr, byval ilin as integer)
declare sub legopt (byval x1 as DISLIN_TYPE, byval x2 as DISLIN_TYPE, byval x3 as DISLIN_TYPE)
declare sub legpat (byval ityp as integer, byval ithk as integer, byval isym as integer, byval ipat as integer, byval iclr as integer, byval ilin as integer)
declare sub legpos (byval nx as integer, byval ny as integer)
declare sub legtit (byval cstr as zstring ptr)
declare sub lfttit ()
declare sub light (byval copt as zstring ptr)
declare sub lincyc (byval index as integer, byval ityp as integer)
declare sub linesp (byval xfac as DISLIN_TYPE)
declare sub lintyp (byval ntyp as integer)
declare sub linwid (byval i as integer)
declare sub litmod (byval id as integer, byval copt as zstring ptr)
declare sub litop3 (byval id as integer, byval xr as DISLIN_TYPE, byval xg as DISLIN_TYPE, byval xb as DISLIN_TYPE, byval copt as zstring ptr)
declare sub litopt (byval id as integer, byval xval as DISLIN_TYPE, byval copt as zstring ptr)
declare sub litpos (byval id as integer, byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE, byval copt as zstring ptr)
declare sub lncap (byval copt as zstring ptr)
declare sub lnjoin (byval copt as zstring ptr)
declare sub lnmlt (byval x as DISLIN_TYPE)
declare sub logtic (byval cmod as zstring ptr)
declare sub lsechk (byval cmod as zstring ptr)
declare sub mapbas (byval cmod as zstring ptr)
declare sub mapfil (byval cfil as zstring ptr, byval copt as zstring ptr)
declare sub maplev (byval cmod as zstring ptr)
declare sub mapmod (byval cmod as zstring ptr)
declare sub mappol (byval xpol as DISLIN_TYPE, byval ypol as DISLIN_TYPE)
declare sub mapref (byval ylower as DISLIN_TYPE, byval yupper as DISLIN_TYPE)
declare sub mapsph (byval xrad as DISLIN_TYPE)
declare sub marker (byval nsym as integer)
declare sub matop3 (byval xr as DISLIN_TYPE, byval xg as DISLIN_TYPE, byval xb as DISLIN_TYPE, byval copt as zstring ptr)
declare sub matopt (byval xval as DISLIN_TYPE, byval copt as zstring ptr)
declare sub mdfmat (byval nx as integer, byval ny as integer, byval weight as DISLIN_TYPE)
declare sub messag (byval cstr as zstring ptr, byval nx as integer, byval ny as integer)
declare sub metafl (byval cstr as zstring ptr)
declare sub mixalf ()
declare sub mixleg ()
declare function moment (byval xray as DISLIN_TYPE ptr, byval n as integer, byval copt as zstring ptr) as DISLIN_TYPE
declare sub mpaepl (byval i as integer)
declare sub mplang (byval x as DISLIN_TYPE)
declare sub mplclr (byval nbg as integer, byval nfg as integer)
declare sub mplpos (byval nx as integer, byval ny as integer)
declare sub mplsiz (byval nsize as integer)
declare sub mpslogo (byval nx as integer, byval ny as integer, byval nsize as integer, byval copt as zstring ptr)
declare sub msgbox (byval cstr as zstring ptr)
declare sub mshclr (byval ic as integer)
declare sub mylab (byval cstr as zstring ptr, byval itick as integer, byval cax as zstring ptr)
declare sub myline (byval nray as integer ptr, byval n as integer)
declare sub mypat (byval iang as integer, byval itype as integer, byval idens as integer, byval icross as integer)
declare sub mysymb (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer, byval isym as integer, byval iflag as integer)
declare sub myvlt (byval xr as DISLIN_TYPE ptr, byval xg as DISLIN_TYPE ptr, byval xb as DISLIN_TYPE ptr, byval n as integer)
declare sub namdis (byval ndis as integer, byval cax as zstring ptr)
declare sub namjus (byval copt as zstring ptr, byval cax as zstring ptr)
declare sub neglog (byval eps as DISLIN_TYPE)
declare sub newmix ()
declare sub newpag ()
declare function nlmess (byval cstr as zstring ptr) as integer
declare function nlnumb (byval x as DISLIN_TYPE, byval ndig as integer) as integer
declare sub noarln ()
declare sub nobar ()
declare sub nobgd ()
declare sub nochek ()
declare sub noclip ()
declare sub nofill ()
declare sub nograf ()
declare sub nohide ()
declare sub noline (byval cax as zstring ptr)
declare sub number (byval x as DISLIN_TYPE, byval ndig as integer, byval nx as integer, byval ny as integer)
declare sub numfmt (byval copt as zstring ptr)
declare sub numode (byval cdec as zstring ptr, byval cgrp as zstring ptr, byval cpos as zstring ptr, byval cfix as zstring ptr)
declare function nwkday (byval id as integer, byval im as integer, byval iy as integer) as integer
declare function nxlegn (byval cbuf as zstring ptr) as integer
declare function nxposn (byval x as DISLIN_TYPE) as integer
declare function nylegn (byval cbuf as zstring ptr) as integer
declare function nyposn (byval y as DISLIN_TYPE) as integer
declare function nzposn (byval z as DISLIN_TYPE) as integer
declare function openfl (byval cfil as zstring ptr, byval nu as integer, byval irw as integer) as integer
declare sub opnwin (byval id as integer)
declare sub origin (byval nx0 as integer, byval ny0 as integer)
declare sub page (byval nw as integer, byval nh as integer)
declare sub pagera ()
declare sub pagfll (byval nclr as integer)
declare sub paghdr (byval cstr1 as zstring ptr, byval cstr2 as zstring ptr, byval iopt as integer, byval idir as integer)
declare sub pagmod (byval cmod as zstring ptr)
declare sub pagorg (byval cpos as zstring ptr)
declare sub patcyc (byval index as integer, byval ipat as integer)
declare function pdfbuf (byval cbuf as zstring ptr, byval nmax as integer) as integer
declare sub pdfmod (byval cmod as zstring ptr, byval ckey as zstring ptr)
declare sub pdfmrk (byval cstr as zstring ptr, byval copt as zstring ptr)
declare sub penwid (byval x as DISLIN_TYPE)
declare sub pie (byval nxm as integer, byval nym as integer, byval nr as integer, byval a as DISLIN_TYPE, byval b as DISLIN_TYPE)
declare sub piebor (byval iclr as integer)
declare sub pieclr (byval ic1 as integer ptr, byval ic2 as integer ptr, byval n as integer)
declare sub pieexp ()
declare sub piegrf (byval cbuf as zstring ptr, byval nlin as integer, byval xray as DISLIN_TYPE ptr, byval nseg as integer)
declare sub pielab (byval clab as zstring ptr, byval cpos as zstring ptr)
declare sub pieopt (byval xf as DISLIN_TYPE, byval a as DISLIN_TYPE)
declare sub pietyp (byval ctyp as zstring ptr)
declare sub pievec (byval ivec as integer, byval copt as zstring ptr)
declare sub pngmod (byval cmod as zstring ptr, byval ckey as zstring ptr)
declare sub polar (byval xe as DISLIN_TYPE, byval xorg as DISLIN_TYPE, byval xstp as DISLIN_TYPE, byval yorg as DISLIN_TYPE, byval ystp as DISLIN_TYPE)
declare sub polcrv (byval cpol as zstring ptr)
declare sub polmod (byval cpos as zstring ptr, byval cdir as zstring ptr)
declare sub pos2pt (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval xp as DISLIN_TYPE ptr, byval yp as DISLIN_TYPE ptr)
declare sub pos3pt (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE, byval xp as DISLIN_TYPE ptr, byval yp as DISLIN_TYPE ptr, byval zp as DISLIN_TYPE ptr)
declare function posifl (byval nu as integer, byval nbyte as integer) as integer
declare sub projct (byval cproj as zstring ptr)
declare sub psfont (byval cfont as zstring ptr)
declare sub psmode (byval cmod as zstring ptr)
declare sub qplot (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer)
declare sub qplsca (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer)
declare sub qplpie (byval xray as DISLIN_TYPE ptr, byval n as integer)
declare sub qplbar (byval yray as DISLIN_TYPE ptr, byval n as integer)
declare sub qplclr (byval zmat as DISLIN_TYPE ptr, byval n as integer, byval m as integer)
declare sub qplsur (byval zmat as DISLIN_TYPE ptr, byval n as integer, byval m as integer)
declare sub qplcon (byval zmat as DISLIN_TYPE ptr, byval n as integer, byval m as integer, byval nlv as integer)
declare function rbfpng (byval cbuf as zstring ptr, byval nmax as integer) as integer
declare sub rbmp (byval cfil as zstring ptr)
declare function readfl (byval nu as integer, byval cbuf as ubyte ptr, byval nbyte as integer) as integer
declare sub reawgt ()
declare sub recfll (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer, byval ncol as integer)
declare sub rectan (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer)
declare sub rel3pt (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE, byval xp as DISLIN_TYPE ptr, byval yp as DISLIN_TYPE ptr)
declare sub resatt ()
declare sub revscr ()
declare sub rgbhsv (byval xr as DISLIN_TYPE, byval xg as DISLIN_TYPE, byval xb as DISLIN_TYPE, byval xh as DISLIN_TYPE ptr, byval xs as DISLIN_TYPE ptr, byval xv as DISLIN_TYPE ptr)
declare sub rgif (byval cfil as zstring ptr)
declare sub rgtlab ()
declare sub rimage (byval cfil as zstring ptr)
declare sub rlarc (byval xm as DISLIN_TYPE, byval ym as DISLIN_TYPE, byval xa as DISLIN_TYPE, byval xb as DISLIN_TYPE, byval a as DISLIN_TYPE, byval b as DISLIN_TYPE, byval t as DISLIN_TYPE)
declare sub rlarea (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer)
declare sub rlcirc (byval xm as DISLIN_TYPE, byval ym as DISLIN_TYPE, byval r as DISLIN_TYPE)
declare sub rlconn (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE)
declare sub rlell (byval xm as DISLIN_TYPE, byval ym as DISLIN_TYPE, byval a as DISLIN_TYPE, byval b as DISLIN_TYPE)
declare sub rline (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval u as DISLIN_TYPE, byval v as DISLIN_TYPE)
declare sub rlmess (byval cstr as zstring ptr, byval x as DISLIN_TYPE, byval y as DISLIN_TYPE)
declare sub rlnumb (byval x as DISLIN_TYPE, byval ndig as integer, byval xp as DISLIN_TYPE, byval yp as DISLIN_TYPE)
declare sub rlpie (byval xm as DISLIN_TYPE, byval ym as DISLIN_TYPE, byval r as DISLIN_TYPE, byval a as DISLIN_TYPE, byval b as DISLIN_TYPE)
declare sub rlpoin (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval nb as integer, byval nh as integer, byval ncol as integer)
declare sub rlrec (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval xw as DISLIN_TYPE, byval xh as DISLIN_TYPE)
declare sub rlrnd (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval xb as DISLIN_TYPE, byval xh as DISLIN_TYPE, byval irnd as integer)
declare sub rlsec (byval xm as DISLIN_TYPE, byval ym as DISLIN_TYPE, byval r1 as DISLIN_TYPE, byval r2 as DISLIN_TYPE, byval a as DISLIN_TYPE, byval b as DISLIN_TYPE, byval ncol as integer)
declare sub rlstrt (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE)
declare sub rlsymb (byval nsym as integer, byval x as DISLIN_TYPE, byval y as DISLIN_TYPE)
declare sub rlvec (byval x1 as DISLIN_TYPE, byval y1 as DISLIN_TYPE, byval x2 as DISLIN_TYPE, byval y2 as DISLIN_TYPE, byval ivec as integer)
declare sub rlwind (byval xk as DISLIN_TYPE, byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval nwidth as integer, byval a as DISLIN_TYPE)
declare sub rndrec (byval nx as integer, byval ny as integer, byval nb as integer, byval nh as integer, byval irnd as integer)
declare sub rpixel (byval ix as integer, byval iy as integer, byval iclr as integer ptr)
declare sub rpixls (byval iray as ubyte ptr, byval ix as integer, byval iy as integer, byval nw as integer, byval nh as integer)
declare sub rpng (byval cfil as zstring ptr)
declare sub rppm (byval cfil as zstring ptr)
declare sub rpxrow (byval iray as ubyte ptr, byval ix as integer, byval iy as integer, byval n as integer)
declare sub rtiff (byval cfil as zstring ptr)
declare sub rvynam ()
declare sub scale (byval cscl as zstring ptr, byval cax as zstring ptr)
declare sub sclfac (byval xfac as DISLIN_TYPE)
declare sub sclmod (byval cmode as zstring ptr)
declare sub scrmod (byval cmode as zstring ptr)
declare sub sector (byval nx as integer, byval ny as integer, byval nr1 as integer, byval nr2 as integer, byval a as DISLIN_TYPE, byval b as DISLIN_TYPE, byval ncol as integer)
declare sub selwin (byval id as integer)
declare sub sendbf ()
declare sub sendmb ()
declare sub sendok ()
declare sub serif ()
declare sub setbas (byval xfac as DISLIN_TYPE)
declare sub setcbk (byval callbck as sub cdecl(byval as DISLIN_TYPE ptr, byval as DISLIN_TYPE ptr), byval copt as zstring ptr)
declare sub setclr (byval ncol as integer)
declare sub setcsr (byval copt as zstring ptr)
declare sub setexp (byval fexp as DISLIN_TYPE)
declare sub setfil (byval cfil as zstring ptr)
declare sub setgrf (byval c1 as zstring ptr, byval c2 as zstring ptr, byval c3 as zstring ptr, byval c4 as zstring ptr)
declare sub setind (byval index as integer, byval xr as DISLIN_TYPE, byval xg as DISLIN_TYPE, byval xb as DISLIN_TYPE)
declare sub setmix (byval cstr as zstring ptr, byval cmix as zstring ptr)
declare sub setpag (byval cpag as zstring ptr)
declare sub setres (byval npb as integer, byval nph as integer)
declare sub setrgb (byval xr as DISLIN_TYPE, byval xg as DISLIN_TYPE, byval xb as DISLIN_TYPE)
declare sub setscl (byval xray as DISLIN_TYPE ptr, byval n as integer, byval cax as zstring ptr)
declare sub setvlt (byval cvlt as zstring ptr)
declare sub setxid (byval id as integer, byval copt as zstring ptr)
declare sub shdafr (byval inray as integer ptr, byval ipray as integer ptr, byval icray as integer ptr, byval n as integer)
declare sub shdcha ()
declare sub shdcrv (byval x1ray as DISLIN_TYPE ptr, byval y1ray as DISLIN_TYPE ptr, byval n1 as integer, byval x2ray as DISLIN_TYPE ptr, byval y2ray as DISLIN_TYPE ptr, byval n2 as integer)
declare sub shdeur (byval inray as integer ptr, byval ipray as integer ptr, byval icray as integer ptr, byval n as integer)
declare sub shdmap (byval cmap as zstring ptr)
declare sub shdmod (byval copt as zstring ptr, byval ctyp as zstring ptr)
declare sub shdpat (byval ipat as integer)
declare sub shdusa (byval inray as integer ptr, byval ipray as integer ptr, byval icray as integer ptr, byval n as integer)
declare sub shield (byval carea as zstring ptr, byval cmode as zstring ptr)
declare sub shlcir (byval nx as integer, byval ny as integer, byval nr as integer)
declare sub shldel (byval id as integer)
declare sub shlell (byval nx as integer, byval ny as integer, byval na as integer, byval nb as integer, byval t as DISLIN_TYPE)
declare function shlind () as integer
declare sub shlpie (byval nx as integer, byval ny as integer, byval nr as integer, byval a as DISLIN_TYPE, byval b as DISLIN_TYPE)
declare sub shlpol (byval nxray as integer ptr, byval nyray as integer ptr, byval n as integer)
declare sub shlrct (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer, byval t as DISLIN_TYPE)
declare sub shlrec (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer)
declare sub shlres (byval n as integer)
declare sub shlsur ()
declare sub shlvis (byval id as integer, byval cmode as zstring ptr)
declare sub simplx ()
declare function skipfl (byval nu as integer, byval nbyte as integer) as integer
declare sub smxalf (byval calph as zstring ptr, byval c1 as zstring ptr, byval c2 as zstring ptr, byval n as integer)
declare sub solid ()
declare sub sortr1 (byval xray as DISLIN_TYPE ptr, byval n as integer, byval copt as zstring ptr)
declare sub sortr2 (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer, byval copt as zstring ptr)
declare sub sphe3d (byval xm as DISLIN_TYPE, byval ym as DISLIN_TYPE, byval zm as DISLIN_TYPE, byval r as DISLIN_TYPE, byval n as integer, byval m as integer)
declare sub spline (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer, byval xsray as DISLIN_TYPE ptr, byval ysray as DISLIN_TYPE ptr, byval nspl as integer ptr)
declare sub splmod (byval ngrad as integer, byval npts as integer)
declare sub strt3d (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE)
declare sub strtpt (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE)
declare sub surclr (byval ictop as integer, byval icbot as integer)
declare sub surfce (byval xray as DISLIN_TYPE ptr, byval n as integer, byval yray as DISLIN_TYPE ptr, byval m as integer, byval zmat as DISLIN_TYPE ptr)
declare sub surfcp (byval zfun as function cdecl(byval as DISLIN_TYPE, byval as DISLIN_TYPE, byval as integer) as DISLIN_TYPE, byval a1 as DISLIN_TYPE, byval a2 as DISLIN_TYPE, byval astp as DISLIN_TYPE, byval b1 as DISLIN_TYPE, byval b2 as DISLIN_TYPE, byval bstp as DISLIN_TYPE)
declare sub surfun (byval zfun as function cdecl(byval as DISLIN_TYPE, byval as DISLIN_TYPE) as DISLIN_TYPE, byval ixpts as integer, byval xdel as DISLIN_TYPE, byval iypts as integer, byval ydel as DISLIN_TYPE)
declare sub suriso (byval xray as DISLIN_TYPE ptr, byval nx as integer, byval yray as DISLIN_TYPE ptr, byval ny as integer, byval zray as DISLIN_TYPE ptr, byval nz as integer, byval wmat as DISLIN_TYPE ptr, byval wlev as DISLIN_TYPE)
declare sub surmat (byval zmat as DISLIN_TYPE ptr, byval nx as integer, byval ny as integer, byval ixpts as integer, byval iypts as integer)
declare sub surmsh (byval copt as zstring ptr)
declare sub suropt (byval copt as zstring ptr)
declare sub surshd (byval xray as DISLIN_TYPE ptr, byval n as integer, byval yray as DISLIN_TYPE ptr, byval m as integer, byval zmat as DISLIN_TYPE ptr)
declare sub sursze (byval xmin as DISLIN_TYPE, byval xmax as DISLIN_TYPE, byval ymin as DISLIN_TYPE, byval ymax as DISLIN_TYPE)
declare sub surtri (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval zray as DISLIN_TYPE ptr, byval n as integer, byval i1ray as integer ptr, byval i2ray as integer ptr, byval i3ray as integer ptr, byval ntri as integer)
declare sub survis (byval cvis as zstring ptr)
declare sub swapi2 (byval iray as short ptr, byval n as integer)
declare sub swapi4 (byval iray as integer ptr, byval n as integer)
declare sub swgatt (byval id as integer, byval cval as zstring ptr, byval copt as zstring ptr)
declare sub swgbox (byval ip as integer, byval ival as integer)
declare sub swgbut (byval ip as integer, byval ival as integer)
declare sub swgcb (byval id as integer, byval callbck as sub cdecl(byval as integer, byval as integer ptr), byval iray as integer ptr)
declare sub swgcbk (byval id as integer, byval callbck as sub cdecl(byval as integer))
declare sub swgclr (byval xr as DISLIN_TYPE, byval xg as DISLIN_TYPE, byval xb as DISLIN_TYPE, byval copt as zstring ptr)
declare sub swgdrw (byval x as DISLIN_TYPE)
declare sub swgfil (byval ip as integer, byval cval as zstring ptr)
declare sub swgfnt (byval cfnt as zstring ptr, byval n as integer)
declare sub swgfoc (byval id as integer)
declare sub swghlp (byval cstr as zstring ptr)
declare sub swgjus (byval ctyp as zstring ptr, byval cwidg as zstring ptr)
declare sub swglis (byval ip as integer, byval ival as integer)
declare sub swgmix (byval c as zstring ptr, byval cstr as zstring ptr)
declare sub swgmod (byval cmod as zstring ptr)
declare sub swgmrg (byval ival as integer, byval cstr as zstring ptr)
declare sub swgoff (byval nx as integer, byval ny as integer)
declare sub swgopt (byval cval as zstring ptr, byval copt as zstring ptr)
declare sub swgpop (byval copt as zstring ptr)
declare sub swgpos (byval nx as integer, byval ny as integer)
declare sub swgscl (byval ip as integer, byval xval as DISLIN_TYPE)
declare sub swgsiz (byval nx as integer, byval ny as integer)
declare sub swgspc (byval xw as DISLIN_TYPE, byval xh as DISLIN_TYPE)
declare sub swgstp (byval step as DISLIN_TYPE)
declare sub swgtit (byval ctit as zstring ptr)
declare sub swgtxt (byval ip as integer, byval cval as zstring ptr)
declare sub swgtyp (byval ctyp as zstring ptr, byval cwidg as zstring ptr)
declare sub swgwin (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer)
declare sub swgwth (byval nchar as integer)
declare sub symbol (byval nsym as integer, byval nx as integer, byval ny as integer)
declare sub symfil (byval cdev as zstring ptr, byval cstat as zstring ptr)
declare sub symrot (byval angle as DISLIN_TYPE)
declare function tellfl (byval nu as integer) as integer
declare sub texmod (byval copt as zstring ptr)
declare sub texopt (byval copt as zstring ptr, byval ctyp as zstring ptr)
declare sub thkcrv (byval nthk as integer)
declare sub ticks (byval itick as integer, byval cax as zstring ptr)
declare sub ticlen (byval nmaj as integer, byval nmin as integer)
declare sub ticmod (byval copt as zstring ptr, byval cax as zstring ptr)
declare sub ticpos (byval cpos as zstring ptr, byval cax as zstring ptr)
declare sub tifmod (byval n as integer, byval cval as zstring ptr, byval copt as zstring ptr)
declare sub tiforg (byval nx as integer, byval ny as integer)
declare sub tifwin (byval nx as integer, byval ny as integer, byval nw as integer, byval nh as integer)
declare sub timopt ()
declare sub titjus (byval copt as zstring ptr)
declare sub title ()
declare sub titlin (byval cstr as zstring ptr, byval n as integer)
declare sub titpos (byval copt as zstring ptr)
declare sub trfco1 (byval xray as DISLIN_TYPE ptr, byval n as integer, byval cfrom as zstring ptr, byval cto as zstring ptr)
declare sub trfco2 (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer, byval cfrom as zstring ptr, byval cto as zstring ptr)
declare sub trfco3 (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval zray as DISLIN_TYPE ptr, byval n as integer, byval cfrom as zstring ptr, byval cto as zstring ptr)
declare sub trfdat (byval ndays as integer, byval id as integer ptr, byval im as integer ptr, byval iy as integer ptr)
declare sub trfmat (byval zmat as DISLIN_TYPE ptr, byval nx as integer, byval ny as integer, byval zmat2 as DISLIN_TYPE ptr, byval nx2 as integer, byval ny2 as integer)
declare sub trfrel (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer)
declare sub trfres ()
declare sub trfrot (byval xang as DISLIN_TYPE, byval nx as integer, byval ny as integer)
declare sub trfscl (byval xscl as DISLIN_TYPE, byval yscl as DISLIN_TYPE)
declare sub trfshf (byval nx as integer, byval ny as integer)
declare function triang (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval n as integer, byval i1ray as integer ptr, byval i2ray as integer ptr, byval i3ray as integer ptr, byval nmax as integer) as integer
declare sub trifll (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr)
declare sub triplx ()
declare sub tripts (byval xray as DISLIN_TYPE ptr, byval yray as DISLIN_TYPE ptr, byval zray as DISLIN_TYPE ptr, byval n as integer, byval i1ray as integer ptr, byval i2ray as integer ptr, byval i3ray as integer ptr, byval ntri as integer, byval zlev as DISLIN_TYPE, byval xpts as DISLIN_TYPE ptr, byval ypts as DISLIN_TYPE ptr, byval maxpts as integer, byval nptray as integer ptr, byval maxray as integer, byval nlins as integer ptr)
declare function trmlen (byval cstr as zstring ptr) as integer
declare sub txtjus (byval copt as zstring ptr)
declare sub unit (byval fp as any ptr)
declare sub units (byval copt as zstring ptr)
declare sub upstr (byval cstr as zstring ptr)
declare sub vang3d (byval a as DISLIN_TYPE)
declare sub vclp3d (byval x1 as DISLIN_TYPE, byval x2 as DISLIN_TYPE)
declare sub vector (byval nx1 as integer, byval ny1 as integer, byval nx2 as integer, byval ny2 as integer, byval ivec as integer)
declare sub vectr3 (byval x1 as DISLIN_TYPE, byval y1 as DISLIN_TYPE, byval z1 as DISLIN_TYPE, byval x2 as DISLIN_TYPE, byval y2 as DISLIN_TYPE, byval z2 as DISLIN_TYPE, byval ivec as integer)
declare sub vfoc3d (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE, byval cview as zstring ptr)
declare sub view3d (byval xvu as DISLIN_TYPE, byval yvu as DISLIN_TYPE, byval zvu as DISLIN_TYPE, byval cvu as zstring ptr)
declare sub vkxbar (byval nvfx as integer)
declare sub vkybar (byval nvfy as integer)
declare sub vkytit (byval nvfy as integer)
declare sub vltfil (byval cfl as zstring ptr, byval copt as zstring ptr)
declare sub vup3d (byval a as DISLIN_TYPE)
declare function wgapp (byval ip as integer, byval clab as zstring ptr) as integer
declare function wgbas (byval ip as integer, byval ctyp as zstring ptr) as integer
declare function wgbox (byval ip as integer, byval cstr as zstring ptr, byval isel as integer) as integer
declare function wgbut (byval ip as integer, byval cstr as zstring ptr, byval ival as integer) as integer
declare function wgcmd (byval ip as integer, byval clab as zstring ptr, byval cmd as zstring ptr) as integer
declare function wgdlis (byval ip as integer, byval cstr as zstring ptr, byval isel as integer) as integer
declare function wgdraw (byval ip as integer) as integer
declare function wgfil (byval ip as integer, byval clab as zstring ptr, byval cstr as zstring ptr, byval cmask as zstring ptr) as integer
declare sub wgfin ()
declare function wgini (byval ctyp as zstring ptr) as integer
declare function wglab (byval ip as integer, byval cstr as zstring ptr) as integer
declare function wglis (byval ip as integer, byval cstr as zstring ptr, byval isel as integer) as integer
declare function wgltxt (byval ip as integer, byval clab as zstring ptr, byval ctext as zstring ptr, byval iper as integer) as integer
declare function wgok (byval ip as integer) as integer
declare function wgpbut (byval ip as integer, byval clab as zstring ptr) as integer
declare function wgpop (byval ip as integer, byval clab as zstring ptr) as integer
declare function wgquit (byval ip as integer) as integer
declare function wgscl (byval ip as integer, byval cstr as zstring ptr, byval x1 as DISLIN_TYPE, byval x2 as DISLIN_TYPE, byval xval as DISLIN_TYPE, byval ndez as integer) as integer
declare function wgstxt (byval ip as integer, byval nsize as integer, byval nmax as integer) as integer
declare function wgtxt (byval ip as integer, byval cstr as zstring ptr) as integer
declare sub widbar (byval nzb as integer)
declare sub wimage (byval cfil as zstring ptr)
declare sub winapp (byval copt as zstring ptr)
declare sub windbr (byval xk as DISLIN_TYPE, byval nx as integer, byval ny as integer, byval nwidth as integer, byval a as DISLIN_TYPE)
declare sub winfin (byval iopt as integer)
declare sub winfnt (byval cfont as zstring ptr)
declare function winid () as integer
declare sub winini (byval p1 as any ptr, byval p2 as any ptr, byval i1 as integer, byval i2 as integer)
declare sub winkey (byval copt as zstring ptr)
declare sub winmod (byval copt as zstring ptr)
declare sub winopt (byval iopt as integer, byval copt as zstring ptr)
declare sub winsiz (byval nw as integer, byval nh as integer)
declare sub wintit (byval cstr as zstring ptr)
declare sub wmfmod (byval cmod as zstring ptr, byval ckey as zstring ptr)
declare sub world ()
declare sub wpixel (byval ix as integer, byval iy as integer, byval iclr as integer)
declare sub wpixls (byval iray as ubyte ptr, byval ix as integer, byval iy as integer, byval nw as integer, byval nh as integer)
declare sub wpxrow (byval iray as ubyte ptr, byval ix as integer, byval iy as integer, byval n as integer)
declare function writfl (byval nu as integer, byval cbuf as ubyte ptr, byval nbyte as integer) as integer
declare sub wtiff (byval cfil as zstring ptr)
declare sub x11fnt (byval cfont as zstring ptr, byval copt as zstring ptr)
declare sub x11mod (byval copt as zstring ptr)
declare function x2dpos (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE) as DISLIN_TYPE
declare function x3dabs (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE) as DISLIN_TYPE
declare function x3dpos (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE) as DISLIN_TYPE
declare function x3drel (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE) as DISLIN_TYPE
declare sub xaxgit ()
declare sub xaxis (byval xa as DISLIN_TYPE, byval xe as DISLIN_TYPE, byval xorg as DISLIN_TYPE, byval xstp as DISLIN_TYPE, byval nl as integer, byval cstr as zstring ptr, byval it as integer, byval nx as integer, byval ny as integer)
declare sub xaxlg (byval xa as DISLIN_TYPE, byval xe as DISLIN_TYPE, byval xorg as DISLIN_TYPE, byval xstp as DISLIN_TYPE, byval nl as integer, byval cstr as zstring ptr, byval it as integer, byval nx as integer, byval ny as integer)
declare sub xaxmap (byval xa as DISLIN_TYPE, byval xe as DISLIN_TYPE, byval xorg as DISLIN_TYPE, byval xstp as DISLIN_TYPE, byval cstr as zstring ptr, byval it as integer, byval ny as integer)
declare sub xcross ()
declare sub xdraw (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE)
declare function xinvrs (byval n as integer) as DISLIN_TYPE
declare sub xmove (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE)
declare function xposn (byval x as DISLIN_TYPE) as DISLIN_TYPE
declare function y2dpos (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE) as DISLIN_TYPE
declare function y3dabs (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE) as DISLIN_TYPE
declare function y3dpos (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE) as DISLIN_TYPE
declare function y3drel (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE) as DISLIN_TYPE
declare sub yaxgit ()
declare sub yaxis (byval ya as DISLIN_TYPE, byval ye as DISLIN_TYPE, byval yor as DISLIN_TYPE, byval ystp as DISLIN_TYPE, byval nl as integer, byval cstr as zstring ptr, byval it as integer, byval nx as integer, byval ny as integer)
declare sub yaxlg (byval ya as DISLIN_TYPE, byval ye as DISLIN_TYPE, byval yor as DISLIN_TYPE, byval ystp as DISLIN_TYPE, byval nl as integer, byval cstr as zstring ptr, byval it as integer, byval nx as integer, byval ny as integer)
declare sub yaxmap (byval ya as DISLIN_TYPE, byval ye as DISLIN_TYPE, byval yor as DISLIN_TYPE, byval ystp as DISLIN_TYPE, byval cstr as zstring ptr, byval it as integer, byval ny as integer)
declare sub ycross ()
declare function yinvrs (byval n as integer) as DISLIN_TYPE
declare function yposn (byval y as DISLIN_TYPE) as DISLIN_TYPE
declare function z3dpos (byval x as DISLIN_TYPE, byval y as DISLIN_TYPE, byval z as DISLIN_TYPE) as DISLIN_TYPE
declare sub zaxis (byval za as DISLIN_TYPE, byval ze as DISLIN_TYPE, byval zor as DISLIN_TYPE, byval zstp as DISLIN_TYPE, byval nl as integer, byval cstr as zstring ptr, byval it as integer, byval id as integer, byval nx as integer, byval ny as integer)
declare sub zaxlg (byval za as DISLIN_TYPE, byval ze as DISLIN_TYPE, byval zor as DISLIN_TYPE, byval zstp as DISLIN_TYPE, byval nl as integer, byval cstr as zstring ptr, byval it as integer, byval id as integer, byval nx as integer, byval ny as integer)
declare sub zbffin ()
declare function zbfini () as integer
declare sub zbflin (byval x1 as DISLIN_TYPE, byval y1 as DISLIN_TYPE, byval z1 as DISLIN_TYPE, byval x2 as DISLIN_TYPE, byval y2 as DISLIN_TYPE, byval z2 as DISLIN_TYPE)
declare sub zbftri (byval x as DISLIN_TYPE ptr, byval y as DISLIN_TYPE ptr, byval z as DISLIN_TYPE ptr, byval ic as integer ptr)
declare sub zscale (byval za as DISLIN_TYPE, byval ze as DISLIN_TYPE)
end extern

#endif
