; --------------------------------------------------------------------------
; CPU testing added v0.3.5 - Note this only tests for presence of 386, since
; we do not use 486 or latter instructions.
  if __cpu ge 3
TestCPU         proc    near            ; returns (0) for Ok,
                call    not386          ;   (!0) when wrong CPU type
                or      ax, ax
                jz      SHORT WereOk
                DosPrnt CPUError
  WereOk:       ret
TestCPU         endp

CPUError        LABEL   BYTE
         DB     '80386 or later processor is required!', CR, LF, EndString

not386 proc    near
;;
;; This first test detects 80x86 for x < 2.  On the 8086 and '186,
;; "push sp" does "--sp; sp[0] = sp".  On all later processors, it does
;; "sp[-1] = sp; --sp".
;;
	push	sp
	pop	ax
	sub	ax,sp
	jne	SHORT return
 
;; This test is the key one.  It will probably detect 8086, V30 and 80186
;; as well as 80286, but I haven't had access to test it on any of those,
;; so it's protected by the well-known test above.  It has been tested
;; on the 80286, 80386, 80486, Pentium and AMD tested it on their K5.
;; I have not been able to confirm effectiveness on the P6 yet, although
;; someone I spoke to at Intel said it should work.
;;
;; This test uses the fact that the '386 and above have a barrel shifter
;; to do shifts, while the '286 does left shifts by releated adds.
;; That means that on the '286, the auxilliary carry gets a copy of
;; bit 4 of the shift output, while on the '386 and up, it's trashed
;; (as it happens, set to 1) independent of the result.  (It's documented
;; as undefined.)
;;
;; We do two shifts, which should produce different auxilliary carries
;; on a '286 and XOR them to see if they are different.  Even on a
;; future processor that does something different with the aux carry
;; flag, it probably does something data-independent, so this will still
;; work.  Note that all flags except aux carry are defined for shl
;; output and will be the same for both cases.
 
	mov	al,4
	shl	al,1    ; Expected to produce ac = 0 on a '286
	lahf
	shl	al,1    ; Expected to produce ac = 1 on a '286
	mov	al,ah
	lahf
	xor	al,ah   ; Xor the flags together to detect the difference
	mov	ah,al   ; Clear ah if al is clear, leave Z flag alone
return:
	ret
not386 endp
  endif
