### Name: grid list
### Title: Grid list for describing equally spaced grids
### Aliases: grid list
### Keywords: misc

### ** Examples

#Given below are some examples of grid.list objects and the results  
#when they are used with make.surface.grid. Note that  
#make.surface.grid returns a matrix that retains the grid.list  
#information as an attribute. 

grid.l<- list( 1:3, 2:5) 
make.surface.grid(grid.l)
  
grid.l <- list( 1:3, 10, 1:3) 
make.surface.grid(grid.l) 

#The next set of examples show how the grid.list can be used to  
#control surface plotting and evaluation of an estimated function. 

# first create a test function  
X<- 2*cbind( runif(50), runif(50), runif(50))  
dimnames( X)<- list(NULL, c("X1","X2","X3")) 
y<- X[,1]**2 + X[,2]**2 + exp(X[,3])   

# fit an  interpolating thin plate spline  
out<- Tps( X,y,lambda=1e-8) 
grid.l<- list( X1="x", X2="y") 
surface( out, grid.l, type="I") # surface plot of estimated surface with  
#                       X3= mean value 

grid.l<- list( X1= seq( 0,2,,25), X2=1.0, X3=seq(0,2,,25)) 
surface( out,grid.l, type="I") 
#  surface plot based on a 25X25 grid in X1 an X3  
#                       over the square [0,2] and [0,2]   
#                       holding X2 equal to 1.0. 
#



