### Name: plot.mclustDA
### Title: Plotting method for MclustDA discriminant analysis.
### Aliases: plot.mclustDA
### Keywords: cluster

### ** Examples

n <- 250 ## create artificial data
set.seed(0)
x <- rbind(matrix(rnorm(n*2), n, 2) %*% diag(c(1,9)),
           matrix(rnorm(n*2), n, 2) %*% diag(c(1,9))[,2:1])
xclass <- c(rep(1,n),rep(2,n))
## Not run: 
##D mclust2Dplot(x, classification = xclass, type="classification", ask=FALSE)
## End(Not run)
odd <- seq(from = 1, to = 2*n, by = 2)
even <- odd + 1
testMclustDA <- mclustDA(trainingData = x[odd, ], labels = xclass[odd], 
                         testData = x[even,])

clEven <- testMclustDA$testClassification ## classify training set
compareClass(clEven,xclass[even])

## Not run: 
##D plot(testMclustDA, trainingData = x[odd, ], labels = xclass[odd], 
##D testData = x[even,])
## End(Not run)



