### Name: EMclustN
### Title: BIC for Model-Based Clustering with Poisson Noise
### Aliases: EMclustN print.EMclustN plot.EMclustN
### Keywords: cluster

### ** Examples

data(iris)
irisMatrix <- as.matrix(iris[,1:4])
irisClass <- iris[,5]

b <- apply( irisMatrix, 2, range)
n <- 450
set.seed(0)
poissonNoise <- apply(b, 2, function(x, n=n) 
                      runif(n, min = x[1]-0.1, max = x[2]+.1), n = n)
set.seed(0)
noiseInit <- sample(c(TRUE,FALSE),size=150+450,replace=TRUE,prob=c(3,1))
Bic <-  EMclustN(data=rbind(irisMatrix, poissonNoise), noise = noiseInit)
Bic
plot(Bic)



