/* lprm.c $Id: lprm.c,v 1.3 2000/08/31 22:05:14 angus Exp $
 *
 * Copyright (C) Angus J. C. Duggan, 1996-2000
 *
 * LPRM client for NT; uses registry and PRINTER environment variable for
 * printer. PRINTHOST registry key and environment variable used for LPD host.
 * LPQ and LPR also provided.
 */

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "common.h"

char *program ;

static void usage(void)
{
  error("Copyright (C) Angus J. C. Duggan, 1996-2000. See file LICENSE for details.\nUsage:\n  %s [-Pprinter] [-Hhost] [user|job...]\n", program) ;
}

int RemoveJob(char *printer, char *hostname, SOCKET printsock, va_list args)
{
  char *user = va_arg(args, char *) ;
  char *list = va_arg(args, char *) ;

  assert(user) ;

  if ( !Command("%c%s %s %s\n", LPD_REMOVE, printer, user, (list ? list : "")) )
    return 1 ;

  if ( !Reply(hostname, printsock, stdout) )
    return 1 ;

  return 0 ;	/* Success! */
}

int main(int argc, char *argv[])
{
  char *printer = getenv(PRINTER) ;
  char *host = DefaultHost(printer) ;
  char *user = getenv("USERNAME") ;
  char *list = NULL ;

  if ( user == NULL )
    user = getenv("USER") ;

  if ( user == NULL )
    user = DEFAULTUSER ;

  for (program = *argv++ ; --argc ; argv++) {
    if (argv[0][0] == '-') {
      switch (argv[0][1]) {
      case 'U':	/* user */
	user = &(argv[0][2]) ;
	break;
      case 'P':	/* printer */
	printer = &(argv[0][2]) ;
        host = DefaultHost(printer) ;
	break;
      default:
	usage();
      }
    } else {
      int len = list ? strlen(list) + 1 : 0 ;

      list = xalloc(list, len + strlen(*argv) + 1) ;
      if ( len != 0 )	/* concat string with space separators */
	list[len - 1] = ' ' ;
      strcpy(list + len, *argv) ;
    }
  }

  return LPD(printer, host, &RemoveJob, user, list) ;
}

/*
 * $Log: lprm.c,v $
 * Revision 1.3  2000/08/31 22:05:14  angus
 * Keep socket open for lpr until reply read; make reply reading routine common
 *
 * Revision 1.2  1999/10/24 05:45:30  angus
 *
 * Add support for -Z options
 * Allow printer@host syntax for all programs
 * Use SO_DONTLINGER to enable socket re-use
 *
 * Revision 1.1.1.1  1999/07/02 06:21:11  angus
 * Initial CVS import
 *
 */
