/* common.h $Id: common.h,v 1.2 2000/08/31 22:05:14 angus Exp $
 *
 * Copyright (C) Angus J. C. Duggan, 1996
 *
 * Common definitions for lpr/lpq/lprm for Windows NT
 *
 */

#define PRINTER "PRINTER"
#define PRINTHOST "PRINTHOST"
#define REMOTEPORTNO ((short)515)
#define LOCALPORTMIN ((short)721)
#define LOCALPORTMAX ((short)731)

#define DEFAULTUSER "nobody"

typedef enum { LPD_START = 1, LPD_PRINT = 2, LPD_SHORTQ = 3,
	       LPD_LONGQ = 4, LPD_REMOVE = 5 } LPDCommand ;

typedef enum { LPR_ABORT = 1, LPR_CONTROL = 2, LPR_DATA = 3 } LPRCommand ;

typedef enum { FMT_DVI = 'd', FMT_TEXT = 'f', FMT_CTRL = 'l',
	       FMT_DITROFF = 'n', FMT_PS = 'o', FMT_PAGE = 'p',
	       FMT_TROFF = 't' } LPRFormat ;

char *program ;

void *xalloc(void *ptr, size_t size) ;

void error(char *format, ...) ;
void warning(char *format, ...) ;

int LPD(char *printer, char *hostname, int (*fn)(char *printer, char *hostname,
						 SOCKET printsock,
						 va_list args), ...) ;
int Acknowledge(int ping) ;
int Command(char *format, ...) ;
int Reply(char *hostname, SOCKET printsock, FILE *ofile) ;

int NextJobNumber(void) ;
char *DefaultHost(char *printer) ;

/*
 * $Log: common.h,v $
 * Revision 1.2  2000/08/31 22:05:14  angus
 * Keep socket open for lpr until reply read; make reply reading routine common
 *
 * Revision 1.1.1.1  1999/07/02 06:21:11  angus
 * Initial CVS import
 *
 */
