/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.ice.sqlclient.MySQLAdapter;
import com.ice.sqlclient.SQLClientHandler;
import com.ice.util.AWTUtilities;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;

public class DatabasePanel
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener {
    private JButton refreshButton;
    private JComboBox dbList;
    private JTextArea msgText;
    private MySQLAdapter sqlAdapter;
    private boolean isListFresh = false;

    public DatabasePanel() {
        this.setDoubleBuffered(true);
        this.establishContents();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        if (jTabbedPane.getSelectedComponent() == this && !this.isListFresh) {
            this.refreshDatabaseList();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)this.dbList.getSelectedItem();
            this.setCurrentDatabase(string);
        }
    }

    public void setCurrentDatabase(String string) {
        SQLClientHandler sQLClientHandler = SQLClientHandler.getCurrentHandler();
        if (sQLClientHandler == null) {
            this.showMessage("INTERNAL ERROR: current handler is null.");
            return;
        }
        if (!sQLClientHandler.isOpen()) {
            this.showMessage("INTERNAL ERROR: connection is not open.");
            return;
        }
        try {
            sQLClientHandler.performSQLUpdate("use " + string);
            this.showMessage("Database changed to '" + string + "'");
            return;
        }
        catch (SQLException sQLException) {
            this.showMessage("SQLException: retrieving table information:\n" + sQLException.getMessage());
            return;
        }
    }

    public void refreshDatabaseList() {
        SQLClientHandler sQLClientHandler = SQLClientHandler.getCurrentHandler();
        if (sQLClientHandler == null) {
            this.showMessage("INTERNAL ERROR: current handler is null.");
            return;
        }
        if (!sQLClientHandler.isOpen()) {
            this.showMessage("INTERNAL ERROR: connection is not open.");
            return;
        }
        try {
            String[] stringArray = sQLClientHandler.getDatabaseList();
            this.dbList.removeAllItems();
            int n = 0;
            while (n < stringArray.length) {
                this.dbList.addItem((Object)stringArray[n]);
                ++n;
            }
            this.isListFresh = true;
            return;
        }
        catch (SQLException sQLException) {
            this.showMessage("SQLException: retrieving table information:\n" + sQLException.getMessage());
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("REFRESH")) {
            this.refreshDatabaseList();
            return;
        }
        this.showMessage("INTERNAL ERROR: unknown command: " + string);
    }

    private void showMessage(String string) {
        this.msgText.setText(string);
    }

    private void establishContents() {
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        this.dbList = new JComboBox();
        this.dbList.setEditable(false);
        this.dbList.addItemListener((ItemListener)this);
        AWTUtilities.constrain((Container)((Object)this), (Component)this.dbList, 0, 10, 0, 0, 1, 1, 0.0, 1.0);
        this.msgText = new JTextArea();
        AWTUtilities.constrain((Container)((Object)this), (Component)this.msgText, 2, 15, 0, 1, 1, 1, 1.0, 0.0);
    }
}

