/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.util.FileNameMapper;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.UncheckedDITAOTException;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.util.ChainedURIResolver;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.LangUtils;
import org.dita.dost.util.XMLUtils;
import org.xmlresolver.Resolver;

public final class XsltModule
extends AbstractPipelineModuleImpl {
    private XsltExecutable templates;
    private final Map<String, String> params = new HashMap<String, String>();
    private final Properties properties = new Properties();
    private Source style;
    private File in;
    private File out;
    private File destDir;
    private File baseDir;
    private Collection<File> includes;
    private String filenameparameter;
    private String filedirparameter;
    private boolean reloadstylesheet;
    private URIResolver catalog;
    private URIResolver uriResolver;
    private FileNameMapper mapper;
    private String extension;
    private XsltTransformer t;
    private Processor processor;
    private boolean parallel;

    private void init() {
        if (this.catalog == null) {
            Resolver catalogResolver = this.xmlUtils.getCatalogResolver();
            this.catalog = catalogResolver;
        }
        this.uriResolver = new ChainedURIResolver(this.job.getStore(), this.catalog);
        if (this.fileInfoFilter != null) {
            Collection<Job.FileInfo> res = this.job.getFileInfo(this.fileInfoFilter);
            this.includes = new ArrayList<File>(res.size());
            for (Job.FileInfo f : res) {
                this.includes.add(f.file);
            }
            this.baseDir = this.job.tempDir;
        }
    }

    @Override
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        this.init();
        if ((this.includes == null || this.includes.isEmpty()) && this.in == null) {
            return null;
        }
        if (this.destDir != null) {
            this.logger.debug("Transforming into " + this.destDir.getAbsolutePath());
        }
        this.processor = this.xmlUtils.getProcessor();
        XsltCompiler xsltCompiler = this.processor.newXsltCompiler();
        xsltCompiler.setURIResolver(this.uriResolver);
        xsltCompiler.setErrorReporter(XMLUtils.toErrorReporter(this.logger));
        this.logger.info("Loading stylesheet " + this.style.getSystemId());
        try {
            this.templates = xsltCompiler.compile(this.style);
        }
        catch (SaxonApiException e) {
            throw new RuntimeException("Failed to compile stylesheet '" + this.style.getSystemId() + "': " + e.getMessage(), e);
        }
        if (this.in != null) {
            this.transform(this.in, this.out);
        } else if (this.parallel) {
            try {
                List<Map.Entry> tmps = ((Stream)this.includes.stream().parallel()).map(include -> {
                    try {
                        File in = this.baseDir.toPath().resolve(include.toPath()).toFile();
                        File out = this.getOutput(include.getPath());
                        if (out == null) {
                            return null;
                        }
                        XsltTransformer transformer = this.getTransformer();
                        if (in.equals(out)) {
                            File tmp = new File(out.getAbsolutePath() + ".temp");
                            this.transform(in, tmp, transformer);
                            return LangUtils.pair(tmp, out);
                        }
                        this.transform(in, out, transformer);
                        return null;
                    }
                    catch (DITAOTException e) {
                        throw new UncheckedDITAOTException(e);
                    }
                }).filter(Objects::nonNull).toList();
                for (Map.Entry entry : tmps) {
                    try {
                        this.logger.info("Move " + String.valueOf(((File)entry.getKey()).toURI()) + " to " + String.valueOf(((File)entry.getValue()).toURI()));
                        this.job.getStore().move(((File)entry.getKey()).toURI(), ((File)entry.getValue()).toURI());
                    }
                    catch (IOException e) {
                        this.logger.error(String.format("Failed to move %s to %s: %s", ((File)entry.getKey()).toURI(), ((File)entry.getValue()).toURI(), e.getMessage()), e);
                    }
                }
            }
            catch (UncheckedDITAOTException e) {
                throw e.getDITAOTException();
            }
        } else {
            for (File include2 : this.includes) {
                File in = new File(this.baseDir, include2.getPath());
                File out = this.getOutput(include2.getPath());
                if (out == null) continue;
                this.transform(in, out);
            }
        }
        return null;
    }

    private File getOutput(String path) {
        File out = this.destDir.toPath().resolve(path).toFile();
        if (this.mapper != null) {
            String[] outs = this.mapper.mapFileName(path);
            if (outs == null) {
                return null;
            }
            if (outs.length > 1) {
                throw new RuntimeException("XSLT module only support one to one output mapping");
            }
            out = this.destDir.toPath().resolve(outs[0]).toFile();
        } else if (this.extension != null) {
            out = new File(FileUtils.replaceExtension(out.getAbsolutePath(), this.extension));
        }
        return out;
    }

    private XsltTransformer getTransformer() throws DITAOTException {
        try {
            XsltTransformer transformer = this.templates.load();
            transformer.setErrorReporter(XMLUtils.toErrorReporter(this.logger));
            transformer.setURIResolver(this.uriResolver);
            transformer.setMessageListener(XMLUtils.toMessageListener(this.logger, this.processingMode));
            return transformer;
        }
        catch (Exception e) {
            throw new DITAOTException("Failed to create Transformer: " + e.getMessage(), e);
        }
    }

    private void transform(File in, File out) throws DITAOTException {
        if (this.reloadstylesheet || this.t == null) {
            this.logger.info("Loading stylesheet " + this.style.getSystemId());
            this.t = this.getTransformer();
        }
        this.transform(in, out, this.t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(File in, File out, XsltTransformer t) throws DITAOTException {
        File tmp;
        boolean same = in.getAbsolutePath().equals(out.getAbsolutePath());
        for (Map.Entry<String, String> e : this.params.entrySet()) {
            this.logger.debug("Set parameter " + e.getKey() + " to '" + e.getValue() + "'");
            t.setParameter(new QName(e.getKey()), (XdmValue)new XdmAtomicValue(e.getValue()));
        }
        if (this.filenameparameter != null) {
            this.logger.debug("Set parameter " + this.filenameparameter + " to '" + in.getName() + "'");
            t.setParameter(new QName(this.filenameparameter), (XdmValue)new XdmAtomicValue(in.getName()));
        }
        if (this.filedirparameter != null) {
            Path rel = this.job.tempDir.toPath().relativize(in.getAbsoluteFile().toPath()).getParent();
            String v = rel != null ? rel.toString() : ".";
            this.logger.debug("Set parameter " + this.filedirparameter + " to '" + v + "'");
            t.setParameter(new QName(this.filedirparameter), (XdmValue)new XdmAtomicValue(v));
        }
        if (this.properties.isEmpty()) {
            try {
                if (same) {
                    this.logger.info("Processing " + String.valueOf(in.toURI()));
                    this.job.getStore().transform(in.toURI(), t);
                } else {
                    this.logger.info("Processing " + String.valueOf(in.toURI()) + " to " + String.valueOf(out.toURI()));
                    this.job.getStore().transform(in.toURI(), out.toURI(), t);
                }
            }
            catch (UncheckedXPathException e) {
                this.logger.error("Failed to transform document: " + e.getXPathException().getMessageAndLocation(), e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.error("Failed to transform document: " + e.getMessage(), e);
            }
            return;
        }
        File file = tmp = same ? new File(out.getAbsolutePath() + ".tmp" + Long.toString(System.currentTimeMillis())) : out;
        if (same) {
            this.logger.info("Processing " + String.valueOf(in.toURI()));
            this.logger.debug("Processing " + String.valueOf(in.toURI()) + " to " + String.valueOf(tmp.toURI()));
        } else {
            this.logger.info("Processing " + String.valueOf(in.toURI()) + " to " + String.valueOf(tmp.toURI()));
        }
        Destination destination = null;
        try {
            Source source = this.job.getStore().getSource(in.toURI());
            t.setSource(source);
            destination = this.job.getStore().getDestination(tmp.toURI());
            if (same) {
                destination.setDestinationBaseURI(out.toURI());
            }
            if (destination instanceof Serializer) {
                Serializer serializer = (Serializer)destination;
                for (String key : this.properties.stringPropertyNames()) {
                    serializer.setOutputProperty(new QName(key), this.properties.getProperty(key));
                }
            }
            t.setDestination(destination);
            t.transform();
            if (same) {
                this.logger.debug("Moving " + tmp.getAbsolutePath() + " to " + out.getAbsolutePath());
                this.job.getStore().move(tmp.toURI(), out.toURI());
            }
        }
        catch (UncheckedXPathException e) {
            this.logger.error("Failed to transform document: " + e.getXPathException().getMessageAndLocation(), e);
            this.logger.debug("Remove " + String.valueOf(tmp.toURI()));
            try {
                this.job.getStore().delete(tmp.toURI());
            }
            catch (IOException e1) {
                this.logger.error("Failed to clean up after failed transformation: " + String.valueOf(e1), e1);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SaxonApiException e) {
            try {
                throw e.getCause();
            }
            catch (XPathException cause) {
                this.logger.error("Failed to transform document: " + cause.getMessageAndLocation(), e);
            }
            catch (Throwable throwable) {
                this.logger.error("Failed to transform document: " + e.getMessage(), e);
            }
            this.logger.debug("Remove " + String.valueOf(tmp.toURI()));
            try {
                this.job.getStore().delete(tmp.toURI());
            }
            catch (IOException e1) {
                this.logger.error("Failed to clean up after failed transformation: " + String.valueOf(e1), e1);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to transform document: " + e.getMessage(), e);
            this.logger.debug("Remove " + String.valueOf(tmp.toURI()));
            try {
                this.job.getStore().delete(tmp.toURI());
            }
            catch (IOException e1) {
                this.logger.error("Failed to clean up after failed transformation: " + String.valueOf(e1), e1);
            }
        }
        finally {
            try {
                destination.close();
            }
            catch (SaxonApiException e) {
                throw new DITAOTException(e);
            }
        }
    }

    @Deprecated
    public void setStyle(File style) {
        this.style = new StreamSource(style);
    }

    public void setStyle(Source style) {
        this.style = style;
    }

    public void setParam(String key, String value) {
        this.params.put(key, value);
    }

    public void setOutputProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void setIncludes(Collection<File> includes) {
        this.includes = includes;
    }

    public void setDestinationDir(File destDir) {
        this.destDir = destDir;
    }

    public void setSorceDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setFilenameParam(String filenameparameter) {
        this.filenameparameter = filenameparameter;
    }

    public void setFiledirParam(String filedirparameter) {
        this.filedirparameter = filedirparameter;
    }

    public void setReloadstylesheet(boolean reloadstylesheet) {
        this.reloadstylesheet = reloadstylesheet;
    }

    public void setSource(File in) {
        this.in = in;
    }

    public void setResult(File out) {
        this.out = out;
    }

    public void setXMLCatalog(XMLCatalog xmlcatalog) {
        this.catalog = xmlcatalog;
    }

    public void setMapper(FileNameMapper mapper) {
        this.mapper = mapper;
    }

    public void setExtension(String extension) {
        this.extension = extension.startsWith(".") ? extension : "." + extension;
    }

    @Override
    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }
}

