/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection;

import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.AbstractIterator;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.mutable.HashSet;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import java.io.Serializable;
import java.util.NoSuchElementException;

public interface Iterator<A>
extends IterableOnce<A>,
IterableOnceOps<A, Iterator, Iterator<A>> {
    public boolean hasNext();

    public A next() throws NoSuchElementException;

    public static /* synthetic */ Iterator iterator$(Iterator $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<A> iterator() {
        return this;
    }

    public static /* synthetic */ int indexWhere$(Iterator $this, Function1 p, int from) {
        return $this.indexWhere(p, from);
    }

    default public int indexWhere(Function1<A, Object> p, int from) {
        int max_y = 0;
        int i = Math.max(from, max_y);
        Iterator<A> dropped = this.drop(from);
        while (dropped.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(dropped.next()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static /* synthetic */ boolean isEmpty$(Iterator $this) {
        return $this.isEmpty();
    }

    @Override
    default public boolean isEmpty() {
        return !this.hasNext();
    }

    public static /* synthetic */ Iterator filter$(Iterator $this, Function1 p) {
        return $this.filter(p);
    }

    default public Iterator<A> filter(Function1<A, Object> p) {
        return this.filterImpl(p, false);
    }

    public static /* synthetic */ Iterator filterImpl$(Iterator $this, Function1 p, boolean isFlipped) {
        return $this.filterImpl(p, isFlipped);
    }

    default public Iterator<A> filterImpl(Function1<A, Object> p, boolean isFlipped) {
        return new AbstractIterator<A>(this, p, isFlipped){
            private A hd;
            private boolean hdDefined;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$1;
            private final boolean isFlipped$1;

            public boolean hasNext() {
                if (!this.hdDefined) {
                    if (!this.$outer.hasNext()) {
                        return false;
                    }
                    this.hd = this.$outer.next();
                    while (BoxesRunTime.unboxToBoolean(this.p$1.apply(this.hd)) == this.isFlipped$1) {
                        if (!this.$outer.hasNext()) {
                            return false;
                        }
                        this.hd = this.$outer.next();
                    }
                    this.hdDefined = true;
                }
                return true;
            }

            public A next() {
                if (this.hasNext()) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$1 = p$1;
                this.isFlipped$1 = isFlipped$1;
                this.hdDefined = false;
            }
        };
    }

    public static /* synthetic */ Iterator withFilter$(Iterator $this, Function1 p) {
        return $this.withFilter(p);
    }

    default public Iterator<A> withFilter(Function1<A, Object> p) {
        return this.filter(p);
    }

    public static /* synthetic */ Iterator collect$(Iterator $this, PartialFunction pf) {
        return $this.collect(pf);
    }

    default public <B> Iterator<B> collect(PartialFunction<A, B> pf) {
        return new Function1<A, B>(this, pf){
            private B hd;
            private int status;
            private final /* synthetic */ Iterator $outer;
            private final PartialFunction pf$1;

            public boolean apply$mcZI$sp(int v1) {
                return Function1.apply$mcZI$sp$(this, v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.apply$mcII$sp$(this, v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.apply$mcVI$sp$(this, v1);
            }

            public String toString() {
                return Function1.toString$(this);
            }

            public B apply(A value) {
                return (B)Statics.pfMarker;
            }

            public boolean hasNext() {
                Object marker = Statics.pfMarker;
                while (this.status == 0) {
                    if (this.$outer.hasNext()) {
                        A x = this.$outer.next();
                        B1 v = this.pf$1.applyOrElse(x, this);
                        if (marker == v) continue;
                        this.hd = v;
                        this.status = 1;
                        continue;
                    }
                    this.status = -1;
                }
                return this.status == 1;
            }

            public B next() {
                if (this.hasNext()) {
                    this.status = 0;
                    return this.hd;
                }
                return (B)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pf$1 = pf$1;
                this.status = 0;
            }
        };
    }

    public static /* synthetic */ Iterator distinctBy$(Iterator $this, Function1 f) {
        return $this.distinctBy(f);
    }

    default public <B> Iterator<A> distinctBy(Function1<A, B> f) {
        return new AbstractIterator<A>(this, f){
            private final HashSet<B> traversedValues;
            private boolean nextElementDefined;
            private A nextElement;
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$1;

            public boolean hasNext() {
                block2: {
                    while (!this.nextElementDefined) {
                        if (this.$outer.hasNext()) {
                            A a = this.$outer.next();
                            if (!this.traversedValues.add(this.f$1.apply(a))) continue;
                            this.nextElement = a;
                            this.nextElementDefined = true;
                            break;
                        }
                        break block2;
                    }
                    return true;
                }
                return false;
            }

            public A next() {
                if (this.hasNext()) {
                    this.nextElementDefined = false;
                    return this.nextElement;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
                this.traversedValues = new HashSet<A>();
                this.nextElementDefined = false;
            }
        };
    }

    public static /* synthetic */ Iterator map$(Iterator $this, Function1 f) {
        return $this.map(f);
    }

    default public <B> Iterator<B> map(Function1<A, B> f) {
        return new AbstractIterator<B>(this, f){
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$2;

            public int knownSize() {
                return this.$outer.knownSize();
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public B next() {
                return (B)this.f$2.apply(this.$outer.next());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$2 = f$2;
            }
        };
    }

    public static /* synthetic */ Iterator flatMap$(Iterator $this, Function1 f) {
        return $this.flatMap(f);
    }

    default public <B> Iterator<B> flatMap(Function1<A, IterableOnce<B>> f) {
        return new AbstractIterator<B>(this, f){
            private Iterator<B> cur;
            private int _hasNext;
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$3;

            private void nextCur() {
                this.cur = Iterator$.scala$collection$Iterator$$_empty;
                this.cur = ((IterableOnce)this.f$3.apply(this.$outer.next())).iterator();
                this._hasNext = -1;
            }

            public boolean hasNext() {
                if (this._hasNext == -1) {
                    while (!this.cur.hasNext()) {
                        if (!this.$outer.hasNext()) {
                            this._hasNext = 0;
                            this.cur = Iterator$.scala$collection$Iterator$$_empty;
                            return false;
                        }
                        this.nextCur();
                    }
                    this._hasNext = 1;
                    return true;
                }
                return this._hasNext == 1;
            }

            public B next() {
                if (this.hasNext()) {
                    this._hasNext = -1;
                }
                return this.cur.next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$3 = f$3;
                this.cur = Iterator$.scala$collection$Iterator$$_empty;
                this._hasNext = -1;
            }
        };
    }

    public static /* synthetic */ Iterator flatten$(Iterator $this, Function1 ev) {
        return $this.flatten(ev);
    }

    default public <B> Iterator<B> flatten(Function1<A, IterableOnce<B>> ev) {
        return this.flatMap(ev);
    }

    public static /* synthetic */ Iterator concat$(Iterator $this, Function0 xs) {
        return $this.concat(xs);
    }

    default public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
        return new ConcatIterator(this).concat(xs);
    }

    public static /* synthetic */ Iterator $plus$plus$(Iterator $this, Function0 xs) {
        return $this.$plus$plus(xs);
    }

    default public <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
        return this.concat(xs);
    }

    public static /* synthetic */ Iterator take$(Iterator $this, int n) {
        return $this.take(n);
    }

    default public Iterator<A> take(int n) {
        int max$extension_that = 0;
        return this.sliceIterator(0, Math.max(n, max$extension_that));
    }

    public static /* synthetic */ Iterator takeWhile$(Iterator $this, Function1 p) {
        return $this.takeWhile(p);
    }

    default public Iterator<A> takeWhile(Function1<A, Object> p) {
        return new AbstractIterator<A>(this, p){
            private A hd;
            private boolean hdDefined;
            private Iterator<A> tail;
            private final Function1 p$2;

            public boolean hasNext() {
                block6: {
                    block5: {
                        if (this.hdDefined) break block5;
                        if (!this.tail.hasNext()) break block6;
                        this.hd = this.tail.next();
                        if (BoxesRunTime.unboxToBoolean(this.p$2.apply(this.hd))) {
                            this.hdDefined = true;
                        } else {
                            this.tail = Iterator$.scala$collection$Iterator$$_empty;
                        }
                        if (!this.hdDefined) break block6;
                    }
                    return true;
                }
                return false;
            }

            public A next() {
                if (this.hasNext()) {
                    this.hdDefined = false;
                    return this.hd;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                this.p$2 = p$2;
                this.hdDefined = false;
                this.tail = $outer;
            }
        };
    }

    public static /* synthetic */ Iterator drop$(Iterator $this, int n) {
        return $this.drop(n);
    }

    default public Iterator<A> drop(int n) {
        return this.sliceIterator(n, -1);
    }

    public static /* synthetic */ Iterator dropWhile$(Iterator $this, Function1 p) {
        return $this.dropWhile(p);
    }

    default public Iterator<A> dropWhile(Function1<A, Object> p) {
        return new AbstractIterator<A>(this, p){
            private int status;
            private A fst;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$3;

            public boolean hasNext() {
                if (this.status == 1) {
                    return this.$outer.hasNext();
                }
                if (this.status == 0) {
                    return true;
                }
                while (this.$outer.hasNext()) {
                    A a = this.$outer.next();
                    if (BoxesRunTime.unboxToBoolean(this.p$3.apply(a))) continue;
                    this.fst = a;
                    this.status = 0;
                    return true;
                }
                this.status = 1;
                return false;
            }

            public A next() {
                if (this.hasNext()) {
                    if (this.status == 1) {
                        return this.$outer.next();
                    }
                    this.status = 1;
                    return this.fst;
                }
                return (A)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$3 = p$3;
                this.status = -1;
            }
        };
    }

    public static /* synthetic */ Iterator sliceIterator$(Iterator $this, int from, int until) {
        return $this.sliceIterator(from, until);
    }

    default public Iterator<A> sliceIterator(int from, int until) {
        int rest;
        int max$extension_that = 0;
        int lo = Math.max(from, max$extension_that);
        int n = until < 0 ? -1 : (rest = until <= lo ? 0 : until - lo);
        if (rest == 0) {
            return Iterator$.scala$collection$Iterator$$_empty;
        }
        return new SliceIterator(this, lo, rest);
    }

    public static /* synthetic */ Iterator zip$(Iterator $this, IterableOnce that) {
        return $this.zip(that);
    }

    default public <B> Iterator<Tuple2<A, B>> zip(IterableOnce<B> that) {
        return new AbstractIterator<Tuple2<A, B>>(this, that){
            private final Iterator<B> thatIterator;
            private final /* synthetic */ Iterator $outer;

            private Iterator<B> thatIterator() {
                return this.thatIterator;
            }

            public int knownSize() {
                int n = this.$outer.knownSize();
                int min$extension_that = this.thatIterator().knownSize();
                return Math.min(n, min$extension_that);
            }

            public boolean hasNext() {
                return this.$outer.hasNext() && this.thatIterator().hasNext();
            }

            public Tuple2<A, B> next() {
                return new Tuple2<A, B>(this.$outer.next(), this.thatIterator().next());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.thatIterator = that$1.iterator();
            }
        };
    }

    public static /* synthetic */ Iterator zipWithIndex$(Iterator $this) {
        return $this.zipWithIndex();
    }

    default public Iterator<Tuple2<A, Object>> zipWithIndex() {
        return new AbstractIterator<Tuple2<A, Object>>(this){
            private int idx;
            private final /* synthetic */ Iterator $outer;

            private int idx() {
                return this.idx;
            }

            private void idx_$eq(int x$1) {
                this.idx = x$1;
            }

            public int knownSize() {
                return this.$outer.knownSize();
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public Tuple2<A, Object> next() {
                Tuple2<A, Integer> ret = new Tuple2<A, Integer>(this.$outer.next(), this.idx());
                this.idx_$eq(this.idx() + 1);
                return ret;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.idx = 0;
            }
        };
    }

    public static /* synthetic */ boolean sameElements$(Iterator $this, IterableOnce that) {
        return $this.sameElements(that);
    }

    default public <B> boolean sameElements(IterableOnce<B> that) {
        Iterator<B> those = that.iterator();
        while (this.hasNext() && those.hasNext()) {
            if (BoxesRunTime.equals(this.next(), those.next())) continue;
            return false;
        }
        return this.hasNext() == those.hasNext();
    }

    public static /* synthetic */ String toString$(Iterator $this) {
        return $this.toString();
    }

    default public String toString() {
        return "<iterator>";
    }

    private static final class ConcatIterator<A>
    extends AbstractIterator<A> {
        private Iterator<A> current;
        private ConcatIteratorCell<A> tail;
        private ConcatIteratorCell<A> last;
        private boolean currentHasNextChecked;

        private Iterator<A> current() {
            return this.current;
        }

        private void current_$eq(Iterator<A> x$1) {
            this.current = x$1;
        }

        private ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        private void tail_$eq(ConcatIteratorCell<A> x$1) {
            this.tail = x$1;
        }

        private ConcatIteratorCell<A> last() {
            return this.last;
        }

        private void last_$eq(ConcatIteratorCell<A> x$1) {
            this.last = x$1;
        }

        private boolean currentHasNextChecked() {
            return this.currentHasNextChecked;
        }

        private void currentHasNextChecked_$eq(boolean x$1) {
            this.currentHasNextChecked = x$1;
        }

        @Override
        public boolean hasNext() {
            if (this.currentHasNextChecked()) {
                return true;
            }
            if (this.current() == null) {
                return false;
            }
            if (this.current().hasNext()) {
                this.currentHasNextChecked_$eq(true);
                return true;
            }
            return this.advance$1();
        }

        @Override
        public A next() {
            if (this.hasNext()) {
                this.currentHasNextChecked_$eq(false);
                return this.current().next();
            }
            return (A)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        @Override
        public <B> Iterator<B> concat(Function0<IterableOnce<B>> that) {
            ConcatIteratorCell c = new ConcatIteratorCell(that, null);
            if (this.tail() == null) {
                this.tail_$eq(c);
                this.last_$eq(c);
            } else {
                this.last().tail_$eq(c);
                this.last_$eq(c);
            }
            if (this.current() == null) {
                this.current_$eq(Iterator$.scala$collection$Iterator$$_empty);
            }
            return this;
        }

        private final void merge$1() {
            while (this.current() instanceof ConcatIterator) {
                ConcatIterator c = (ConcatIterator)this.current();
                this.current_$eq(c.current());
                this.currentHasNextChecked_$eq(c.currentHasNextChecked());
                if (c.tail() == null) continue;
                if (this.last() == null) {
                    this.last_$eq(c.last());
                }
                c.last().tail_$eq(this.tail());
                this.tail_$eq(c.tail());
            }
        }

        private final boolean advance$1() {
            do {
                if (this.tail() == null) {
                    this.current_$eq(null);
                    this.last_$eq(null);
                    return false;
                }
                this.current_$eq(this.tail().headIterator());
                if (this.last() == this.tail()) {
                    this.last_$eq(this.last().tail());
                }
                this.tail_$eq(this.tail().tail());
                this.merge$1();
                if (!this.currentHasNextChecked()) continue;
                return true;
            } while (this.current() == null || !this.current().hasNext());
            this.currentHasNextChecked_$eq(true);
            return true;
        }

        public ConcatIterator(Iterator<A> current) {
            this.current = current;
            this.tail = null;
            this.last = null;
            this.currentHasNextChecked = false;
        }
    }

    private static final class ConcatIteratorCell<A> {
        private final Function0<IterableOnce<A>> head;
        private ConcatIteratorCell<A> tail;

        public ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        public void tail_$eq(ConcatIteratorCell<A> x$1) {
            this.tail = x$1;
        }

        public Iterator<A> headIterator() {
            return this.head.apply().iterator();
        }

        public ConcatIteratorCell(Function0<IterableOnce<A>> head, ConcatIteratorCell<A> tail) {
            this.head = head;
            this.tail = tail;
        }
    }

    public static final class SliceIterator<A>
    extends AbstractIterator<A> {
        private final Iterator<A> underlying;
        public int scala$collection$Iterator$SliceIterator$$remaining;
        private int dropping;

        public Iterator<A> underlying() {
            return this.underlying;
        }

        private void skip() {
            while (this.dropping > 0) {
                if (this.underlying().hasNext()) {
                    this.underlying().next();
                    --this.dropping;
                    continue;
                }
                this.dropping = 0;
            }
        }

        @Override
        public int knownSize() {
            int size2 = this.underlying().knownSize();
            if (size2 < 0) {
                return -1;
            }
            int n = 0;
            int max$extension_that = size2 - this.dropping;
            int dropSize = Math.max(n, max$extension_that);
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return dropSize;
            }
            int n2 = this.scala$collection$Iterator$SliceIterator$$remaining;
            return Math.min(n2, dropSize);
        }

        @Override
        public boolean hasNext() {
            this.skip();
            return this.scala$collection$Iterator$SliceIterator$$remaining != 0 && this.underlying().hasNext();
        }

        @Override
        public A next() {
            this.skip();
            if (this.scala$collection$Iterator$SliceIterator$$remaining > 0) {
                --this.scala$collection$Iterator$SliceIterator$$remaining;
                return this.underlying().next();
            }
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return this.underlying().next();
            }
            return (A)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        @Override
        public Iterator<A> sliceIterator(int from, int until) {
            int n;
            int max$extension_that = 0;
            int lo = Math.max(from, max$extension_that);
            if (until < 0) {
                n = this.adjustedBound$1(lo);
            } else if (until <= lo) {
                n = 0;
            } else if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                n = until - lo;
            } else {
                int n2 = this.adjustedBound$1(lo);
                int min$extension_that = until - lo;
                n = Math.min(n2, min$extension_that);
            }
            int rest = n;
            int sum = this.dropping + lo;
            if (rest == 0) {
                return Iterator$.scala$collection$Iterator$$_empty;
            }
            if (sum < 0) {
                this.dropping = Integer.MAX_VALUE;
                this.scala$collection$Iterator$SliceIterator$$remaining = 0;
                Function0<SliceIterator> & Serializable concat_xs = (Function0<SliceIterator> & Serializable)() -> new SliceIterator(this.underlying(), sum - Integer.MAX_VALUE, rest);
                return new ConcatIterator(this).concat(concat_xs);
            }
            this.dropping = sum;
            this.scala$collection$Iterator$SliceIterator$$remaining = rest;
            return this;
        }

        private final int adjustedBound$1(int lo$1) {
            if (this.scala$collection$Iterator$SliceIterator$$remaining < 0) {
                return -1;
            }
            int n = 0;
            int max$extension_that = this.scala$collection$Iterator$SliceIterator$$remaining - lo$1;
            return Math.max(n, max$extension_that);
        }

        public SliceIterator(Iterator<A> underlying, int start, int limit) {
            this.underlying = underlying;
            this.scala$collection$Iterator$SliceIterator$$remaining = limit;
            this.dropping = start;
        }
    }
}

