/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.TestReportGenerator;
import org.gradle.api.internal.tasks.testing.report.generic.GenericHtmlTestReport;
import org.gradle.api.internal.tasks.testing.report.generic.MetadataRendererRegistry;
import org.gradle.api.internal.tasks.testing.report.generic.TestTreeModel;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResultStore;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class GenericTestReportGenerator
implements TestReportGenerator {
    private final List<SerializableTestResultStore> stores;
    private final MetadataRendererRegistry metadataRendererRegistry;

    public GenericTestReportGenerator(Collection<Path> resultDirs, MetadataRendererRegistry metadataRendererRegistry) {
        this.stores = resultDirs.stream().distinct().map(SerializableTestResultStore::new).filter(SerializableTestResultStore::hasResults).collect(Collectors.toList());
        this.metadataRendererRegistry = metadataRendererRegistry;
    }

    @Override
    public boolean hasResults() {
        return !this.stores.isEmpty();
    }

    @Override
    public void generateReport(BuildOperationRunner operationRunner, BuildOperationExecutor operationExecutor, Path outputDir) {
        if (!this.hasResults()) {
            return;
        }
        ArrayList<SerializableTestResultStore.OutputReader> outputReaders = new ArrayList<SerializableTestResultStore.OutputReader>(this.stores.size());
        try {
            for (SerializableTestResultStore store : this.stores) {
                outputReaders.add(store.openOutputReader());
            }
            TestTreeModel root = TestTreeModel.loadModelFromStores(this.stores);
            new GenericHtmlTestReport(operationRunner, operationExecutor, outputReaders, this.metadataRendererRegistry).generateReport(root, outputDir);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            CompositeStoppable.stoppable(outputReaders).stop();
        }
    }
}

