/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */
package org.apache.xmlgraphics.image.loader.impl;


import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;

import org.junit.Test;
import static org.junit.Assert.assertEquals;

import org.apache.xmlgraphics.image.GraphicsConstants;

public class DefaultImageContextTestCase {

    @Test
    public void testDefaultResolution() {
        DefaultImageContext context = new DefaultImageContext();

        if (GraphicsEnvironment.isHeadless()) {
            //for linux based environemnts
            assertEquals("Default value must be set", GraphicsConstants.DEFAULT_DPI,
                    (int) context.getSourceResolution());
        } else {
            assertEquals("Default value must be set",
                    Toolkit.getDefaultToolkit().getScreenResolution(), (int) context.getSourceResolution());
        }
    }
}
