/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.navigation.paging;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.IAjaxLink;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigationBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigationLink;

public class AjaxPagingNavigationLink
extends PagingNavigationLink<Void>
implements IAjaxLink {
    private static final long serialVersionUID = 1L;

    public AjaxPagingNavigationLink(String id, IPageable pageable, long pageNumber) {
        super(id, pageable, pageNumber);
        this.setOutputMarkupId(true);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(this.newAjaxPagingNavigationBehavior(this.pageable, "click"));
    }

    protected AjaxPagingNavigationBehavior newAjaxPagingNavigationBehavior(IPageable pageable, String event) {
        return new AjaxPagingNavigationBehavior(this, pageable, event){

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setPreventDefault(true);
                AjaxPagingNavigationLink.this.updateAjaxAttributes(attributes);
            }
        };
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    @Override
    public void onClick() {
        this.onClick(null);
    }

    @Override
    public void onClick(AjaxRequestTarget target) {
        this.pageable.setCurrentPage(this.getPageNumber());
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("onclick");
    }
}

