/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SequencedCollection;
import java.util.TreeSet;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.MatchReference;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.feature.FeatureMatchExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.AnnotationComparator;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ImplicitFeatureAction
extends AbstractRutaAction {
    private FeatureMatchExpression expr;
    private Comparator<? super AnnotationFS> comp = new AnnotationComparator();

    public ImplicitFeatureAction(FeatureMatchExpression expr) {
        this.expr = expr;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotationsOfElement(element);
        SequencedCollection<Object> annotations = new TreeSet<AnnotationFS>(this.comp);
        MatchReference matchReference = this.expr.getMatchReference();
        ITypeExpression typeExpr = matchReference.getTypeExpression(context, stream);
        IAnnotationListExpression annotationListExpr = matchReference.getAnnotationListExpression(context, stream);
        IAnnotationExpression annotationExpr = matchReference.getAnnotationExpression(context, stream);
        for (AnnotationFS annotationFS : matchedAnnotations) {
            if (typeExpr != null) {
                Type type = typeExpr.getType(context, stream);
                annotations = stream.getBestGuessedAnnotationsAt(annotationFS, type);
                continue;
            }
            if (annotationListExpr != null) {
                annotations.addAll(annotationListExpr.getAnnotationList(context, stream));
                continue;
            }
            if (annotationExpr == null) continue;
            annotations.add((AnnotationFS)annotationExpr.getAnnotation(context, stream));
        }
        for (AnnotationFS annotationFS : annotations) {
            stream.getCas().removeFsFromIndexes((FeatureStructure)annotationFS);
        }
        Collection<? extends FeatureStructure> featureAnnotations = this.expr.getFeatureStructures(annotations, false, context, stream);
        if (featureAnnotations.isEmpty()) {
            featureAnnotations = annotations;
        }
        Feature feature = this.expr.getFeature(context, stream);
        IRutaExpression arg = this.expr.getArg();
        for (FeatureStructure featureStructure : featureAnnotations) {
            stream.assignFeatureValue(featureStructure, feature, arg, context);
        }
        for (AnnotationFS annotationFS : annotations) {
            stream.getCas().addFsToIndexes((FeatureStructure)annotationFS);
        }
    }

    public FeatureMatchExpression getExpr() {
        return this.expr;
    }

    public void setExpr(FeatureMatchExpression expr) {
        this.expr = expr;
    }
}

