/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator;

import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class CDEpropertyPage
extends PropertyPage {
    private static final String DATAPATH_LABEL = "&Data Path:";
    private static final String DATAPATH_PROPERTY_KEY = "CDEdataPath";
    private static final String DEFAULT_DATAPATH = "";
    private static final String BY_DEFAULT_PROPERTY_KEY = "CDEByDefault";
    private static final String ADD_TO_FLOW_PROPERTY_KEY = "CDEAddToFlow";
    private Text dataPathUI;

    protected Control createContents(Composite parent) {
        Composite composite = this.create2ColComposite(parent);
        Label instructions = new Label(composite, 64);
        instructions.setText("Enter the data path to use for finding resources by name;\nThis is a series of absolute paths, separated by\nwhatever character this platform uses for path separation (similar to class paths).\n\n");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        instructions.setLayoutData((Object)gd);
        new Label(composite, 0).setText(DATAPATH_LABEL);
        this.dataPathUI = new Text(composite, 2562);
        gd = new GridData(1808);
        this.dataPathUI.setLayoutData((Object)gd);
        try {
            String dataPath = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName(DEFAULT_DATAPATH, DATAPATH_PROPERTY_KEY));
            this.dataPathUI.setText(dataPath != null ? dataPath : DEFAULT_DATAPATH);
        }
        catch (CoreException e) {
            this.dataPathUI.setText(DEFAULT_DATAPATH);
        }
        return composite;
    }

    private Composite create2ColComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        this.dataPathUI.setText(DEFAULT_DATAPATH);
    }

    public boolean performOk() {
        try {
            ((IResource)this.getElement()).setPersistentProperty(new QualifiedName(DEFAULT_DATAPATH, DATAPATH_PROPERTY_KEY), this.dataPathUI.getText());
        }
        catch (CoreException e) {
            return false;
        }
        return true;
    }

    public static String getDataPath(IProject project) {
        String dataPath;
        try {
            dataPath = project.getPersistentProperty(new QualifiedName(DEFAULT_DATAPATH, DATAPATH_PROPERTY_KEY));
        }
        catch (CoreException e) {
            dataPath = DEFAULT_DATAPATH;
        }
        if (null == dataPath) {
            dataPath = DEFAULT_DATAPATH;
        }
        return dataPath;
    }

    public static void setDataPath(IProject project, String dataPath) {
        try {
            project.setPersistentProperty(new QualifiedName(DEFAULT_DATAPATH, DATAPATH_PROPERTY_KEY), dataPath);
        }
        catch (CoreException e) {
            throw new InternalErrorCDE("unhandled exception", e);
        }
    }

    public static String getImportByDefault(IProject project) {
        String byDefault;
        try {
            byDefault = project.getPersistentProperty(new QualifiedName(DEFAULT_DATAPATH, BY_DEFAULT_PROPERTY_KEY));
        }
        catch (CoreException e) {
            byDefault = DEFAULT_DATAPATH;
        }
        if (null == byDefault) {
            byDefault = DEFAULT_DATAPATH;
        }
        return byDefault;
    }

    public static void setImportByDefault(IProject project, String byDefault) {
        try {
            project.setPersistentProperty(new QualifiedName(DEFAULT_DATAPATH, BY_DEFAULT_PROPERTY_KEY), byDefault);
        }
        catch (CoreException e) {
            throw new InternalErrorCDE("unhandled exception", e);
        }
    }

    public static String getAddToFlow(IProject project) {
        String byDefault;
        try {
            byDefault = project.getPersistentProperty(new QualifiedName(DEFAULT_DATAPATH, ADD_TO_FLOW_PROPERTY_KEY));
        }
        catch (CoreException e) {
            byDefault = DEFAULT_DATAPATH;
        }
        if (null == byDefault) {
            byDefault = DEFAULT_DATAPATH;
        }
        return byDefault;
    }

    public static void setAddToFlow(IProject project, String byDefault) {
        try {
            project.setPersistentProperty(new QualifiedName(DEFAULT_DATAPATH, ADD_TO_FLOW_PROPERTY_KEY), byDefault);
        }
        catch (CoreException e) {
            throw new InternalErrorCDE("unhandled exception", e);
        }
    }
}

