/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ide.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.ide.CasEditorIdePlugin;
import org.apache.uima.caseditor.ide.wizards.DocumentImportStructureProvider;
import org.apache.uima.caseditor.ide.wizards.ImportDocumentWizardPage;
import org.apache.uima.caseditor.ide.wizards.OverwriteQuery;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public final class ImportDocumentWizard
extends Wizard
implements IImportWizard {
    private ImportDocumentWizardPage mMainPage;
    private IStructuredSelection mCurrentResourceSelection;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mCurrentResourceSelection = selection;
        this.setWindowTitle("Import");
    }

    public void addPages() {
        this.mMainPage = new ImportDocumentWizardPage("ImportDocuments", this.mCurrentResourceSelection);
        this.addPage((IWizardPage)this.mMainPage);
    }

    public boolean performFinish() {
        String usedEncoding = this.mMainPage.getTextEncoding();
        IPreferenceStore store = CasEditorIdePlugin.getDefault().getPreferenceStore();
        String lastUsedEncodingsString = store.getString("CAS_IMPORT_WIZARD_ENCODINGS");
        List<String> lastUsedEncodings = new ArrayList<String>(Arrays.asList(lastUsedEncodingsString.split(";")));
        int usedEncodingIndex = lastUsedEncodings.indexOf(usedEncoding);
        if (usedEncodingIndex != -1) {
            lastUsedEncodings.remove(usedEncodingIndex);
        }
        lastUsedEncodings.add(0, usedEncoding);
        int maxUserItemCount = 10;
        if (lastUsedEncodings.size() > maxUserItemCount) {
            lastUsedEncodings = lastUsedEncodings.subList(0, maxUserItemCount - 1);
        }
        StringBuilder updatedLastUsedEncodingsString = new StringBuilder();
        for (String encoding : lastUsedEncodings) {
            updatedLastUsedEncodingsString.append(encoding);
            updatedLastUsedEncodingsString.append(";");
        }
        store.setValue("CAS_IMPORT_WIZARD_ENCODINGS", updatedLastUsedEncodingsString.toString());
        DocumentImportStructureProvider importProvider = new DocumentImportStructureProvider(this.mMainPage.getLanguage(), this.mMainPage.getTextEncoding(), this.mMainPage.getCasFormat());
        ImportOperation operation = new ImportOperation(this.mMainPage.getImportDestinationPath(), (IImportStructureProvider)importProvider, (IOverwriteQuery)new OverwriteQuery(this.getShell()), this.mMainPage.getFilesToImport());
        operation.setContext(this.getShell());
        operation.setOverwriteResources(false);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            String causeMessage;
            CasEditorPlugin.log((Throwable)e);
            String message = "Unkown error during import, see the log file for details";
            Throwable cause = e.getCause();
            if (cause != null && (causeMessage = cause.getMessage()) != null) {
                message = causeMessage;
            }
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)"Import failed", (String)message);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }
}

