/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.constraint;

import io.smallrye.common.constraint.Messages;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;

public class Messages_$bundle
implements Messages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected Messages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String nullParam$str() {
        return "Parameter '%s' may not be null";
    }

    @Override
    public final IllegalArgumentException nullParam(String paramName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullParam$str(), paramName));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String paramLessThan$str() {
        return "SRCOM00001: Parameter '%s' may not be less than %s";
    }

    @Override
    public final IllegalArgumentException paramLessThan(String name, long min) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.paramLessThan$str(), name, min));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final IllegalArgumentException paramLessThan(String name, double min) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.paramLessThan$str(), name, min));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final IllegalArgumentException paramLessThan(String name, Object min) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.paramLessThan$str(), name, min));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String paramGreaterThan$str() {
        return "SRCOM00002: Parameter '%s' may not be greater than %s";
    }

    @Override
    public final IllegalArgumentException paramGreaterThan(String name, long max) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.paramGreaterThan$str(), name, max));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final IllegalArgumentException paramGreaterThan(String name, double max) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.paramGreaterThan$str(), name, max));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final IllegalArgumentException paramGreaterThan(String name, Object max) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.paramGreaterThan$str(), name, max));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String arrayOffsetGreaterThanLength$str() {
        return "SRCOM00003: Given offset of %d is greater than array length of %d";
    }

    @Override
    public final ArrayIndexOutOfBoundsException arrayOffsetGreaterThanLength(int offs, int arrayLength) {
        ArrayIndexOutOfBoundsException result = new ArrayIndexOutOfBoundsException(String.format(this.getLoggingLocale(), this.arrayOffsetGreaterThanLength$str(), offs, arrayLength));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String arrayOffsetLengthGreaterThanLength$str() {
        return "SRCOM00004: Given offset of %d plus length of %d is greater than array length of %d";
    }

    @Override
    public final ArrayIndexOutOfBoundsException arrayOffsetLengthGreaterThanLength(int offs, int len, int arrayLength) {
        ArrayIndexOutOfBoundsException result = new ArrayIndexOutOfBoundsException(String.format(this.getLoggingLocale(), this.arrayOffsetLengthGreaterThanLength$str(), offs, len, arrayLength));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullArrayParam$str() {
        return "SRCOM00005: Array index %d of parameter '%s' may not be null";
    }

    @Override
    public final IllegalArgumentException nullArrayParam(int index, String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullArrayParam$str(), index, name));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String emptyParam$str() {
        return "SRCOM00006: Parameter '%s' must not be empty";
    }

    @Override
    public final IllegalArgumentException emptyParam(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.emptyParam$str(), name));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedNullValue$str() {
        return "SRCOM00007: Internal error: Assertion failure: Unexpectedly null value";
    }

    @Override
    public final String unexpectedNullValue() {
        return String.format(this.getLoggingLocale(), this.unexpectedNullValue$str(), new Object[0]);
    }

    protected String expectedLockHold$str() {
        return "SRCOM00008: Internal error: Assertion failure: Current thread expected to hold lock for %s";
    }

    @Override
    public final String expectedLockHold(Object monitor) {
        return String.format(this.getLoggingLocale(), this.expectedLockHold$str(), monitor);
    }

    protected String expectedLockNotHold$str() {
        return "SRCOM00009: Internal error: Assertion failure: Current thread expected to not hold lock for %s";
    }

    @Override
    public final String expectedLockNotHold(Object monitor) {
        return String.format(this.getLoggingLocale(), this.expectedLockNotHold$str(), monitor);
    }

    protected String expectedBoolean$str() {
        return "SRCOM00010: Internal error: Assertion failure: Expected boolean value to be %s";
    }

    @Override
    public final String expectedBoolean(boolean expr) {
        return String.format(this.getLoggingLocale(), this.expectedBoolean$str(), expr);
    }

    protected String unreachableCode$str() {
        return "SRCOM00011: Internal error: Unreachable code has been reached";
    }

    @Override
    public final IllegalStateException unreachableCode() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unreachableCode$str(), new Object[0]));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String impossibleSwitchCase$str() {
        return "SRCOM00012: Internal error: Impossible switch condition encountered: %s";
    }

    @Override
    public final IllegalStateException impossibleSwitchCase(Object cond) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.impossibleSwitchCase$str(), cond));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupported$str() {
        return "SRCOM00013: Method \"%s\" of class \"%s\" is not supported";
    }

    @Override
    public final UnsupportedOperationException unsupported(String methodName, String className) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupported$str(), methodName, className));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String paramNotPow2$str() {
        return "SRCOM00014: Parameter '%s' must be a power of two";
    }

    @Override
    public final IllegalArgumentException paramNotPow2(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.paramNotPow2$str(), name));
        Messages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

