/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import org.apache.webbeans.exception.helper.DescriptiveException;

public abstract class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static RuntimeException throwAsRuntimeException(Throwable throwable) {
        new ExceptionHelper().throwException(throwable);
        return null;
    }

    public static String currentStack() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder(500);
        for (StackTraceElement ste : stackTrace) {
            sb.append("  ").append(ste.getClassName()).append("#").append(ste.getMethodName()).append(":").append(ste.getLineNumber()).append('\n');
        }
        return sb.toString();
    }

    public static RuntimeException addInformation(RuntimeException e, String additionalinfo) {
        if (e instanceof DescriptiveException) {
            ((DescriptiveException)((Object)e)).addInformation(additionalinfo);
        }
        return e;
    }

    private static class ExceptionHelper<T extends Throwable> {
        private ExceptionHelper() {
        }

        private void throwException(Throwable exception) throws T {
            try {
                throw exception;
            }
            catch (ClassCastException e) {
                if (e.getStackTrace()[0].toString().contains(this.getClass().getName())) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new RuntimeException(exception);
                }
                throw e;
            }
        }
    }
}

