/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.BaseID;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.core.impl.RequestAbstractTypeUnmarshaller;
import org.w3c.dom.Attr;

public class LogoutRequestUnmarshaller
extends RequestAbstractTypeUnmarshaller {
    @Override
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        LogoutRequest req = (LogoutRequest)parentObject;
        if (childObject instanceof BaseID) {
            req.setBaseID((BaseID)childObject);
        } else if (childObject instanceof NameID) {
            req.setNameID((NameID)childObject);
        } else if (childObject instanceof EncryptedID) {
            req.setEncryptedID((EncryptedID)childObject);
        } else if (childObject instanceof SessionIndex) {
            req.getSessionIndexes().add((SessionIndex)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    @Override
    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        LogoutRequest req = (LogoutRequest)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("Reason")) {
                req.setReason(attribute.getValue());
            } else if (attribute.getLocalName().equals("NotOnOrAfter") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                req.setNotOnOrAfter(DOMTypeSupport.stringToInstant((String)attribute.getValue()));
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            super.processAttribute(xmlObject, attribute);
        }
    }
}

