"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.formatWord = void 0;
var types_1 = require("../types");
var formatWord = function (config) { return function (syntaxTree) {
    return {
        type: types_1.TokenType.Word,
        word: syntaxTree.word,
        localIndentation: config.localIndentation,
        shouldStartWithDot: Boolean(config.shouldStartWithDot),
        shouldEndWithDot: Boolean(config.shouldEndWithDot),
        width: syntaxTree.word.length,
    };
}; };
exports.formatWord = formatWord;
