/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.xmlschema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.common.xmlschema.InvalidXmlSchemaReferenceException;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupRef;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.extensions.ExtensionRegistry;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.apache.ws.commons.schema.utils.XmlSchemaObjectBase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaCollection {
    private final XmlSchemaCollection xmlSchemaCollection;
    private final Map<XmlSchema, Set<XmlSchemaType>> xmlTypesCheckedForCrossImportsPerSchema = new HashMap<XmlSchema, Set<XmlSchemaType>>();

    public SchemaCollection() {
        this(new XmlSchemaCollection());
    }

    public SchemaCollection(XmlSchemaCollection col) {
        this.xmlSchemaCollection = col;
        if (this.xmlSchemaCollection.getNamespaceContext() == null) {
            this.xmlSchemaCollection.setNamespaceContext(new NamespaceMap());
        }
    }

    public XmlSchemaCollection getXmlSchemaCollection() {
        return this.xmlSchemaCollection;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SchemaCollection) {
            return this.xmlSchemaCollection.equals(((SchemaCollection)obj).xmlSchemaCollection);
        }
        if (obj instanceof XmlSchemaCollection) {
            return this.xmlSchemaCollection.equals(obj);
        }
        return false;
    }

    public XmlSchemaElement getElementByQName(QName qname) {
        return this.xmlSchemaCollection.getElementByQName(qname);
    }

    public XmlSchemaAttribute getAttributeByQName(QName qname) {
        return this.xmlSchemaCollection.getAttributeByQName(qname);
    }

    public ExtensionRegistry getExtReg() {
        return this.xmlSchemaCollection.getExtReg();
    }

    public NamespacePrefixList getNamespaceContext() {
        return this.xmlSchemaCollection.getNamespaceContext();
    }

    public XmlSchemaType getTypeByQName(QName schemaTypeName) {
        return this.xmlSchemaCollection.getTypeByQName(schemaTypeName);
    }

    public XmlSchema[] getXmlSchema(String systemId) {
        return this.xmlSchemaCollection.getXmlSchema(systemId);
    }

    public XmlSchema[] getXmlSchemas() {
        return this.xmlSchemaCollection.getXmlSchemas();
    }

    public int hashCode() {
        return this.xmlSchemaCollection.hashCode();
    }

    public void init() {
        this.xmlSchemaCollection.init();
    }

    public XmlSchema read(Element elem, String uri) {
        return this.xmlSchemaCollection.read(elem, uri);
    }

    public XmlSchema read(Document d, String uri) {
        return this.xmlSchemaCollection.read(d, uri);
    }

    public XmlSchema read(Element elem) {
        return this.xmlSchemaCollection.read(elem);
    }

    public void setBaseUri(String baseUri) {
        this.xmlSchemaCollection.setBaseUri(baseUri);
    }

    public void setExtReg(ExtensionRegistry extReg) {
        this.xmlSchemaCollection.setExtReg(extReg);
    }

    public void setNamespaceContext(NamespacePrefixList namespaceContext) {
        this.xmlSchemaCollection.setNamespaceContext(namespaceContext);
    }

    public void setSchemaResolver(URIResolver schemaResolver) {
        this.xmlSchemaCollection.setSchemaResolver(schemaResolver);
    }

    public XmlSchema getSchemaByTargetNamespace(String namespaceURI) {
        for (XmlSchema schema : this.xmlSchemaCollection.getXmlSchemas()) {
            if ((namespaceURI == null || !namespaceURI.equals(schema.getTargetNamespace())) && (namespaceURI != null || schema.getTargetNamespace() != null)) continue;
            return schema;
        }
        return null;
    }

    public XmlSchema getSchemaForElement(QName name) {
        for (XmlSchema schema : this.xmlSchemaCollection.getXmlSchemas()) {
            if (!name.getNamespaceURI().equals(schema.getTargetNamespace())) continue;
            if (schema.getElementByName(name.getLocalPart()) != null) {
                return schema;
            }
            if (schema.getElementByName(name) == null) continue;
            return schema;
        }
        return null;
    }

    public XmlSchema newXmlSchemaInCollection(String namespaceURI) {
        return new XmlSchema(namespaceURI, this.xmlSchemaCollection);
    }

    public void validateQNameNamespace(QName qname) {
        if ("".equals(qname.getNamespaceURI())) {
            return;
        }
        for (XmlSchema schema : this.xmlSchemaCollection.getXmlSchemas()) {
            if (!schema.getTargetNamespace().equals(qname.getNamespaceURI())) continue;
            return;
        }
        throw new InvalidXmlSchemaReferenceException(qname + " refers to unknown namespace.");
    }

    public void validateElementName(QName referrer, QName elementQName) {
        XmlSchemaElement element = this.xmlSchemaCollection.getElementByQName(elementQName);
        if (element == null) {
            throw new InvalidXmlSchemaReferenceException(referrer + " references non-existent element " + elementQName);
        }
    }

    public void validateTypeName(QName referrer, QName typeQName) {
        XmlSchemaType type = this.xmlSchemaCollection.getTypeByQName(typeQName);
        if (type == null) {
            throw new InvalidXmlSchemaReferenceException(referrer + " references non-existent type " + typeQName);
        }
    }

    public void addCrossImports() {
        for (XmlSchema schema : this.xmlSchemaCollection.getXmlSchemas()) {
            this.addOneSchemaCrossImports(schema);
        }
    }

    private void addOneSchemaCrossImports(XmlSchema schema) {
        for (XmlSchemaElement element : schema.getElements().values()) {
            this.addElementCrossImportsElement(schema, element);
        }
        for (XmlSchemaAttribute attribute : schema.getAttributes().values()) {
            XmlSchemaUtils.addImportIfNeeded(schema, attribute.getRef().getTargetQName());
            XmlSchemaUtils.addImportIfNeeded(schema, attribute.getSchemaTypeName());
        }
        for (XmlSchemaType type : schema.getSchemaTypes().values()) {
            this.addCrossImportsType(schema, type);
        }
    }

    private void addElementCrossImportsElement(XmlSchema schema, XmlSchemaElement item) {
        XmlSchemaElement element = item;
        XmlSchemaUtils.addImportIfNeeded(schema, element.getRef().getTargetQName());
        XmlSchemaUtils.addImportIfNeeded(schema, element.getSchemaTypeName());
        XmlSchemaType schemaType = element.getSchemaType();
        if (!this.crossImportsAdded(schema, schemaType)) {
            this.addCrossImportsType(schema, schemaType);
        }
    }

    private boolean crossImportsAdded(XmlSchema schema, XmlSchemaType schemaType) {
        boolean result = true;
        if (schemaType != null) {
            Set<Object> xmlTypesCheckedForCrossImports;
            if (!this.xmlTypesCheckedForCrossImportsPerSchema.containsKey(schema)) {
                xmlTypesCheckedForCrossImports = new HashSet();
                this.xmlTypesCheckedForCrossImportsPerSchema.put(schema, xmlTypesCheckedForCrossImports);
            } else {
                xmlTypesCheckedForCrossImports = this.xmlTypesCheckedForCrossImportsPerSchema.get(schema);
            }
            if (!xmlTypesCheckedForCrossImports.contains(schemaType)) {
                xmlTypesCheckedForCrossImports.add(schemaType);
                result = false;
            }
        }
        return result;
    }

    private void addCrossImportsType(XmlSchema schema, XmlSchemaType schemaType) {
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType complexType = (XmlSchemaComplexType)schemaType;
            XmlSchemaUtils.addImportIfNeeded(schema, complexType.getBaseSchemaTypeName());
            this.addCrossImports(schema, complexType.getContentModel());
            this.addCrossImportsAttributeList(schema, complexType.getAttributes());
            if (complexType.getParticle() instanceof XmlSchemaChoice) {
                XmlSchemaChoice choice = (XmlSchemaChoice)complexType.getParticle();
                this.addCrossImports(schema, choice);
            } else if (complexType.getParticle() instanceof XmlSchemaAll) {
                XmlSchemaAll all = (XmlSchemaAll)complexType.getParticle();
                this.addCrossImports(schema, all);
            } else if (complexType.getParticle() instanceof XmlSchemaSequence) {
                XmlSchemaSequence sequence = (XmlSchemaSequence)complexType.getParticle();
                this.addCrossImports(schema, sequence);
            }
        }
    }

    private void addCrossImports(XmlSchema schema, XmlSchemaAll all) {
        for (XmlSchemaObjectBase xmlSchemaObjectBase : all.getItems()) {
            if (!(xmlSchemaObjectBase instanceof XmlSchemaElement)) continue;
            this.addElementCrossImportsElement(schema, (XmlSchemaElement)xmlSchemaObjectBase);
        }
    }

    private void addCrossImports(XmlSchema schema, XmlSchemaChoice choice) {
        for (XmlSchemaObjectBase xmlSchemaObjectBase : choice.getItems()) {
            if (!(xmlSchemaObjectBase instanceof XmlSchemaElement)) continue;
            this.addElementCrossImportsElement(schema, (XmlSchemaElement)xmlSchemaObjectBase);
        }
    }

    private void addCrossImports(XmlSchema schema, XmlSchemaSequence sequence) {
        for (XmlSchemaSequenceMember seqMember : sequence.getItems()) {
            if (!(seqMember instanceof XmlSchemaElement)) continue;
            this.addElementCrossImportsElement(schema, (XmlSchemaElement)seqMember);
        }
    }

    private void addCrossImportsAttributeList(XmlSchema schema, List<XmlSchemaAttributeOrGroupRef> list) {
        for (XmlSchemaAttributeOrGroupRef attr : list) {
            QName ref;
            if (attr instanceof XmlSchemaAttribute) {
                ref = ((XmlSchemaAttribute)attr).getRef().getTargetQName();
            } else {
                XmlSchemaAttributeGroupRef groupRef = (XmlSchemaAttributeGroupRef)attr;
                ref = groupRef.getRef().getTargetQName();
            }
            if (ref == null) continue;
            XmlSchemaUtils.addImportIfNeeded(schema, ref);
        }
    }

    private void addCrossImports(XmlSchema schema, XmlSchemaContentModel contentModel) {
        if (contentModel == null) {
            return;
        }
        XmlSchemaContent content = contentModel.getContent();
        if (content == null) {
            return;
        }
        if (content instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)content;
            XmlSchemaUtils.addImportIfNeeded(schema, extension.getBaseTypeName());
            this.addCrossImportsAttributeList(schema, extension.getAttributes());
            XmlSchemaParticle particle = extension.getParticle();
            if (particle instanceof XmlSchemaSequence) {
                this.addCrossImports(schema, (XmlSchemaSequence)particle);
            } else if (particle instanceof XmlSchemaChoice) {
                this.addCrossImports(schema, (XmlSchemaChoice)particle);
            } else if (particle instanceof XmlSchemaAll) {
                this.addCrossImports(schema, (XmlSchemaAll)particle);
            }
        } else if (content instanceof XmlSchemaComplexContentRestriction) {
            XmlSchemaComplexContentRestriction restriction = (XmlSchemaComplexContentRestriction)content;
            XmlSchemaUtils.addImportIfNeeded(schema, restriction.getBaseTypeName());
            this.addCrossImportsAttributeList(schema, restriction.getAttributes());
        } else if (content instanceof XmlSchemaSimpleContentExtension) {
            XmlSchemaSimpleContentExtension extension = (XmlSchemaSimpleContentExtension)content;
            XmlSchemaUtils.addImportIfNeeded(schema, extension.getBaseTypeName());
            this.addCrossImportsAttributeList(schema, extension.getAttributes());
        } else if (content instanceof XmlSchemaSimpleContentRestriction) {
            XmlSchemaSimpleContentRestriction restriction = (XmlSchemaSimpleContentRestriction)content;
            XmlSchemaUtils.addImportIfNeeded(schema, restriction.getBaseTypeName());
            this.addCrossImportsAttributeList(schema, restriction.getAttributes());
        }
    }
}

