/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.codegen.SpoofCUDACellwise;
import org.apache.sysds.runtime.codegen.SpoofCUDAOperator;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.KahanFunction;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.KahanPlusSq;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.KahanObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.matrix.data.LibMatrixMult;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;

public abstract class SpoofCellwise
extends SpoofOperator {
    private static final long serialVersionUID = 3442528770573293590L;
    protected final CellType _type;
    private final AggOp _aggOp;
    private final boolean _sparseSafe;
    private final boolean _containsSeq;

    public SpoofCellwise(CellType type, boolean sparseSafe, boolean containsSeq, AggOp aggOp) {
        this._type = type;
        this._aggOp = aggOp;
        this._sparseSafe = sparseSafe;
        this._containsSeq = containsSeq;
    }

    public CellType getCellType() {
        return this._type;
    }

    public AggOp getAggOp() {
        return this._aggOp;
    }

    public boolean isSparseSafe() {
        return this._sparseSafe;
    }

    public boolean containsSeq() {
        return this._containsSeq;
    }

    @Override
    public SpoofCUDAOperator createCUDAInstrcution(Integer opID, SpoofCUDAOperator.PrecisionProxy ep) {
        return new SpoofCUDACellwise(this._type, this._sparseSafe, this._containsSeq, this._aggOp, opID, ep, this);
    }

    @Override
    public String getSpoofType() {
        return "Cell" + this.getClass().getName().split("\\.")[1];
    }

    private ValueFunction getAggFunction() {
        switch (this._aggOp) {
            case SUM: {
                return KahanPlus.getKahanPlusFnObject();
            }
            case SUM_SQ: {
                return KahanPlusSq.getKahanPlusSqFnObject();
            }
            case MIN: {
                return Builtin.getBuiltinFnObject(Builtin.BuiltinCode.MIN);
            }
            case MAX: {
                return Builtin.getBuiltinFnObject(Builtin.BuiltinCode.MAX);
            }
        }
        throw new RuntimeException("Unsupported aggregation type: " + this._aggOp.name());
    }

    @Override
    public ScalarObject execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, int k) {
        return this.execute(inputs, scalarObjects, k, 0L);
    }

    public ScalarObject execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, int k, long rix) {
        long inputSize;
        if (inputs == null || inputs.size() < 1) {
            throw new RuntimeException("Invalid input arguments.");
        }
        MatrixBlock a = inputs.get(0);
        if (a instanceof CompressedMatrixBlock) {
            a = CompressedMatrixBlock.getUncompressed(a);
        }
        SpoofOperator.SideInput[] b = this.prepInputMatrices(inputs);
        double[] scalars = SpoofCellwise.prepInputScalars(scalarObjects);
        int m = a.getNumRows();
        int n = a.getNumColumns();
        boolean sparseSafe = this.isSparseSafe() || b.length == 0 && this.genexec(0.0, b, scalars, m, n, 0, 0) == 0.0;
        long l = inputSize = sparseSafe ? SpoofCellwise.getTotalInputNnz(inputs) : SpoofCellwise.getTotalInputSize(inputs);
        if (inputSize < 0x100000L) {
            k = 1;
        }
        double ret = 0.0;
        if (k <= 1) {
            ret = !a.isInSparseFormat() ? this.executeDenseAndAgg(a.getDenseBlock(), b, scalars, m, n, sparseSafe, 0, m, rix) : this.executeSparseAndAgg(a.getSparseBlock(), b, scalars, m, n, sparseSafe, 0, m, rix);
        } else {
            ExecutorService pool = CommonThreadPool.get(k);
            try {
                ArrayList<ParAggTask> tasks = new ArrayList<ParAggTask>();
                int nk = UtilFunctions.roundToNext(Math.min(8 * k, m / 32), k);
                int blklen = (int)Math.ceil((double)m / (double)nk);
                int i = 0;
                while (i < nk & i * blklen < m) {
                    tasks.add(new ParAggTask(a, b, scalars, m, n, sparseSafe, i * blklen, Math.min((i + 1) * blklen, m)));
                    ++i;
                }
                List taskret = pool.invokeAll(tasks);
                ValueFunction vfun = this.getAggFunction();
                if (vfun instanceof KahanFunction) {
                    KahanObject kbuff = new KahanObject(0.0, 0.0);
                    KahanPlus kplus = KahanPlus.getKahanPlusFnObject();
                    for (Future task : taskret) {
                        kplus.execute2(kbuff, (Double)task.get());
                    }
                    ret = kbuff._sum;
                } else {
                    for (Future task : taskret) {
                        ret = vfun.execute(ret, (double)((Double)task.get()));
                    }
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
            finally {
                pool.shutdown();
            }
        }
        if ((this._aggOp == AggOp.MIN || this._aggOp == AggOp.MAX) && sparseSafe && a.getNonZeros() < (long)(a.getNumRows() * a.getNumColumns())) {
            ret = this.getAggFunction().execute(ret, 0.0);
        }
        return new DoubleObject(ret);
    }

    @Override
    public MatrixBlock execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out) {
        return this.execute(inputs, scalarObjects, out, 1, 0L);
    }

    @Override
    public MatrixBlock execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out, int k) {
        return this.execute(inputs, scalarObjects, out, k, 0L);
    }

    public MatrixBlock execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out, int k, long rix) {
        long lnnz;
        block23: {
            long inputSize;
            if (inputs == null || inputs.size() < 1 || out == null) {
                throw new RuntimeException("Invalid input arguments.");
            }
            MatrixBlock a = inputs.get(0);
            if (a instanceof CompressedMatrixBlock) {
                a = CompressedMatrixBlock.getUncompressed(a);
            }
            SpoofOperator.SideInput[] b = this.prepInputMatrices(inputs);
            double[] scalars = SpoofCellwise.prepInputScalars(scalarObjects);
            int m = a.getNumRows();
            int n = a.getNumColumns();
            boolean sparseSafe = this.isSparseSafe() || b.length == 0 && this.genexec(0.0, b, scalars, m, n, 0, 0) == 0.0;
            long l = inputSize = sparseSafe ? SpoofCellwise.getTotalInputNnz(inputs) : SpoofCellwise.getTotalInputSize(inputs);
            if (inputSize < 0x100000L) {
                k = 1;
            }
            boolean sparseOut = this._type == CellType.NO_AGG && sparseSafe && a.isInSparseFormat();
            switch (this._type) {
                case NO_AGG: {
                    out.reset(m, n, sparseOut);
                    break;
                }
                case ROW_AGG: {
                    out.reset(m, 1, false);
                    break;
                }
                case COL_AGG: {
                    out.reset(1, n, false);
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Invalid cell type: " + this._type);
                }
            }
            out.allocateBlock();
            lnnz = 0L;
            if (k <= 1) {
                lnnz = !inputs.get(0).isInSparseFormat() ? this.executeDense(a.getDenseBlock(), b, scalars, out, m, n, sparseSafe, 0, m, rix) : this.executeSparse(a.getSparseBlock(), b, scalars, out, m, n, sparseSafe, 0, m, rix);
                if (this._type == CellType.COL_AGG) {
                    lnnz = out.recomputeNonZeros();
                }
            } else {
                ExecutorService pool = CommonThreadPool.get(k);
                try {
                    ArrayList<ParExecTask> tasks = new ArrayList<ParExecTask>();
                    int nk = UtilFunctions.roundToNext(Math.min(8 * k, m / 32), k);
                    int blklen = (int)Math.ceil((double)m / (double)nk);
                    int i = 0;
                    while (i < nk & i * blklen < m) {
                        tasks.add(new ParExecTask(a, b, scalars, out, m, n, sparseSafe, i * blklen, Math.min((i + 1) * blklen, m)));
                        ++i;
                    }
                    List taskret = pool.invokeAll(tasks);
                    for (Future task : taskret) {
                        lnnz += ((Long)task.get()).longValue();
                    }
                    if (this._type != CellType.COL_AGG) break block23;
                    double[] c = out.getDenseBlockValues();
                    ValueFunction vfun = this.getAggFunction();
                    if (vfun instanceof KahanFunction) {
                        for (ParExecTask task : tasks) {
                            LibMatrixMult.vectAdd(task.getResult().getDenseBlockValues(), c, 0, 0, n);
                        }
                    } else {
                        for (ParExecTask task : tasks) {
                            double[] tmp = task.getResult().getDenseBlockValues();
                            for (int j = 0; j < n; ++j) {
                                c[j] = vfun.execute(c[j], tmp[j]);
                            }
                        }
                    }
                    lnnz = out.recomputeNonZeros();
                }
                catch (Exception ex) {
                    throw new DMLRuntimeException(ex);
                }
                finally {
                    pool.shutdown();
                }
            }
        }
        out.setNonZeros(lnnz);
        out.examSparsity();
        return out;
    }

    private long executeDense(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        DenseBlock c = out.getDenseBlock();
        SpoofOperator.SideInput[] lb = SpoofCellwise.createSparseSideInputs(b);
        if (this._type == CellType.NO_AGG) {
            return this.executeDenseNoAgg(a, lb, scalars, c, m, n, sparseSafe, rl, ru, rix);
        }
        if (this._type == CellType.ROW_AGG) {
            if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
                return this.executeDenseRowAggSum(a, lb, scalars, c, m, n, sparseSafe, rl, ru, rix);
            }
            if (this._aggOp == AggOp.PROD) {
                return this.executeDenseRowProd(a, lb, scalars, c, m, n, sparseSafe, rl, ru, rix);
            }
            return this.executeDenseRowAggMxx(a, lb, scalars, c, m, n, sparseSafe, rl, ru, rix);
        }
        if (this._type == CellType.COL_AGG) {
            if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
                return this.executeDenseColAggSum(a, lb, scalars, c, m, n, sparseSafe, rl, ru, rix);
            }
            if (this._aggOp == AggOp.PROD) {
                return this.executeDenseColProd(a, lb, scalars, c, m, n, sparseSafe, rl, ru, rix);
            }
            return this.executeDenseColAggMxx(a, lb, scalars, c, m, n, sparseSafe, rl, ru, rix);
        }
        return -1L;
    }

    private double executeDenseAndAgg(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        SpoofOperator.SideInput[] lb = SpoofCellwise.createSparseSideInputs(b);
        if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
            return this.executeDenseAggSum(a, lb, scalars, m, n, sparseSafe, rl, ru, rix);
        }
        return this.executeDenseAggMxx(a, lb, scalars, m, n, sparseSafe, rl, ru, rix);
    }

    private long executeSparse(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        if (sparseSafe && sblock == null) {
            return 0L;
        }
        SpoofOperator.SideInput[] lb = SpoofCellwise.createSparseSideInputs(b);
        if (this._type == CellType.NO_AGG) {
            if (out.isInSparseFormat()) {
                return this.executeSparseNoAggSparse(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru, rix);
            }
            return this.executeSparseNoAggDense(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru, rix);
        }
        if (this._type == CellType.ROW_AGG) {
            if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
                return this.executeSparseRowAggSum(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru, rix);
            }
            if (this._aggOp == AggOp.PROD) {
                return this.executeSparseRowProd(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru, rix);
            }
            return this.executeSparseRowAggMxx(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru, rix);
        }
        if (this._type == CellType.COL_AGG) {
            if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
                return this.executeSparseColAggSum(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru, rix);
            }
            if (this._aggOp == AggOp.PROD) {
                return this.executeSparseColProd(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru, rix);
            }
            return this.executeSparseColAggMxx(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru, rix);
        }
        return -1L;
    }

    private double executeSparseAndAgg(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        if (sparseSafe && sblock == null) {
            return 0.0;
        }
        SpoofOperator.SideInput[] lb = SpoofCellwise.createSparseSideInputs(b);
        if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
            return this.executeSparseAggSum(sblock, lb, scalars, m, n, sparseSafe, rl, ru, rix);
        }
        return this.executeSparseAggMxx(sblock, lb, scalars, m, n, sparseSafe, rl, ru, rix);
    }

    private long executeDenseNoAgg(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, DenseBlock c, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        long lnnz;
        block5: {
            block4: {
                lnnz = 0L;
                if (a != null || sparseSafe) break block4;
                for (int i = rl; i < ru; ++i) {
                    double[] cvals = c.values(i);
                    int cix = c.pos(i);
                    for (int j = 0; j < n; ++j) {
                        double d = this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                        cvals[cix + j] = d;
                        lnnz += d != 0.0 ? 1L : 0L;
                    }
                }
                break block5;
            }
            if (a == null) break block5;
            for (int i = rl; i < ru; ++i) {
                double[] avals = a.values(i);
                double[] cvals = c.values(i);
                int ix = a.pos(i);
                for (int j = 0; j < n; ++j) {
                    double aval = avals[ix + j];
                    if (aval == 0.0 && sparseSafe) continue;
                    double d = this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j);
                    cvals[ix + j] = d;
                    lnnz += d != 0.0 ? 1L : 0L;
                }
            }
        }
        return lnnz;
    }

    private long executeDenseRowAggSum(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, DenseBlock c, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        long lnnz;
        block5: {
            KahanObject kbuff;
            KahanFunction kplus;
            block4: {
                double[] lc = c.valuesAt(0);
                kplus = (KahanFunction)this.getAggFunction();
                kbuff = new KahanObject(0.0, 0.0);
                lnnz = 0L;
                if (a != null || sparseSafe) break block4;
                for (int i = rl; i < ru; ++i) {
                    kbuff.set(0.0, 0.0);
                    for (int j = 0; j < n; ++j) {
                        kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                    }
                    lc[i] = kbuff._sum;
                    lnnz += lc[i] != 0.0 ? 1L : 0L;
                }
                break block5;
            }
            if (a == null) break block5;
            for (int i = rl; i < ru; ++i) {
                kbuff.set(0.0, 0.0);
                double[] avals = a.values(i);
                int aix = a.pos(i);
                for (int j = 0; j < n; ++j) {
                    double aval = avals[aix + j];
                    if (aval == 0.0 && sparseSafe) continue;
                    kplus.execute2(kbuff, this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j));
                }
                lc[i] = kbuff._sum;
                lnnz += lc[i] != 0.0 ? 1L : 0L;
            }
        }
        return lnnz;
    }

    private long executeDenseRowAggMxx(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, DenseBlock c, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        long lnnz;
        block6: {
            ValueFunction vfun;
            double initialVal;
            block5: {
                double[] lc = c.valuesAt(0);
                initialVal = this._aggOp == AggOp.MIN ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                vfun = this.getAggFunction();
                lnnz = 0L;
                if (a != null || sparseSafe) break block5;
                for (int i = rl; i < ru; ++i) {
                    double tmp = initialVal;
                    for (int j = 0; j < n; ++j) {
                        tmp = vfun.execute(tmp, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                    }
                    lc[i] = tmp;
                    lnnz += lc[i] != 0.0 ? 1L : 0L;
                }
                break block6;
            }
            if (a == null) break block6;
            for (int i = rl; i < ru; ++i) {
                double tmp = initialVal;
                double[] avals = a.values(i);
                int aix = a.pos(i);
                for (int j = 0; j < n; ++j) {
                    double aval = avals[aix + j];
                    if (aval == 0.0 && sparseSafe) continue;
                    tmp = vfun.execute(tmp, this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j));
                }
                if (sparseSafe && UtilFunctions.containsZero(avals, aix, n)) {
                    tmp = vfun.execute(tmp, 0.0);
                }
                lnnz += (lc[i] = tmp) != 0.0 ? 1L : 0L;
            }
        }
        return lnnz;
    }

    private long executeDenseColAggSum(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, DenseBlock c, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        block5: {
            double[] corr;
            KahanObject kbuff;
            KahanFunction kplus;
            double[] lc;
            block4: {
                lc = c.valuesAt(0);
                kplus = (KahanFunction)this.getAggFunction();
                kbuff = new KahanObject(0.0, 0.0);
                corr = new double[n];
                if (a != null || sparseSafe) break block4;
                for (int i = rl; i < ru; ++i) {
                    for (int j = 0; j < n; ++j) {
                        kbuff.set(lc[j], corr[j]);
                        kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                        lc[j] = kbuff._sum;
                        corr[j] = kbuff._correction;
                    }
                }
                break block5;
            }
            if (a == null) break block5;
            for (int i = rl; i < ru; ++i) {
                double[] avals = a.values(i);
                int aix = a.pos(i);
                for (int j = 0; j < n; ++j) {
                    double aval = avals[aix + j];
                    if (aval == 0.0 && sparseSafe) continue;
                    kbuff.set(lc[j], corr[j]);
                    kplus.execute2(kbuff, this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j));
                    lc[j] = kbuff._sum;
                    corr[j] = kbuff._correction;
                }
            }
        }
        return -1L;
    }

    private long executeDenseColAggMxx(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, DenseBlock c, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        block7: {
            ValueFunction vfun;
            double[] lc;
            block6: {
                lc = c.valuesAt(0);
                double initialVal = this._aggOp == AggOp.MIN ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                vfun = this.getAggFunction();
                Arrays.fill(lc, initialVal);
                if (a != null || sparseSafe) break block6;
                for (int i = rl; i < ru; ++i) {
                    for (int j = 0; j < n; ++j) {
                        lc[j] = vfun.execute(lc[j], this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                    }
                }
                break block7;
            }
            if (a == null) break block7;
            int[] counts = new int[n];
            for (int i = rl; i < ru; ++i) {
                double[] avals = a.values(i);
                int aix = a.pos(i);
                for (int j = 0; j < n; ++j) {
                    double aval = avals[aix + j];
                    if (aval == 0.0 && sparseSafe) continue;
                    lc[j] = vfun.execute(lc[j], this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j));
                    int n2 = j;
                    counts[n2] = counts[n2] + 1;
                }
            }
            if (sparseSafe) {
                for (int j = 0; j < n; ++j) {
                    if (counts[j] == ru - rl) continue;
                    lc[j] = vfun.execute(lc[j], 0.0);
                }
            }
        }
        return -1L;
    }

    private double executeDenseAggSum(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        KahanObject kbuff;
        block5: {
            KahanFunction kplus;
            block4: {
                kplus = (KahanFunction)this.getAggFunction();
                kbuff = new KahanObject(0.0, 0.0);
                if (a != null || sparseSafe) break block4;
                for (int i = rl; i < ru; ++i) {
                    for (int j = 0; j < n; ++j) {
                        kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                    }
                }
                break block5;
            }
            if (a == null) break block5;
            for (int i = rl; i < ru; ++i) {
                double[] avals = a.values(i);
                int aix = a.pos(i);
                for (int j = 0; j < n; ++j) {
                    double aval = avals[aix + j];
                    if (aval == 0.0 && sparseSafe) continue;
                    kplus.execute2(kbuff, this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j));
                }
            }
        }
        return kbuff._sum;
    }

    private double executeDenseAggMxx(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        double ret;
        block5: {
            ValueFunction vfun;
            block4: {
                ret = this._aggOp == AggOp.MIN ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                vfun = this.getAggFunction();
                if (a != null || sparseSafe) break block4;
                for (int i = rl; i < ru; ++i) {
                    for (int j = 0; j < n; ++j) {
                        ret = vfun.execute(ret, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                    }
                }
                break block5;
            }
            if (a == null) break block5;
            for (int i = rl; i < ru; ++i) {
                double[] avals = a.values(i);
                int aix = a.pos(i);
                for (int j = 0; j < n; ++j) {
                    double aval = avals[aix + j];
                    if (aval == 0.0 && sparseSafe) continue;
                    ret = vfun.execute(ret, this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j));
                }
            }
        }
        return ret;
    }

    private long executeSparseNoAggSparse(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        SparseBlock c = out.getSparseBlock();
        long lnnz = 0L;
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                c.allocate(i, sparseSafe ? alen : n);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            c.append(i, j, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                        }
                    }
                    lastj = aix[k];
                    c.append(i, lastj, this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, lastj));
                }
            }
            if (!sparseSafe) {
                for (int j = lastj + 1; j < n; ++j) {
                    c.append(i, j, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                }
            }
            lnnz += (long)c.size(i);
        }
        return lnnz;
    }

    private long executeSparseNoAggDense(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        DenseBlock c = out.getDenseBlock();
        long lnnz = 0L;
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                double[] cvals = c.values(i);
                int cix = c.pos(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            double d = this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                            cvals[cix + j] = d;
                            lnnz += d != 0.0 ? 1L : 0L;
                        }
                    }
                    lastj = aix[k];
                    double d = this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, lastj);
                    cvals[cix + lastj] = d;
                    lnnz += d != 0.0 ? 1L : 0L;
                }
            }
            if (sparseSafe) continue;
            for (int j = lastj + 1; j < n; ++j) {
                double[] cvals = c.values(i);
                int cix = c.pos(i);
                double d = this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                cvals[cix + j] = d;
                lnnz += d != 0.0 ? 1L : 0L;
            }
        }
        return lnnz;
    }

    private long executeSparseRowAggSum(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        double[] c = out.getDenseBlockValues();
        long lnnz = 0L;
        for (int i = rl; i < ru; ++i) {
            kbuff.set(0.0, 0.0);
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                        }
                    }
                    lastj = aix[k];
                    kplus.execute2(kbuff, this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, lastj));
                }
            }
            if (!sparseSafe) {
                for (int j = lastj + 1; j < n; ++j) {
                    kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                }
            }
            lnnz += (c[i] = kbuff._sum) != 0.0 ? 1L : 0L;
        }
        return lnnz;
    }

    private long executeSparseRowAggMxx(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        double initialVal = this._aggOp == AggOp.MIN ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        ValueFunction vfun = this.getAggFunction();
        double[] c = out.getDenseBlockValues();
        long lnnz = 0L;
        for (int i = rl; i < ru; ++i) {
            double tmp = sparseSafe && sblock.size(i) < n ? 0.0 : initialVal;
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            tmp = vfun.execute(tmp, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                        }
                    }
                    lastj = aix[k];
                    tmp = vfun.execute(tmp, this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, lastj));
                }
            }
            if (!sparseSafe) {
                for (int j = lastj + 1; j < n; ++j) {
                    tmp = vfun.execute(tmp, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                }
            }
            lnnz += (c[i] = tmp) != 0.0 ? 1L : 0L;
        }
        return lnnz;
    }

    private long executeSparseColAggSum(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        double[] corr = new double[n];
        double[] c = out.getDenseBlockValues();
        for (int i = rl; i < ru; ++i) {
            kbuff.set(0.0, 0.0);
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            kbuff.set(c[j], corr[j]);
                            kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                            c[j] = kbuff._sum;
                            corr[j] = kbuff._correction;
                        }
                    }
                    lastj = aix[k];
                    kbuff.set(c[aix[k]], corr[aix[k]]);
                    kplus.execute2(kbuff, this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, lastj));
                    c[aix[k]] = kbuff._sum;
                    corr[aix[k]] = kbuff._correction;
                }
            }
            if (sparseSafe) continue;
            for (int j = lastj + 1; j < n; ++j) {
                kbuff.set(c[j], corr[j]);
                kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                c[j] = kbuff._sum;
                corr[j] = kbuff._correction;
            }
        }
        return -1L;
    }

    private long executeSparseColAggMxx(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        double initialVal = this._aggOp == AggOp.MIN ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        ValueFunction vfun = this.getAggFunction();
        double[] c = out.getDenseBlockValues();
        Arrays.fill(c, initialVal);
        int[] count = new int[n];
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        int j = lastj + 1;
                        while (j < aix[k]) {
                            c[j] = vfun.execute(c[j], this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                            int n2 = j++;
                            count[n2] = count[n2] + 1;
                        }
                    }
                    lastj = aix[k];
                    c[aix[k]] = vfun.execute(c[aix[k]], this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, lastj));
                    int n3 = aix[k];
                    count[n3] = count[n3] + 1;
                }
            }
            if (sparseSafe) continue;
            for (int j = lastj + 1; j < n; ++j) {
                c[j] = vfun.execute(c[j], this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
            }
        }
        return -1L;
    }

    private double executeSparseAggSum(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                        }
                    }
                    lastj = aix[k];
                    kplus.execute2(kbuff, this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, lastj));
                }
            }
            if (sparseSafe) continue;
            for (int j = lastj + 1; j < n; ++j) {
                kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
            }
        }
        return kbuff._sum;
    }

    private double executeSparseAggMxx(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        double ret = this._aggOp == AggOp.MIN ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        ret = sparseSafe && sblock.size() < (long)m * (long)n ? 0.0 : ret;
        ValueFunction vfun = this.getAggFunction();
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            ret = vfun.execute(ret, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
                        }
                    }
                    lastj = aix[k];
                    ret = vfun.execute(ret, this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, lastj));
                }
            }
            if (sparseSafe) continue;
            for (int j = lastj + 1; j < n; ++j) {
                ret = vfun.execute(ret, this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j));
            }
        }
        return ret;
    }

    private long executeDenseRowProd(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, DenseBlock c, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        long lnnz;
        block7: {
            double[] lc;
            block6: {
                lc = c.valuesAt(0);
                lnnz = 0L;
                if (a != null || sparseSafe) break block6;
                for (int i = rl; i < ru; ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (j == 0) {
                            lc[i] = this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                            continue;
                        }
                        if (lc[i] == 0.0) break;
                        int n2 = i;
                        lc[n2] = lc[n2] * this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                    }
                    lnnz += lc[i] != 0.0 ? 1L : 0L;
                }
                break block7;
            }
            if (a == null) break block7;
            for (int i = rl; i < ru; ++i) {
                double aval;
                double[] avals = a.values(i);
                int aix = a.pos(i);
                for (int j = 0; !(j >= n || (aval = avals[aix + j]) == 0.0 && sparseSafe); ++j) {
                    if (j == 0) {
                        lc[i] = this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j);
                        continue;
                    }
                    if (lc[i] == 0.0) break;
                    int n3 = i;
                    lc[n3] = lc[n3] * this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j);
                }
                lnnz += lc[i] != 0.0 ? 1L : 0L;
            }
        }
        return lnnz;
    }

    private long executeDenseColProd(DenseBlock a, SpoofOperator.SideInput[] b, double[] scalars, DenseBlock c, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        block10: {
            boolean[] zeroFlag;
            double[] lc;
            block9: {
                lc = c.valuesAt(0);
                zeroFlag = new boolean[n];
                if (a != null || sparseSafe) break block9;
                for (int i = rl; i < ru; ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (zeroFlag[j]) continue;
                        if (i == 0) {
                            lc[j] = this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                            continue;
                        }
                        if (lc[j] != 0.0) {
                            int n2 = j;
                            lc[n2] = lc[n2] * this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                            continue;
                        }
                        zeroFlag[j] = true;
                    }
                }
                break block10;
            }
            if (a == null) break block10;
            for (int i = rl; i < ru; ++i) {
                double[] avals = a.values(i);
                int aix = a.pos(i);
                for (int j = 0; j < n; ++j) {
                    if (!zeroFlag[j]) {
                        double aval = avals[aix + j];
                        if (aval == 0.0 && sparseSafe) continue;
                        if (i == 0) {
                            lc[j] = this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j);
                            continue;
                        }
                        if (lc[j] != 0.0) {
                            int n3 = j;
                            lc[n3] = lc[n3] * this.genexec(aval, b, scalars, m, n, rix + (long)i, i, j);
                            continue;
                        }
                        zeroFlag[j] = true;
                        continue;
                    }
                    zeroFlag[j] = true;
                }
            }
        }
        return -1L;
    }

    private long executeSparseRowProd(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        double[] c = out.getDenseBlockValues();
        long lnnz = 0L;
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            if (j == 0) {
                                c[i] = this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                                continue;
                            }
                            if (c[i] == 0.0) break;
                            int n2 = i;
                            c[n2] = c[n2] * this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                        }
                    }
                    if (aix.length != n && sparseSafe) break;
                    if (aix[k] == 0) {
                        lastj = aix[k];
                        c[i] = this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, k);
                        continue;
                    }
                    if (c[i] == 0.0) break;
                    lastj = aix[k];
                    int n3 = i;
                    c[n3] = c[n3] * this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, k);
                }
            }
            if (!sparseSafe) {
                for (int j = lastj + 1; j < n; ++j) {
                    if (j == 0) {
                        c[i] = this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                        continue;
                    }
                    if (c[i] == 0.0) break;
                    int n4 = i;
                    c[n4] = c[n4] * this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                }
            }
            lnnz += c[i] != 0.0 ? 1L : 0L;
        }
        return lnnz;
    }

    private long executeSparseColProd(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru, long rix) {
        double[] c = out.getDenseBlockValues();
        boolean[] zeroFlag = new boolean[n];
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                long nnzCount = sblock.size(rl, ru);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            if (zeroFlag[j]) continue;
                            if (i == 0) {
                                c[j] = this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                                continue;
                            }
                            if (c[j] != 0.0) {
                                int n2 = j;
                                c[n2] = c[n2] * this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                                continue;
                            }
                            zeroFlag[j] = true;
                        }
                    }
                    if (!(nnzCount != (long)m && sparseSafe || zeroFlag[aix[k]])) {
                        if (i == 0) {
                            lastj = aix[k];
                            c[aix[k]] = this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, lastj);
                            continue;
                        }
                        if (c[aix[k]] != 0.0) {
                            lastj = aix[k];
                            int n3 = aix[k];
                            c[n3] = c[n3] * this.genexec(avals[k], b, scalars, m, n, rix + (long)i, i, lastj);
                            continue;
                        }
                        zeroFlag[aix[k]] = true;
                        continue;
                    }
                    zeroFlag[aix[k]] = true;
                }
            }
            if (sparseSafe) continue;
            for (int j = lastj + 1; j < n; ++j) {
                if (zeroFlag[j]) continue;
                if (i == 0) {
                    c[j] = this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                    continue;
                }
                if (c[j] != 0.0) {
                    int n4 = j;
                    c[n4] = c[n4] * this.genexec(0.0, b, scalars, m, n, rix + (long)i, i, j);
                    continue;
                }
                zeroFlag[j] = true;
            }
        }
        return -1L;
    }

    protected final double genexec(double a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, int rix, int cix) {
        return this.genexec(a, b, scalars, m, n, rix, rix, cix);
    }

    protected abstract double genexec(double var1, SpoofOperator.SideInput[] var3, double[] var4, int var5, int var6, long var7, int var9, int var10);

    private class ParExecTask
    implements Callable<Long> {
        private final MatrixBlock _a;
        private final SpoofOperator.SideInput[] _b;
        private final double[] _scalars;
        private MatrixBlock _c;
        private final int _rlen;
        private final int _clen;
        private final boolean _safe;
        private final int _rl;
        private final int _ru;

        protected ParExecTask(MatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock c, int rlen, int clen, boolean sparseSafe, int rl, int ru) {
            this._a = a;
            this._b = b;
            this._scalars = scalars;
            this._c = c;
            this._rlen = rlen;
            this._clen = clen;
            this._safe = sparseSafe;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Long call() {
            if (SpoofCellwise.this._type == CellType.COL_AGG) {
                this._c = new MatrixBlock(1, this._clen, false);
                this._c.allocateDenseBlock();
            }
            if (!this._a.isInSparseFormat()) {
                return SpoofCellwise.this.executeDense(this._a.getDenseBlock(), this._b, this._scalars, this._c, this._rlen, this._clen, this._safe, this._rl, this._ru, 0L);
            }
            return SpoofCellwise.this.executeSparse(this._a.getSparseBlock(), this._b, this._scalars, this._c, this._rlen, this._clen, this._safe, this._rl, this._ru, 0L);
        }

        public MatrixBlock getResult() {
            return this._c;
        }
    }

    private class ParAggTask
    implements Callable<Double> {
        private final MatrixBlock _a;
        private final SpoofOperator.SideInput[] _b;
        private final double[] _scalars;
        private final int _rlen;
        private final int _clen;
        private final boolean _safe;
        private final int _rl;
        private final int _ru;

        protected ParAggTask(MatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, int rlen, int clen, boolean sparseSafe, int rl, int ru) {
            this._a = a;
            this._b = b;
            this._scalars = scalars;
            this._rlen = rlen;
            this._clen = clen;
            this._safe = sparseSafe;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Double call() {
            if (!this._a.isInSparseFormat()) {
                return SpoofCellwise.this.executeDenseAndAgg(this._a.getDenseBlock(), this._b, this._scalars, this._rlen, this._clen, this._safe, this._rl, this._ru, 0L);
            }
            return SpoofCellwise.this.executeSparseAndAgg(this._a.getSparseBlock(), this._b, this._scalars, this._rlen, this._clen, this._safe, this._rl, this._ru, 0L);
        }
    }

    public static enum AggOp {
        SUM,
        SUM_SQ,
        MIN,
        MAX,
        PROD;

    }

    public static enum CellType {
        NO_AGG(0),
        FULL_AGG(1),
        ROW_AGG(2),
        COL_AGG(3);

        private final int value;
        private static final HashMap<Integer, CellType> map;

        private CellType(int value) {
            this.value = value;
        }

        public static CellType valueOf(int cellType) {
            return map.get(cellType);
        }

        public int getValue() {
            return this.value;
        }

        static {
            map = new HashMap();
            for (CellType cellType : CellType.values()) {
                map.put(cellType.value, cellType);
            }
        }
    }
}

