/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.scripting.CompositeResolver;
import org.flowable.common.engine.impl.scripting.Resolver;
import org.flowable.common.engine.impl.scripting.ResolverFactory;
import org.flowable.common.engine.impl.scripting.ScriptEngineRequest;

public class ScriptBindingsFactory {
    protected AbstractEngineConfiguration engineConfiguration;
    protected List<ResolverFactory> resolverFactories;

    public ScriptBindingsFactory(AbstractEngineConfiguration engineConfiguration, List<ResolverFactory> resolverFactories) {
        this.engineConfiguration = engineConfiguration;
        this.resolverFactories = resolverFactories;
    }

    public Resolver createResolver(ScriptEngineRequest request) {
        ArrayList<Resolver> scriptResolvers = new ArrayList<Resolver>();
        scriptResolvers.addAll(request.getAdditionalResolvers());
        for (ResolverFactory scriptResolverFactory : this.resolverFactories) {
            Resolver resolver = scriptResolverFactory.createResolver(this.engineConfiguration, request.getScopeContainer(), request.getInputVariableContainer());
            if (resolver == null) continue;
            scriptResolvers.add(resolver);
        }
        return new CompositeResolver(scriptResolvers);
    }

    public List<ResolverFactory> getResolverFactories() {
        return this.resolverFactories;
    }

    public void setResolverFactories(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }
}

