/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.rest.api.beans.AbstractQuery;
import org.apache.syncope.common.rest.api.beans.AuthProfileQuery;
import org.apache.syncope.common.rest.api.service.AuthProfileService;
import org.apache.syncope.core.logic.AuthProfileLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.data.domain.Page;

public class AuthProfileServiceImpl
extends AbstractService
implements AuthProfileService {
    protected final AuthProfileLogic logic;

    public AuthProfileServiceImpl(AuthProfileLogic logic) {
        this.logic = logic;
    }

    public PagedResult<AuthProfileTO> search(AuthProfileQuery query) {
        String keyword = query.getKeyword() == null ? "%" : query.getKeyword().replace('*', '%');
        Page result = this.logic.search(keyword, AuthProfileServiceImpl.pageable((AbstractQuery)query));
        return this.buildPagedResult(result);
    }

    public AuthProfileTO read(String key) {
        return this.logic.read(key);
    }

    public Response create(AuthProfileTO authProfileTO) {
        AuthProfileTO created = this.logic.create(authProfileTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created.getKey()).build();
    }

    public void update(AuthProfileTO authProfileTO) {
        this.logic.update(authProfileTO);
    }

    public void delete(String key) {
        this.logic.delete(key);
    }
}

