/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.proc.SimpleSecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20TokenExchangeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthTokenExchangePolicy;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.BaseOAuth20TokenRequestValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class OAuth20TokenExchangeGrantTypeTokenRequestValidator<T extends OAuth20ConfigurationContext>
extends BaseOAuth20TokenRequestValidator<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TokenExchangeGrantTypeTokenRequestValidator.class);
    private static final Set<String> JWT_TOKEN_TYPE_REQUIRED_CLAIMS = Set.of("iss", "aud", "sub", "exp", "iat", "nbf");
    private final JWTClaimsSetVerifier jwtClaimsSetVerifier = new DefaultJWTClaimsVerifier(null, JWT_TOKEN_TYPE_REQUIRED_CLAIMS);

    public OAuth20TokenExchangeGrantTypeTokenRequestValidator(ObjectProvider<T> configurationContext) {
        super(configurationContext);
    }

    @Override
    protected boolean validateInternal(WebContext webContext, String grantType, ProfileManager manager, UserProfile uProfile) throws Throwable {
        OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
        OAuth20RequestParameterResolver requestParameterResolver = configurationContext.getRequestParameterResolver();
        String subjectTokenType = (String)requestParameterResolver.resolveRequestParameter(webContext, "subject_token_type").orElseThrow(() -> new IllegalArgumentException("Subject token type cannot be undefined"));
        String subjectToken = (String)requestParameterResolver.resolveRequestParameter(webContext, "subject_token").orElseThrow(() -> new IllegalArgumentException("Subject token cannot be undefined"));
        String requestedTokenType = requestParameterResolver.resolveRequestParameter(webContext, "requested_token_type").orElseGet(() -> ((OAuth20TokenExchangeTypes)OAuth20TokenExchangeTypes.ACCESS_TOKEN).getType());
        OAuthRegisteredService registeredService = this.extractRegisteredService(subjectTokenType, subjectToken);
        AuditableContext audit = AuditableContext.builder().registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult accessResult = configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
        if (!this.isGrantTypeSupportedBy(registeredService, this.getGrantType().getType(), true)) {
            LOGGER.warn("Requested grant type [{}] is not authorized by service definition [{}]", (Object)grantType, (Object)Objects.requireNonNull(registeredService).getServiceId());
            return false;
        }
        Optional actorToken = requestParameterResolver.resolveRequestParameter(webContext, "actor_token");
        Optional<OAuth20TokenExchangeTypes> actorTokenType = requestParameterResolver.resolveRequestParameter(webContext, "actor_token_type").map(OAuth20TokenExchangeTypes::from);
        FunctionUtils.throwIf((actorToken.isPresent() && actorTokenType.isEmpty() ? 1 : 0) != 0, () -> new IllegalArgumentException("Actor token type cannot be undefined when actor token is provided"));
        Map resourceAndAudience = requestParameterResolver.resolveRequestParameters(List.of("resource", "audience"), webContext);
        Set resources = resourceAndAudience.getOrDefault("resource", Set.of());
        Set audience = resourceAndAudience.getOrDefault("audience", Set.of());
        RegisteredServiceOAuthTokenExchangePolicy tokenExchangePolicy = registeredService.getTokenExchangePolicy();
        return tokenExchangePolicy == null || tokenExchangePolicy.isTokenExchangeAllowed((RegisteredService)registeredService, resources, audience, requestedTokenType);
    }

    protected OAuthRegisteredService extractRegisteredService(String subjectTokenType, String subjectToken) throws Exception {
        OAuth20ConfigurationContext configurationContext = (OAuth20ConfigurationContext)this.getConfigurationContext().getObject();
        return switch (OAuth20TokenExchangeTypes.from((String)subjectTokenType)) {
            case OAuth20TokenExchangeTypes.ACCESS_TOKEN -> {
                OAuth20AccessToken accessToken = (OAuth20AccessToken)configurationContext.getTicketRegistry().getTicket(subjectToken, OAuth20AccessToken.class);
                yield OAuth20Utils.getRegisteredOAuthServiceByClientId(configurationContext.getServicesManager(), accessToken.getClientId());
            }
            case OAuth20TokenExchangeTypes.JWT -> {
                JWTClaimsSet claimSet = configurationContext.getAccessTokenJwtBuilder().unpack(Optional.empty(), subjectToken);
                this.jwtClaimsSetVerifier.verify(claimSet, (SecurityContext)new SimpleSecurityContext());
                WebApplicationService service = (WebApplicationService)configurationContext.getWebApplicationServiceServiceFactory().createService(claimSet.getIssuer());
                service.getAttributes().put("client_id", List.of(claimSet.getSubject()));
                yield OAuth20Utils.getRegisteredOAuthServiceByClientId(configurationContext.getServicesManager(), claimSet.getSubject());
            }
            default -> throw new IllegalArgumentException("Subject token type %s is not supported".formatted(subjectTokenType));
        };
    }

    @Override
    protected OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.TOKEN_EXCHANGE;
    }
}

