/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator;

import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuth20ClientSecretValidator
implements OAuth20ClientSecretValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth20ClientSecretValidator.class);
    private final CipherExecutor<Serializable, String> cipherExecutor;

    public boolean validate(OAuthRegisteredService registeredService, String clientSecret) {
        if (this.isClientSecretUndefined(registeredService)) {
            LOGGER.debug("The client secret is not defined for the registered service [{}]", (Object)registeredService.getName());
            return true;
        }
        String clientSecretDecoded = EncodingUtils.urlDecode((String)clientSecret);
        String clientSecretAssigned = SpringExpressionLanguageValueResolver.getInstance().resolve(registeredService.getClientSecret());
        String definedSecret = (String)this.cipherExecutor.decode((Object)clientSecretAssigned, new Object[]{registeredService});
        if (!Strings.CI.equals(definedSecret, clientSecretDecoded)) {
            LOGGER.error("Wrong client secret for service: [{}]. If you intend to use PKCE, note that it does not require a client secret and requests generally must not specify a client secret to CAS.\nFurthermore, you must make sure no client secret is assigned to this registered service in the CAS service registry.", (Object)registeredService.getServiceId());
            return false;
        }
        return true;
    }

    public boolean isClientSecretExpired(OAuthRegisteredService registeredService) {
        return false;
    }

    protected boolean isClientSecretUndefined(OAuthRegisteredService registeredService) {
        return registeredService != null && StringUtils.isBlank((CharSequence)registeredService.getClientSecret());
    }

    @Generated
    public DefaultOAuth20ClientSecretValidator(CipherExecutor<Serializable, String> cipherExecutor) {
        this.cipherExecutor = cipherExecutor;
    }

    @Generated
    public CipherExecutor<Serializable, String> getCipherExecutor() {
        return this.cipherExecutor;
    }
}

