/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.io.Serializable;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.PasswordHistoryService;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.impl.NoOpPasswordManagementService;
import org.apereo.cas.syncope.pm.SyncopePasswordManagementService;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PasswordManagement}, module="syncope")
@ConditionalOnClass(value={PasswordManagementService.class})
@Configuration(value="SyncopePasswordManagementConfiguration", proxyBeanMethods=false)
class SyncopePasswordManagementConfiguration {
    SyncopePasswordManagementConfiguration() {
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"syncopePasswordChangeService"})
    public PasswordManagementService passwordChangeService(CasConfigurationProperties casProperties, @Qualifier(value="passwordManagementCipherExecutor") CipherExecutor passwordManagementCipherExecutor, @Qualifier(value="passwordHistoryService") PasswordHistoryService passwordHistoryService) {
        PasswordManagementProperties pm = casProperties.getAuthn().getPm();
        return pm.getCore().isEnabled() && pm.getSyncope().isDefined() ? new SyncopePasswordManagementService((CipherExecutor<Serializable, String>)passwordManagementCipherExecutor, casProperties, passwordHistoryService) : new NoOpPasswordManagementService(passwordManagementCipherExecutor, casProperties);
    }
}

