/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow.account;

import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.CoreGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;

public class GoogleMultifactorAuthenticationAccountProfilePrepareAction
extends ConsumerExecutionAction {
    public GoogleMultifactorAuthenticationAccountProfilePrepareAction(OneTimeTokenCredentialRepository repository, MultifactorAuthenticationProvider googleAuthenticatorMultifactorAuthenticationProvider, CasConfigurationProperties casProperties, TenantExtractor tenantExtractor) {
        super(requestContext -> {
            Boolean multipleDeviceRegistrationEnabled = tenantExtractor.extract(requestContext).filter(tenantDefinition -> !tenantDefinition.getProperties().isEmpty()).map(TenantDefinition::bindProperties).filter(ConfigurationPropertiesBindingContext::isBound).filter(bindingContext -> bindingContext.containsBindingFor(CoreGoogleAuthenticatorMultifactorProperties.class)).map(ConfigurationPropertiesBindingContext::value).map(properties -> properties.getAuthn().getMfa().getGauth().getCore().isMultipleDeviceRegistrationEnabled()).orElseGet(() -> casProperties.getAuthn().getMfa().getGauth().getCore().isMultipleDeviceRegistrationEnabled());
            Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
            boolean enabled = (multipleDeviceRegistrationEnabled != false || repository.count(principal.getId()) == 0L) && MultifactorAuthenticationWebflowUtils.isMultifactorDeviceRegistrationEnabled((RequestContext)requestContext);
            requestContext.getFlowScope().put("gauthAccountProfileRegistrationEnabled", (Object)enabled);
            MultifactorAuthenticationWebflowUtils.putMultifactorAuthenticationProvider((RequestContext)requestContext, (MultifactorAuthenticationProvider)googleAuthenticatorMultifactorAuthenticationProvider);
        });
    }
}

