/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.cipher;

import java.util.Optional;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.util.cipher.BaseStringCipherExecutor;

public class JwtTicketCipherExecutor
extends BaseStringCipherExecutor {
    public JwtTicketCipherExecutor() {
        this(null, null, null, false, false, 0, 0);
    }

    public JwtTicketCipherExecutor(String secretKeyEncryption, String secretKeySigning, String contentEncryptionAlgorithmIdentifier, boolean encryptionEnabled, boolean signingEnabled, int signingKeySize, int encryptionKeySize) {
        super(secretKeyEncryption, secretKeySigning, contentEncryptionAlgorithmIdentifier, encryptionEnabled, signingEnabled, signingKeySize, encryptionKeySize);
    }

    public JwtTicketCipherExecutor(String secretKeyEncryption, String secretKeySigning, String contentEncryptionAlgorithmIdentifier, boolean encryptionEnabled, int signingKeySize, int encryptionKeySize) {
        this(secretKeyEncryption, secretKeySigning, contentEncryptionAlgorithmIdentifier, encryptionEnabled, true, signingKeySize, encryptionKeySize);
    }

    public JwtTicketCipherExecutor(String secretKeyEncryption, String secretKeySigning, boolean encryptionEnabled, int signingKeySize, int encryptionKeySize) {
        super(secretKeyEncryption, secretKeySigning, encryptionEnabled, signingKeySize, encryptionKeySize);
    }

    public JwtTicketCipherExecutor(String secretKeyEncryption, String secretKeySigning, boolean encryptionEnabled, boolean signingEnabled, int signingKeySize, int encryptionKeySize) {
        super(secretKeyEncryption, secretKeySigning, encryptionEnabled, signingEnabled, signingKeySize, encryptionKeySize);
    }

    public String getEncryptionKeySetting() {
        return "cas.authn.token.crypto.encryption.key";
    }

    public String getSigningKeySetting() {
        return "cas.authn.token.crypto.signing.key";
    }

    public String getName() {
        return "Token/JWT Tickets";
    }

    protected Optional<BaseStringCipherExecutor.CipherOperationsStrategyType> getCipherOperationsStrategyType(RegisteredService registeredService) {
        RegisteredServiceProperty.RegisteredServiceProperties property = this.getCipherStrategyTypeRegisteredServiceProperty(registeredService);
        if (property.isAssignedTo(registeredService)) {
            String order = property.getPropertyValue(registeredService).value();
            return Optional.of(BaseStringCipherExecutor.CipherOperationsStrategyType.valueOf((String)order));
        }
        return Optional.empty();
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherStrategyTypeRegisteredServiceProperty(RegisteredService registeredService) {
        return RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_AS_SERVICE_TICKET_CIPHER_STRATEGY_TYPE;
    }
}

