/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NewTopicTest {
    public static final String TEST_TOPIC = "testtopic";
    public static final int NUM_PARTITIONS = 3;
    public static final short REPLICATION_FACTOR = 1;
    public static final String CLEANUP_POLICY_CONFIG_KEY = "cleanup.policy";
    public static final String CLEANUP_POLICY_CONFIG_VALUE = "compact";
    public static final List<Integer> BROKER_IDS = Arrays.asList(1, 2);

    @Test
    public void testConstructorWithPartitionsAndReplicationFactor() {
        NewTopic topic = new NewTopic(TEST_TOPIC, 3, 1);
        Assertions.assertEquals((Object)TEST_TOPIC, (Object)topic.name());
        Assertions.assertEquals((int)3, (int)topic.numPartitions());
        Assertions.assertEquals((short)1, (short)topic.replicationFactor());
        Assertions.assertNull((Object)topic.replicasAssignments());
    }

    @Test
    public void testConstructorWithOptionalValues() {
        Optional numPartitions = Optional.empty();
        Optional replicationFactor = Optional.empty();
        NewTopic topic = new NewTopic(TEST_TOPIC, numPartitions, replicationFactor);
        Assertions.assertEquals((Object)TEST_TOPIC, (Object)topic.name());
        Assertions.assertEquals((int)-1, (int)topic.numPartitions());
        Assertions.assertEquals((short)-1, (short)topic.replicationFactor());
        Assertions.assertNull((Object)topic.replicasAssignments());
    }

    @Test
    public void testConstructorWithReplicasAssignments() {
        HashMap<Integer, List<Integer>> replicasAssignments = new HashMap<Integer, List<Integer>>();
        replicasAssignments.put(0, BROKER_IDS);
        NewTopic newTopic = new NewTopic(TEST_TOPIC, replicasAssignments);
        Assertions.assertEquals((Object)TEST_TOPIC, (Object)newTopic.name());
        Assertions.assertEquals((int)-1, (int)newTopic.numPartitions());
        Assertions.assertEquals((short)-1, (short)newTopic.replicationFactor());
        Assertions.assertEquals(replicasAssignments, (Object)newTopic.replicasAssignments());
    }

    @Test
    public void testConfigsNotNull() {
        NewTopic newTopic = new NewTopic(TEST_TOPIC, 3, 1);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put(CLEANUP_POLICY_CONFIG_KEY, CLEANUP_POLICY_CONFIG_VALUE);
        newTopic.configs(configs);
        Assertions.assertEquals(configs, (Object)newTopic.configs());
    }

    @Test
    public void testConfigsNull() {
        NewTopic newTopic = new NewTopic(TEST_TOPIC, 3, 1);
        Assertions.assertNull((Object)newTopic.configs());
    }

    @Test
    public void testUnmodifiableReplicasAssignments() {
        HashMap<Integer, List<Integer>> replicasAssignments = new HashMap<Integer, List<Integer>>();
        replicasAssignments.put(0, BROKER_IDS);
        NewTopic newTopic = new NewTopic(TEST_TOPIC, replicasAssignments);
        Map returnedAssignments = newTopic.replicasAssignments();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> returnedAssignments.put(1, Arrays.asList(3, 4)));
    }

    @Test
    public void testConvertToCreatableTopicWithPartitionsAndReplicationFactor() {
        NewTopic newTopic = new NewTopic(TEST_TOPIC, 3, 1);
        CreateTopicsRequestData.CreatableTopic creatableTopic = newTopic.convertToCreatableTopic();
        Assertions.assertEquals((Object)TEST_TOPIC, (Object)creatableTopic.name());
        Assertions.assertTrue((creatableTopic.numPartitions() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)creatableTopic.numPartitions());
        Assertions.assertTrue((creatableTopic.replicationFactor() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((short)1, (short)creatableTopic.replicationFactor());
    }

    @Test
    public void testConvertToCreatableTopicWithReplicasAssignments() {
        int partitionIndex = 0;
        HashMap<Integer, List<Integer>> replicasAssignments = new HashMap<Integer, List<Integer>>();
        replicasAssignments.put(partitionIndex, BROKER_IDS);
        NewTopic topic = new NewTopic(TEST_TOPIC, replicasAssignments);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put(CLEANUP_POLICY_CONFIG_KEY, CLEANUP_POLICY_CONFIG_VALUE);
        topic.configs(configs);
        CreateTopicsRequestData.CreatableTopic creatableTopic = topic.convertToCreatableTopic();
        Assertions.assertEquals((Object)TEST_TOPIC, (Object)creatableTopic.name());
        Assertions.assertEquals((int)-1, (int)creatableTopic.numPartitions());
        Assertions.assertEquals((short)-1, (short)creatableTopic.replicationFactor());
        Assertions.assertNotNull((Object)creatableTopic.assignments());
        Assertions.assertEquals((int)1, (int)creatableTopic.assignments().size());
        CreateTopicsRequestData.CreatableReplicaAssignmentCollection assignmentsCollection = creatableTopic.assignments();
        CreateTopicsRequestData.CreatableReplicaAssignment assignment = assignmentsCollection.find(partitionIndex);
        Assertions.assertEquals((int)partitionIndex, (int)assignment.partitionIndex());
        Assertions.assertEquals(BROKER_IDS, (Object)assignment.brokerIds());
        Assertions.assertNotNull((Object)creatableTopic.configs());
        Assertions.assertEquals((int)1, (int)creatableTopic.configs().size());
        CreateTopicsRequestData.CreatableTopicConfig config = creatableTopic.configs().find(CLEANUP_POLICY_CONFIG_KEY);
        Assertions.assertEquals((Object)CLEANUP_POLICY_CONFIG_KEY, (Object)config.name());
        Assertions.assertEquals((Object)CLEANUP_POLICY_CONFIG_VALUE, (Object)config.value());
    }

    @Test
    public void testToString() {
        NewTopic topic1 = new NewTopic(TEST_TOPIC, 3, 1);
        String expected1 = "(name=testtopic, numPartitions=3, replicationFactor=1, replicasAssignments=null, configs=null)";
        Assertions.assertEquals((Object)expected1, (Object)topic1.toString());
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put(CLEANUP_POLICY_CONFIG_KEY, CLEANUP_POLICY_CONFIG_VALUE);
        topic1.configs(configs);
        String expected2 = "(name=testtopic, numPartitions=3, replicationFactor=1, replicasAssignments=null, configs={cleanup.policy=compact})";
        Assertions.assertEquals((Object)expected2, (Object)topic1.toString());
        int partitionIndex = 0;
        HashMap<Integer, List<Integer>> replicasAssignments = new HashMap<Integer, List<Integer>>();
        replicasAssignments.put(partitionIndex, BROKER_IDS);
        NewTopic topic2 = new NewTopic(TEST_TOPIC, replicasAssignments);
        String expected3 = "(name=testtopic, numPartitions=default, replicationFactor=default, replicasAssignments={" + partitionIndex + "=" + BROKER_IDS + "}, configs=null)";
        Assertions.assertEquals((Object)expected3, (Object)topic2.toString());
    }

    @Test
    public void testEqualsAndHashCode() {
        NewTopic topic1 = new NewTopic(TEST_TOPIC, 3, 1);
        NewTopic topic2 = new NewTopic(TEST_TOPIC, 3, 1);
        NewTopic topic3 = new NewTopic("another-topic", 3, 1);
        Assertions.assertEquals((Object)topic1, (Object)topic2);
        Assertions.assertNotEquals((Object)topic1, (Object)topic3);
        Assertions.assertEquals((int)topic1.hashCode(), (int)topic2.hashCode());
        Assertions.assertNotEquals((int)topic1.hashCode(), (int)topic3.hashCode());
    }
}

