/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token.ciba;

import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.ticket.OidcCibaRequest;
import org.apereo.cas.oidc.ticket.OidcCibaRequestFactory;
import org.apereo.cas.services.OidcBackchannelTokenDeliveryModes;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.BaseOAuth20TokenRequestValidator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class OidcAccessTokenCibaGrantRequestValidator
extends BaseOAuth20TokenRequestValidator<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAccessTokenCibaGrantRequestValidator.class);
    private final int order = Integer.MAX_VALUE;

    public OidcAccessTokenCibaGrantRequestValidator(ObjectProvider<OidcConfigurationContext> configurationContext) {
        super(configurationContext);
    }

    protected boolean validateInternal(WebContext context, String grantType, ProfileManager manager, UserProfile userProfile) {
        OidcRegisteredService registeredService;
        OidcBackchannelTokenDeliveryModes deliveryMode;
        OidcConfigurationContext configurationContext = (OidcConfigurationContext)((Object)this.getConfigurationContext().getObject());
        String authRequestId = (String)configurationContext.getRequestParameterResolver().resolveRequestParameter(context, "auth_req_id").orElseThrow();
        OidcCibaRequestFactory cibaFactory = (OidcCibaRequestFactory)configurationContext.getTicketFactory().get(OidcCibaRequest.class);
        String decodedId = cibaFactory.decodeId(authRequestId);
        OidcCibaRequest ticket = (OidcCibaRequest)configurationContext.getTicketRegistry().getTicket(decodedId, OidcCibaRequest.class);
        boolean result = ticket != null && !ticket.isExpired() && ticket.isReady();
        LOGGER.debug("CIBA authentication request is [{}]", (Object)BooleanUtils.toString((boolean)result, (String)"valid", (String)"invalid"));
        if (result && (deliveryMode = OidcBackchannelTokenDeliveryModes.valueOf((String)(registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)configurationContext.getServicesManager(), (String)ticket.getClientId(), OidcRegisteredService.class)).getBackchannelTokenDeliveryMode().toUpperCase(Locale.ENGLISH))) != OidcBackchannelTokenDeliveryModes.POLL && deliveryMode != OidcBackchannelTokenDeliveryModes.PING) {
            LOGGER.warn("Backchannel token delivery mode cannot grant access tokens");
            return false;
        }
        return result;
    }

    public boolean supports(WebContext context) {
        Optional authRequestId = ((OidcConfigurationContext)((Object)this.getConfigurationContext().getObject())).getRequestParameterResolver().resolveRequestParameter(context, "auth_req_id");
        return super.supports(context) && authRequestId.isPresent();
    }

    protected OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.CIBA;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }
}

