/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token.ciba;

import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.ticket.OidcCibaRequest;
import org.apereo.cas.oidc.ticket.OidcCibaRequestFactory;
import org.apereo.cas.oidc.token.ciba.InvalidCibaRequestException;
import org.apereo.cas.services.OidcBackchannelTokenDeliveryModes;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class AccessTokenCibaGrantRequestExtractor
extends BaseAccessTokenGrantRequestExtractor<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenCibaGrantRequestExtractor.class);

    public AccessTokenCibaGrantRequestExtractor(ObjectProvider<OidcConfigurationContext> configurationContext) {
        super(configurationContext);
    }

    protected AccessTokenRequestContext extractRequest(WebContext context) throws Throwable {
        OidcConfigurationContext configurationContext = (OidcConfigurationContext)((Object)this.getConfigurationContext().getObject());
        ProfileManager manager = new ProfileManager(context, configurationContext.getSessionStore());
        UserProfile profile = (UserProfile)manager.getProfile().orElseThrow(() -> UnauthorizedServiceException.denied((String)"OAuth user profile cannot be determined"));
        String clientId = profile.getAttribute("client_id").toString();
        LOGGER.debug("Locating OAuth registered service by client id [{}]", (Object)clientId);
        OidcRegisteredService registeredService = (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)configurationContext.getServicesManager(), (String)clientId, OidcRegisteredService.class);
        LOGGER.debug("Located registered service [{}]", (Object)registeredService);
        String authRequestId = (String)configurationContext.getRequestParameterResolver().resolveRequestParameter(context, "auth_req_id").orElseThrow();
        Service service = configurationContext.getAuthenticationBuilder().buildService((OAuthRegisteredService)registeredService, context, true);
        OidcCibaRequestFactory cibaFactory = (OidcCibaRequestFactory)configurationContext.getTicketFactory().get(OidcCibaRequest.class);
        String decodedId = cibaFactory.decodeId(authRequestId);
        OidcCibaRequest cibaRequest = (OidcCibaRequest)configurationContext.getTicketRegistry().getTicket(decodedId, OidcCibaRequest.class);
        AuditableContext audit = AuditableContext.builder().service(service).registeredService((RegisteredService)registeredService).authentication(cibaRequest.getAuthentication()).build();
        AuditableExecutionResult accessResult = configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
        if (!registeredService.getSupportedGrantTypes().contains(this.getGrantType().getType()) || StringUtils.isBlank((CharSequence)registeredService.getBackchannelClientNotificationEndpoint()) || StringUtils.isBlank((CharSequence)registeredService.getBackchannelTokenDeliveryMode())) {
            throw new InvalidCibaRequestException("Registered OpenID Connect relying party does not support backchannel authentication requests");
        }
        OidcBackchannelTokenDeliveryModes deliveryMode = OidcBackchannelTokenDeliveryModes.valueOf((String)registeredService.getBackchannelTokenDeliveryMode().toUpperCase(Locale.ENGLISH));
        if (deliveryMode != OidcBackchannelTokenDeliveryModes.POLL && deliveryMode != OidcBackchannelTokenDeliveryModes.PING) {
            throw new InvalidCibaRequestException("Backchannel token delivery mode cannot grant access tokens");
        }
        if (!cibaRequest.isReady()) {
            throw new InvalidCibaRequestException("CIBA request %s is not ready to grant access tokens".formatted(authRequestId));
        }
        return AccessTokenRequestContext.builder().service(service).authentication(cibaRequest.getAuthentication()).registeredService((OAuthRegisteredService)registeredService).responseType(this.getResponseType()).grantType(this.getGrantType()).scopes(cibaRequest.getScopes()).userProfile(profile).clientId(registeredService.getClientId()).generateRefreshToken(registeredService.isGenerateRefreshToken()).build();
    }

    public boolean supports(WebContext context) {
        OidcConfigurationContext configurationContext = (OidcConfigurationContext)((Object)this.getConfigurationContext().getObject());
        String grantType = configurationContext.getRequestParameterResolver().resolveRequestParameter(context, "grant_type").orElse("");
        Optional authRequestId = configurationContext.getRequestParameterResolver().resolveRequestParameter(context, "auth_req_id");
        return OAuth20Utils.isGrantType((String)grantType, (OAuth20GrantTypes)this.getGrantType()) && authRequestId.isPresent();
    }

    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.CIBA;
    }

    public OAuth20ResponseTypes getResponseType() {
        return OAuth20ResponseTypes.NONE;
    }

    public boolean requestMustBeAuthenticated() {
        return true;
    }
}

