/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.OAuth20TokenExchangeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenTokenExchangeGrantRequestExtractor;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessTokenFactory;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jose4j.jwt.JwtClaims;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.util.Assert;

public class OidcAccessTokenTokenExchangeGrantRequestExtractor
extends AccessTokenTokenExchangeGrantRequestExtractor<OidcConfigurationContext> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAccessTokenTokenExchangeGrantRequestExtractor.class);

    public OidcAccessTokenTokenExchangeGrantRequestExtractor(ObjectProvider<OidcConfigurationContext> configurationContext) {
        super(configurationContext);
    }

    protected AccessTokenTokenExchangeGrantRequestExtractor.TokenExchangeRequest extractSubjectTokenExchangeRequest(WebContext webContext) throws Throwable {
        OidcConfigurationContext configurationContext = (OidcConfigurationContext)((Object)this.getConfigurationContext().getObject());
        OAuth20RequestParameterResolver requestParameterResolver = configurationContext.getRequestParameterResolver();
        OAuth20TokenExchangeTypes subjectTokenType = requestParameterResolver.resolveRequestParameter(webContext, "subject_token_type").map(OAuth20TokenExchangeTypes::from).orElseThrow();
        String subjectToken = (String)requestParameterResolver.resolveRequestParameter(webContext, "subject_token").orElseThrow(() -> new IllegalArgumentException("Subject token cannot be undefined"));
        if (subjectTokenType == OAuth20TokenExchangeTypes.ID_TOKEN) {
            UserProfile userProfile = (UserProfile)this.extractUserProfile(webContext).orElseThrow();
            String requestingClientId = userProfile.getId();
            String clientIdInIdToken = OAuth20Utils.extractClientIdFromToken((String)subjectToken);
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)configurationContext.getServicesManager(), (String)clientIdInIdToken);
            JwtClaims claimSet = configurationContext.getIdTokenSigningAndEncryptionService().decode(subjectToken, Optional.ofNullable(registeredService));
            WebApplicationService service = (WebApplicationService)configurationContext.getWebApplicationServiceServiceFactory().createService(claimSet.getIssuer());
            service.getAttributes().put("client_id", List.of(requestingClientId));
            userProfile.setId(claimSet.getSubject());
            claimSet.getClaimsMap().forEach((arg_0, arg_1) -> ((UserProfile)userProfile).addAttribute(arg_0, arg_1));
            Authentication authentication = configurationContext.getAuthenticationBuilder().build(userProfile, registeredService, webContext, (Service)service);
            OAuth20AccessTokenFactory accessTokenFactory = (OAuth20AccessTokenFactory)configurationContext.getTicketFactory().get(OAuth20AccessToken.class);
            Collection scopes = configurationContext.getRequestParameterResolver().resolveRequestedScopes(webContext);
            OAuth20AccessToken accessToken = accessTokenFactory.create((Service)service, authentication, scopes, requestingClientId, OAuth20ResponseTypes.NONE, OAuth20GrantTypes.TOKEN_EXCHANGE);
            OAuthRegisteredService requestedRegisteredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)configurationContext.getServicesManager(), (String)requestingClientId);
            return new AccessTokenTokenExchangeGrantRequestExtractor.TokenExchangeRequest((Serializable)accessToken, (Service)service, requestedRegisteredService, authentication);
        }
        return super.extractSubjectTokenExchangeRequest(webContext);
    }

    protected Authentication getActorTokenAuthentication(WebContext webContext, AccessTokenTokenExchangeGrantRequestExtractor.TokenExchangeRequest extractedRequest) throws Throwable {
        OidcConfigurationContext configurationContext = (OidcConfigurationContext)((Object)this.getConfigurationContext().getObject());
        Optional actorToken = configurationContext.getRequestParameterResolver().resolveRequestParameter(webContext, "actor_token");
        Optional<OAuth20TokenExchangeTypes> actorTokenType = configurationContext.getRequestParameterResolver().resolveRequestParameter(webContext, "actor_token_type").map(OAuth20TokenExchangeTypes::from);
        if (actorTokenType.isPresent() && actorTokenType.get() == OAuth20TokenExchangeTypes.DEVICE_SECRET) {
            Optional<OAuth20TokenExchangeTypes> subjectTokenType = configurationContext.getRequestParameterResolver().resolveRequestParameter(webContext, "subject_token_type").map(OAuth20TokenExchangeTypes::from);
            FunctionUtils.throwIf((subjectTokenType.isEmpty() || subjectTokenType.get() != OAuth20TokenExchangeTypes.ID_TOKEN ? 1 : 0) != 0, () -> new IllegalArgumentException("Subject token type is missing or not an ID token when actor token is %s".formatted(actorTokenType.get())));
            String subjectToken = (String)configurationContext.getRequestParameterResolver().resolveRequestParameter(webContext, "subject_token").orElseThrow(() -> new IllegalArgumentException("Subject token type cannot be undefined when actor token is provided"));
            String clientIdInIdToken = OAuth20Utils.extractClientIdFromToken((String)subjectToken);
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId((ServicesManager)configurationContext.getServicesManager(), (String)clientIdInIdToken);
            JwtClaims claims = configurationContext.getIdTokenSigningAndEncryptionService().decode(subjectToken, Optional.ofNullable(registeredService));
            Assert.isTrue((boolean)claims.hasClaim("ds_hash"), (String)"Subject token must contain the claim %s".formatted("ds_hash"));
            Assert.isTrue((boolean)claims.hasClaim("sid"), (String)"Subject token must contain the claim %s".formatted("sid"));
            Assert.isTrue((boolean)claims.hasClaim("sid_ref"), (String)"Subject token must contain the claim %s".formatted("sid_ref"));
            String deviceSecret = configurationContext.getDeviceSecretGenerator().hash((String)actorToken.orElseThrow());
            Assert.isTrue((boolean)Strings.CI.equals(deviceSecret, claims.getStringClaimValue("ds_hash")), (String)"Device secret hash does not match the subject token claim %s".formatted("ds_hash"));
            byte[] base64DecodedSessionId = EncodingUtils.decodeUrlSafeBase64((String)claims.getStringClaimValue("sid_ref"));
            String ticketGrantingTicketId = new String((byte[])configurationContext.getTicketRegistry().getCipherExecutor().decode((Object)base64DecodedSessionId), StandardCharsets.UTF_8);
            TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)configurationContext.getTicketRegistry().getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
            Assert.notNull((Object)ticketGrantingTicket, (String)"Ticket granting ticket cannot be null");
            return ticketGrantingTicket.getAuthentication();
        }
        return super.getActorTokenAuthentication(webContext, extractedRequest);
    }
}

