/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.ticket;

import java.io.Serializable;
import lombok.Generated;
import org.apereo.cas.oidc.ticket.OidcDefaultPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequest;
import org.apereo.cas.oidc.ticket.OidcPushedAuthorizationRequestFactory;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.crypto.DecodableCipher;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.SerializationUtils;

public class OidcDefaultPushedAuthorizationRequestFactory
implements OidcPushedAuthorizationRequestFactory {
    protected final UniqueTicketIdGenerator ticketIdGenerator;
    protected final ExpirationPolicyBuilder<OAuth20AccessToken> expirationPolicyBuilder;

    public Class<? extends Ticket> getTicketType() {
        return OidcPushedAuthorizationRequest.class;
    }

    @Override
    public OidcPushedAuthorizationRequest create(AccessTokenRequestContext holder) throws Throwable {
        byte[] request = SerializationUtils.serialize((Serializable)holder);
        String id = this.ticketIdGenerator.getNewTicketId("OPAR");
        ExpirationPolicy expirationPolicy = this.determineExpirationPolicyForService(holder.getRegisteredService());
        OidcDefaultPushedAuthorizationRequest par = new OidcDefaultPushedAuthorizationRequest(id, expirationPolicy, holder.getAuthentication(), holder.getService(), holder.getRegisteredService(), EncodingUtils.encodeBase64((byte[])request));
        par.setTenantId(holder.getService().getTenant());
        FunctionUtils.doIfNotNull((Object)holder.getService(), __ -> par.setTenantId(holder.getService().getTenant()));
        return par;
    }

    @Override
    public AccessTokenRequestContext toAccessTokenRequest(OidcPushedAuthorizationRequest authzRequest) {
        byte[] decodedRequest = EncodingUtils.decodeBase64((String)authzRequest.getAuthorizationRequest());
        return (AccessTokenRequestContext)SerializationUtils.decodeAndDeserializeObject((byte[])decodedRequest, (DecodableCipher)CipherExecutor.noOp(), AccessTokenRequestContext.class);
    }

    protected ExpirationPolicy determineExpirationPolicyForService(OAuthRegisteredService registeredService) {
        return this.expirationPolicyBuilder.buildTicketExpirationPolicy();
    }

    @Generated
    public OidcDefaultPushedAuthorizationRequestFactory(UniqueTicketIdGenerator ticketIdGenerator, ExpirationPolicyBuilder<OAuth20AccessToken> expirationPolicyBuilder) {
        this.ticketIdGenerator = ticketIdGenerator;
        this.expirationPolicyBuilder = expirationPolicyBuilder;
    }

    @Generated
    public UniqueTicketIdGenerator getTicketIdGenerator() {
        return this.ticketIdGenerator;
    }

    @Generated
    public ExpirationPolicyBuilder<OAuth20AccessToken> getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }
}

