/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcAddressScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcAssuranceScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcOfflineAccessScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcOpenIdScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcPhoneScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcScopeFreeAttributeReleasePolicy;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.util.ReflectionUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class DefaultOidcAttributeReleasePolicyFactory
implements OidcAttributeReleasePolicyFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOidcAttributeReleasePolicyFactory.class);
    protected final Map<String, BaseOidcScopeAttributeReleasePolicy> attributeReleasePoliciesByScope = new ConcurrentHashMap<String, BaseOidcScopeAttributeReleasePolicy>();
    protected final CasConfigurationProperties casProperties;

    public DefaultOidcAttributeReleasePolicyFactory(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
        OidcProperties oidc = casProperties.getAuthn().getOidc();
        String packageName = BaseOidcScopeAttributeReleasePolicy.class.getPackage().getName();
        Collection subTypes = ReflectionUtils.findSubclassesInPackage(BaseOidcScopeAttributeReleasePolicy.class, (String[])new String[]{packageName});
        subTypes.forEach(Unchecked.consumer(type -> {
            if (ClassUtils.hasConstructor((Class)type, (Class[])new Class[0])) {
                BaseOidcScopeAttributeReleasePolicy policyInstance = (BaseOidcScopeAttributeReleasePolicy)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (oidc.getDiscovery().getScopes().contains(policyInstance.getScopeType())) {
                    LOGGER.trace("Found standard OpenID Connect scope [{}] to filter attributes", (Object)policyInstance.getScopeType());
                    this.attributeReleasePoliciesByScope.put(policyInstance.getScopeType(), policyInstance);
                } else {
                    LOGGER.debug("OpenID Connect scope [{}] is not configured for use and will be ignored", (Object)policyInstance.getScopeType());
                }
            }
        }));
    }

    @Override
    public BaseOidcScopeAttributeReleasePolicy get(OidcConstants.StandardScopes scope) {
        return switch (scope) {
            default -> throw new MatchException(null, null);
            case OidcConstants.StandardScopes.EMAIL -> new OidcEmailScopeAttributeReleasePolicy();
            case OidcConstants.StandardScopes.ADDRESS -> new OidcAddressScopeAttributeReleasePolicy();
            case OidcConstants.StandardScopes.OPENID, OidcConstants.StandardScopes.DEVICE_SSO -> new OidcOpenIdScopeAttributeReleasePolicy();
            case OidcConstants.StandardScopes.PHONE -> new OidcPhoneScopeAttributeReleasePolicy();
            case OidcConstants.StandardScopes.PROFILE -> new OidcProfileScopeAttributeReleasePolicy();
            case OidcConstants.StandardScopes.ASSURANCE -> new OidcAssuranceScopeAttributeReleasePolicy();
            case OidcConstants.StandardScopes.OFFLINE_ACCESS -> new OidcOfflineAccessScopeAttributeReleasePolicy();
        };
    }

    @Override
    public OidcCustomScopeAttributeReleasePolicy custom(String name, List<String> allowedAttributes) {
        return new OidcCustomScopeAttributeReleasePolicy(name, allowedAttributes);
    }

    @Override
    public Collection<OidcCustomScopeAttributeReleasePolicy> getUserDefinedScopes() {
        return this.from(this.casProperties.getAuthn().getOidc().getCore().getUserDefinedScopes());
    }

    @Override
    public Map<String, BaseOidcScopeAttributeReleasePolicy> resolvePolicies(OidcRegisteredService registeredService) {
        HashMap<String, BaseOidcScopeAttributeReleasePolicy> policies = new HashMap<String, BaseOidcScopeAttributeReleasePolicy>(this.attributeReleasePoliciesByScope);
        Collection<OidcCustomScopeAttributeReleasePolicy> userScopes = this.getUserDefinedScopes();
        LOGGER.debug("Configuring attributes release policies for user-defined scopes [{}]", userScopes);
        userScopes.forEach(us -> policies.put(us.getScopeName(), (BaseOidcScopeAttributeReleasePolicy)us));
        LOGGER.debug("Configuring attributes release policies for user-defined scopes specified for service [{}]", (Object)registeredService.getName());
        ArrayList<OidcRegisteredServiceAttributeReleasePolicy> listOfOidcPolicies = new ArrayList<OidcRegisteredServiceAttributeReleasePolicy>();
        RegisteredServiceAttributeReleasePolicy registeredServiceAttributeReleasePolicy = registeredService.getAttributeReleasePolicy();
        if (registeredServiceAttributeReleasePolicy instanceof ChainingAttributeReleasePolicy) {
            ChainingAttributeReleasePolicy chain = (ChainingAttributeReleasePolicy)registeredServiceAttributeReleasePolicy;
            listOfOidcPolicies.addAll(chain.getPolicies().stream().filter(OidcRegisteredServiceAttributeReleasePolicy.class::isInstance).map(OidcRegisteredServiceAttributeReleasePolicy.class::cast).toList());
        } else {
            registeredServiceAttributeReleasePolicy = registeredService.getAttributeReleasePolicy();
            if (registeredServiceAttributeReleasePolicy instanceof OidcRegisteredServiceAttributeReleasePolicy) {
                OidcRegisteredServiceAttributeReleasePolicy policy2 = (OidcRegisteredServiceAttributeReleasePolicy)registeredServiceAttributeReleasePolicy;
                listOfOidcPolicies.add(policy2);
            }
        }
        listOfOidcPolicies.stream().filter(OidcCustomScopeAttributeReleasePolicy.class::isInstance).map(OidcCustomScopeAttributeReleasePolicy.class::cast).filter(policy -> !policies.containsKey(policy.getScopeName())).forEach(policy -> policies.put(policy.getScopeName(), (BaseOidcScopeAttributeReleasePolicy)policy));
        listOfOidcPolicies.stream().filter(OidcScopeFreeAttributeReleasePolicy.class::isInstance).map(OidcScopeFreeAttributeReleasePolicy.class::cast).forEach(policy -> policies.put(UUID.randomUUID().toString(), (BaseOidcScopeAttributeReleasePolicy)policy));
        LOGGER.debug("Final set of scopes mapped to attribute release policies are [{}]", policies.keySet());
        return policies;
    }
}

