/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.security.Key;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.discovery.OidcServerDiscoverySettings;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.token.BaseOidcJsonWebKeyTokenSigningAndEncryptionService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.util.jwt.JsonWebTokenEncryptor;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class OidcTokenIntrospectionSigningAndEncryptionService
extends BaseOidcJsonWebKeyTokenSigningAndEncryptionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcTokenIntrospectionSigningAndEncryptionService.class);
    private final OidcServerDiscoverySettings discoverySettings;

    public OidcTokenIntrospectionSigningAndEncryptionService(LoadingCache<OidcJsonWebKeyCacheKey, JsonWebKeySet> defaultJsonWebKeystoreCache, LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> serviceJsonWebKeystoreCache, OidcIssuerService issuerService, OidcServerDiscoverySettings discoverySettings, CasConfigurationProperties casProperties) {
        super(defaultJsonWebKeystoreCache, serviceJsonWebKeystoreCache, issuerService, casProperties);
        this.discoverySettings = discoverySettings;
    }

    public String getJsonWebKeySigningAlgorithm(OAuthRegisteredService registeredService, JsonWebKey jsonWebKey) {
        return (String)StringUtils.defaultIfBlank((CharSequence)registeredService.getIntrospectionSignedResponseAlg(), (CharSequence)"RS512");
    }

    protected String getSigningMediaType() {
        return MediaType.parseMediaType((String)"application/token-introspection+jwt").getSubtype();
    }

    public boolean shouldSignToken(OAuthRegisteredService registeredService) {
        if ("none".equalsIgnoreCase(registeredService.getIntrospectionSignedResponseAlg()) && !this.discoverySettings.getIntrospectionSignedResponseAlgValuesSupported().contains("none")) {
            LOGGER.error("Service [{}] has defined 'none' for introspection signing algorithm, yet CAS is configured to support the following signing algorithms: [{}]. This is quite likely due to misconfiguration of the CAS server or the service definition", (Object)registeredService.getServiceId(), this.discoverySettings.getIntrospectionSignedResponseAlgValuesSupported());
            throw new IllegalArgumentException("Unable to use 'none' as introspection signing algorithm");
        }
        return StringUtils.isNotBlank((CharSequence)registeredService.getIntrospectionSignedResponseAlg()) && !Strings.CI.equals(registeredService.getIntrospectionSignedResponseAlg(), "none");
    }

    public boolean shouldEncryptToken(OAuthRegisteredService registeredService) {
        if ("none".equalsIgnoreCase(registeredService.getIntrospectionEncryptedResponseAlg()) && !this.discoverySettings.getIntrospectionEncryptedResponseAlgValuesSupported().contains("none")) {
            LOGGER.error("Service [{}] has defined 'none' for introspection encryption algorithm, yet CAS is configured to support the following encryption algorithms: [{}]. This is quite likely due to misconfiguration of the CAS server or the service definition", (Object)registeredService.getServiceId(), this.discoverySettings.getIntrospectionEncryptedResponseAlgValuesSupported());
            throw new IllegalArgumentException("Unable to use 'none' as introspection encryption algorithm");
        }
        return StringUtils.isNotBlank((CharSequence)registeredService.getIntrospectionEncryptedResponseAlg()) && !Strings.CI.equals(registeredService.getIntrospectionEncryptedResponseAlg(), "none");
    }

    public Set<String> getAllowedSigningAlgorithms(OAuthRegisteredService registeredService) {
        return this.discoverySettings.getIntrospectionSignedResponseAlgValuesSupported();
    }

    @Override
    protected String encryptToken(OAuthRegisteredService registeredService, String innerJwt) {
        PublicJsonWebKey jsonWebKey = this.getJsonWebKeyForEncryption(registeredService);
        return JsonWebTokenEncryptor.builder().key((Key)jsonWebKey.getPublicKey()).keyId(jsonWebKey.getKeyId()).algorithm(registeredService.getIntrospectionEncryptedResponseAlg()).encryptionMethod(registeredService.getIntrospectionEncryptedResponseEncoding()).allowedAlgorithms(this.discoverySettings.getIntrospectionEncryptedResponseAlgValuesSupported()).allowedContentEncryptionAlgorithms(this.discoverySettings.getIntrospectionEncryptedResponseEncodingValuesSupported()).headers(Map.of("client_id", registeredService.getClientId())).build().encrypt((Serializable)((Object)innerJwt));
    }
}

