/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.federation;

import com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.federation.OidcFederationEntityStatementService;
import org.apereo.cas.oidc.web.controllers.BaseOidcController;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;

@Tag(name="OpenID Connect")
public class OidcWellKnownFederationEndpointController
extends BaseOidcController {
    private final OidcFederationEntityStatementService federationEntityStatementService;

    public OidcWellKnownFederationEndpointController(OidcConfigurationContext configurationContext, OidcFederationEntityStatementService federationEntityStatementService) {
        super(configurationContext);
        this.federationEntityStatementService = federationEntityStatementService;
    }

    @GetMapping(value={"/oidc/.well-known/openid-federation", "/**/.well-known/openid-federation"})
    @Operation(summary="Handle OIDC discovery federation request", description="Handles requests for well-known OIDC discovery federation configuration")
    public ResponseEntity getWellKnownDiscoveryConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, List.of(".well-known/openid-federation"))) {
            Map body = OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Accept", new String[]{"application/json"})).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((Object)body);
        }
        EntityStatement entityStatement = this.federationEntityStatementService.createAndSign();
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore().mustRevalidate())).header("Accept", new String[]{"application/jose;charset=UTF-8"})).contentType(MediaType.APPLICATION_FORM_URLENCODED).body((Object)entityStatement.getSignedStatement().serialize());
    }
}

