/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.web.flow.ForgotUsernameCaptchaWebflowConfigurer;
import org.apereo.cas.pm.web.flow.ForgotUsernameWebflowConfigurer;
import org.apereo.cas.pm.web.flow.actions.SendForgotUsernameInstructionsAction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CaptchaActivationStrategy;
import org.apereo.cas.web.CaptchaValidator;
import org.apereo.cas.web.DefaultCaptchaActivationStrategy;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.InitializeCaptchaAction;
import org.apereo.cas.web.flow.ValidateCaptchaAction;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.SpringWebflowActionExecutionAuditablePrincipalResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.ForgotUsername})
@Configuration(value="PasswordManagementForgotUsernameConfiguration", proxyBeanMethods=false)
class PasswordManagementForgotUsernameConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.pm.forgot-username.enabled").isTrue().evenIfMissing();

    PasswordManagementForgotUsernameConfiguration() {
    }

    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.ForgotUsername}, module="captcha")
    @Configuration(value="ForgotUsernameCaptchaConfiguration", proxyBeanMethods=false)
    static class ForgotUsernameCaptchaConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.pm.forgot-username.google-recaptcha.enabled").isTrue();

        ForgotUsernameCaptchaConfiguration() {
        }

        @ConditionalOnMissingBean(name={"forgotUsernameCaptchaWebflowConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CasWebflowConfigurer forgotUsernameCaptchaWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                ForgotUsernameCaptchaWebflowConfigurer configurer = new ForgotUsernameCaptchaWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
                configurer.setOrder(casProperties.getAuthn().getPm().getWebflow().getOrder() + 2);
                return configurer;
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"forgotUsernameValidateCaptchaAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action forgotUsernameValidateCaptchaAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="forgotUsernameCaptchaActivationStrategy") CaptchaActivationStrategy forgotUsernameCaptchaActivationStrategy) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                GoogleRecaptchaProperties recaptcha = casProperties.getAuthn().getPm().getForgotUsername().getGoogleRecaptcha();
                return new ValidateCaptchaAction(CaptchaValidator.getInstance((GoogleRecaptchaProperties)recaptcha), forgotUsernameCaptchaActivationStrategy);
            }).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"forgotUsernameInitializeCaptchaAction"})
        public Action forgotUsernameInitializeCaptchaAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="forgotUsernameCaptchaActivationStrategy") CaptchaActivationStrategy forgotUsernameCaptchaActivationStrategy, CasConfigurationProperties casProperties) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                GoogleRecaptchaProperties recaptcha = casProperties.getAuthn().getPm().getForgotUsername().getGoogleRecaptcha();
                return new InitializeCaptchaAction(forgotUsernameCaptchaActivationStrategy, requestContext -> WebUtils.putRecaptchaForgotUsernameEnabled((RequestContext)requestContext, (GoogleRecaptchaProperties)recaptcha), recaptcha);
            }).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"forgotUsernameCaptchaActivationStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CaptchaActivationStrategy forgotUsernameCaptchaActivationStrategy(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return (CaptchaActivationStrategy)BeanSupplier.of(CaptchaActivationStrategy.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DefaultCaptchaActivationStrategy(servicesManager)).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"forgotUsernameCaptchaWebflowExecutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer forgotUsernameCaptchaWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="forgotUsernameCaptchaWebflowConfigurer") CasWebflowConfigurer cfg) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(cfg)).otherwiseProxy().get();
        }
    }

    @Configuration(value="PasswordManagementForgotUsernameWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class PasswordManagementForgotUsernameWebflowConfiguration {
        PasswordManagementForgotUsernameWebflowConfiguration() {
        }

        @ConditionalOnMissingBean(name={"sendForgotUsernameInstructionsAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action sendForgotUsernameInstructionsAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new SendForgotUsernameInstructionsAction(casProperties, communicationsManager, passwordManagementService, defaultPrincipalResolver, tenantExtractor)).otherwise(() -> ConsumerExecutionAction.NONE).get();
        }

        @ConditionalOnMissingBean(name={"forgotUsernameWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer forgotUsernameWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new ForgotUsernameWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties)).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"forgotUsernameCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer forgotUsernameCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="forgotUsernameWebflowConfigurer") CasWebflowConfigurer forgotUsernameWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(forgotUsernameWebflowConfigurer)).otherwiseProxy().get();
        }
    }

    @Configuration(value="PasswordManagementForgotUsernameAuditConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class PasswordManagementForgotUsernameAuditConfiguration {
        PasswordManagementForgotUsernameAuditConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"forgotUsernameAuditTrailRecordResolutionPlanConfigurer"})
        public AuditTrailRecordResolutionPlanConfigurer forgotUsernameAuditTrailRecordResolutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="returnValueResourceResolver") AuditResourceResolver returnValueResourceResolver) {
            return (AuditTrailRecordResolutionPlanConfigurer)BeanSupplier.of(AuditTrailRecordResolutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                plan.registerAuditActionResolver("REQUEST_FORGOT_USERNAME_ACTION_RESOLVER", (AuditActionResolver)new DefaultAuditActionResolver());
                plan.registerAuditResourceResolver("REQUEST_FORGOT_USERNAME_RESOURCE_RESOLVER", returnValueResourceResolver);
                plan.registerAuditPrincipalResolver("REQUEST_FORGOT_USERNAME_PRINCIPAL_RESOLVER", (org.apereo.inspektr.common.spi.PrincipalResolver)new SpringWebflowActionExecutionAuditablePrincipalResolver("email"));
            }).otherwiseProxy().get();
        }
    }
}

