/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception.internal;

import java.sql.SQLException;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.JDBCException;
import org.hibernate.PessimisticLockException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.spi.AbstractSQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ConversionContext;
import org.hibernate.internal.util.JdbcExceptionHelper;

public class SQLStateConversionDelegate
extends AbstractSQLExceptionConversionDelegate {
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> SQL_GRAMMAR_CATEGORIES = SQLStateConversionDelegate.buildGrammarCategories();
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> DATA_CATEGORIES = SQLStateConversionDelegate.buildDataCategories();
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> INTEGRITY_VIOLATION_CATEGORIES = SQLStateConversionDelegate.buildContraintCategories();
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> CONNECTION_CATEGORIES = SQLStateConversionDelegate.buildConnectionCategories();

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> buildGrammarCategories() {
        return Set.of("07", "20", "2A", "37", "42", "65", "S0");
    }

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> buildDataCategories() {
        return Set.of("21", "22");
    }

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> buildContraintCategories() {
        return Set.of("23", "27", "44");
    }

    private static @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> buildConnectionCategories() {
        return Set.of("08");
    }

    public SQLStateConversionDelegate(@UnknownKeyFor @NonNull @Initialized ConversionContext conversionContext) {
        super(conversionContext);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized JDBCException convert(@UnknownKeyFor @NonNull @Initialized SQLException sqlException, @UnknownKeyFor @NonNull @Initialized String message, @UnknownKeyFor @NonNull @Initialized String sql) {
        String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
        int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
        if (sqlState != null) {
            String sqlStateClassCode = JdbcExceptionHelper.determineSqlStateClassCode(sqlState);
            if (sqlStateClassCode != null) {
                if (SQL_GRAMMAR_CATEGORIES.contains(sqlStateClassCode)) {
                    return new SQLGrammarException(message, sqlException, sql);
                }
                if (INTEGRITY_VIOLATION_CATEGORIES.contains(sqlStateClassCode)) {
                    String constraintName = this.getConversionContext().getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
                if (CONNECTION_CATEGORIES.contains(sqlStateClassCode)) {
                    return new JDBCConnectionException(message, sqlException, sql);
                }
                if (DATA_CATEGORIES.contains(sqlStateClassCode)) {
                    return new DataException(message, sqlException, sql);
                }
            }
            if ("40001".equals(sqlState)) {
                return new LockAcquisitionException(message, sqlException, sql);
            }
            if ("40XL1".equals(sqlState) || "40XL2".equals(sqlState)) {
                return new PessimisticLockException(message, sqlException, sql);
            }
            if ("70100".equals(sqlState) || "72000".equals(sqlState) && errorCode == 1013) {
                return new QueryTimeoutException(message, sqlException, sql);
            }
        }
        return null;
    }
}

