/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.web.exchanges;

import java.util.List;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.web.exchanges.HttpExchange;
import org.springframework.boot.actuate.web.exchanges.HttpExchangeRepository;
import org.springframework.util.Assert;

@Endpoint(id="httpexchanges")
public class HttpExchangesEndpoint {
    private final HttpExchangeRepository repository;

    public HttpExchangesEndpoint(HttpExchangeRepository repository) {
        Assert.notNull((Object)repository, (String)"'repository' must not be null");
        this.repository = repository;
    }

    @ReadOperation
    public HttpExchangesDescriptor httpExchanges() {
        return new HttpExchangesDescriptor(this.repository.findAll());
    }

    public static final class HttpExchangesDescriptor
    implements OperationResponseBody {
        private final List<HttpExchange> exchanges;

        private HttpExchangesDescriptor(List<HttpExchange> exchanges) {
            this.exchanges = exchanges;
        }

        public List<HttpExchange> getExchanges() {
            return this.exchanges;
        }
    }
}

